/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.osvr;

import com.jme3.app.VREnvironment;
import com.jme3.input.vr.VRInputAPI;
import com.jme3.input.vr.VRInputType;
import com.jme3.input.vr.VRTrackedController;
import com.jme3.input.vr.osvr.OSVRViewManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import com.jme3.system.osvr.osvrclientkit.OsvrClientKitLibrary;
import com.jme3.system.osvr.osvrclientreporttypes.OSVR_AnalogReport;
import com.jme3.system.osvr.osvrclientreporttypes.OSVR_ButtonReport;
import com.jme3.system.osvr.osvrclientreporttypes.OSVR_Pose3;
import com.jme3.system.osvr.osvrinterface.OsvrInterfaceLibrary;
import com.jme3.system.osvr.osvrtimevalue.OSVR_TimeValue;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.logging.Logger;

public class OSVRInput
implements VRInputAPI {
    private static final Logger logger = Logger.getLogger(OSVRInput.class.getName());
    private static final int ANALOG_COUNT = 3;
    private static final int BUTTON_COUNT = 7;
    private static final int CHANNEL_COUNT = 3;
    OsvrClientKitLibrary.OSVR_ClientInterface[][] buttons;
    OsvrClientKitLibrary.OSVR_ClientInterface[][][] analogs;
    OsvrClientKitLibrary.OSVR_ClientInterface[] hands;
    OSVR_Pose3[] handState;
    Callback buttonHandler;
    Callback analogHandler;
    OSVR_TimeValue tv = new OSVR_TimeValue();
    boolean[] isHandTracked = new boolean[2];
    private float[][][] analogState;
    private float[][] buttonState;
    private final Quaternion tempq = new Quaternion();
    private final Vector3f tempv = new Vector3f();
    private final Vector2f temp2 = new Vector2f();
    private final boolean[][] buttonDown = new boolean[16][16];
    private static final Vector2f temp2Axis = new Vector2f();
    private static final Vector2f[] lastCallAxis = new Vector2f[16];
    private static float axisMultiplier = 1.0f;
    private VREnvironment environment = null;
    public static byte[] leftHand = new byte[]{47, 109, 101, 47, 104, 97, 110, 100, 115, 47, 108, 101, 102, 116, 0};
    public static byte[] rightHand = new byte[]{47, 109, 101, 47, 104, 97, 110, 100, 115, 47, 114, 105, 103, 104, 116, 0};

    public static byte[] getButtonString(boolean left, byte index) {
        if (left) {
            return new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 108, 101, 102, 116, 47, index, 0};
        }
        return new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 114, 105, 103, 104, 116, 47, index, 0};
    }

    public OSVRInput(VREnvironment environment) {
        this.environment = environment;
    }

    @Override
    public boolean isButtonDown(int controllerIndex, VRInputType checkButton) {
        return this.buttonState[controllerIndex][checkButton.getValue()] != 0.0f;
    }

    @Override
    public boolean wasButtonPressedSinceLastCall(int controllerIndex, VRInputType checkButton) {
        boolean buttonDownNow = this.isButtonDown(controllerIndex, checkButton);
        int checkButtonValue = checkButton.getValue();
        boolean retval = buttonDownNow && !this.buttonDown[controllerIndex][checkButtonValue];
        this.buttonDown[controllerIndex][checkButtonValue] = buttonDownNow;
        return retval;
    }

    @Override
    public void resetInputSinceLastCall() {
        int i;
        for (i = 0; i < lastCallAxis.length; ++i) {
            OSVRInput.lastCallAxis[i].x = 0.0f;
            OSVRInput.lastCallAxis[i].y = 0.0f;
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.buttonDown[i][j] = false;
            }
        }
    }

    @Override
    public Vector2f getAxisDeltaSinceLastCall(int controllerIndex, VRInputType forAxis) {
        int axisIndex = forAxis.getValue();
        temp2Axis.set(lastCallAxis[axisIndex]);
        lastCallAxis[axisIndex].set(this.getAxis(controllerIndex, forAxis));
        if (!(OSVRInput.temp2Axis.x == 0.0f && OSVRInput.temp2Axis.y == 0.0f || OSVRInput.lastCallAxis[axisIndex].x == 0.0f && OSVRInput.lastCallAxis[axisIndex].y == 0.0f)) {
            temp2Axis.subtractLocal(lastCallAxis[axisIndex]);
        } else {
            OSVRInput.temp2Axis.x = 0.0f;
            OSVRInput.temp2Axis.y = 0.0f;
        }
        return temp2Axis;
    }

    @Override
    public Vector3f getVelocity(int controllerIndex) {
        return Vector3f.ZERO;
    }

    @Override
    public Vector3f getAngularVelocity(int controllerIndex) {
        return Vector3f.ZERO;
    }

    @Override
    public Vector2f getAxisRaw(int controllerIndex, VRInputType forAxis) {
        this.temp2.x = this.analogState[controllerIndex][forAxis.getValue()][0];
        this.temp2.y = this.analogState[controllerIndex][forAxis.getValue()][1];
        return this.temp2;
    }

    @Override
    public Vector2f getAxis(int controllerIndex, VRInputType forAxis) {
        this.temp2.x = this.analogState[controllerIndex][forAxis.getValue()][0] * axisMultiplier;
        this.temp2.y = this.analogState[controllerIndex][forAxis.getValue()][1] * axisMultiplier;
        return this.temp2;
    }

    private OsvrClientKitLibrary.OSVR_ClientInterface getInterface(byte[] str) {
        PointerByReference pbr = new PointerByReference();
        OsvrClientKitLibrary.osvrClientGetInterface((OsvrClientKitLibrary.OSVR_ClientContext)((Object)this.environment.getVRHardware().getVRSystem()), str, pbr);
        return new OsvrClientKitLibrary.OSVR_ClientInterface(pbr.getValue());
    }

    @Override
    public boolean init() {
        logger.config("Initialize OSVR input.");
        this.buttonHandler = new Callback(){

            public void invoke(Pointer userdata, Pointer timeval2, OSVR_ButtonReport report) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 7; ++j) {
                        if (OSVRInput.this.buttons[i][j] == null || !userdata.toString().equals(OSVRInput.this.buttons[i][j].getPointer().toString())) continue;
                        ((OSVRInput)OSVRInput.this).buttonState[i][j] = report.state;
                        return;
                    }
                }
            }
        };
        this.analogHandler = new Callback(){

            public void invoke(Pointer userdata, Pointer timeval2, OSVR_AnalogReport report) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            if (OSVRInput.this.analogs[i][j][k] == null || !userdata.toString().equals(OSVRInput.this.analogs[i][j][k].getPointer().toString())) continue;
                            ((OSVRInput)OSVRInput.this).analogState[i][j][k] = (float)report.state;
                            return;
                        }
                    }
                }
            }
        };
        this.buttons = new OsvrClientKitLibrary.OSVR_ClientInterface[2][7];
        this.analogs = new OsvrClientKitLibrary.OSVR_ClientInterface[2][3][3];
        this.buttonState = new float[2][7];
        this.analogState = new float[2][3][3];
        this.hands = new OsvrClientKitLibrary.OSVR_ClientInterface[2];
        this.hands[0] = this.getInterface(leftHand);
        this.hands[1] = this.getInterface(rightHand);
        this.handState = new OSVR_Pose3[2];
        this.handState[0] = new OSVR_Pose3();
        this.handState[1] = new OSVR_Pose3();
        for (int h = 0; h < 2; ++h) {
            for (int i = 0; i < 5; ++i) {
                this.buttons[h][i] = this.getInterface(OSVRInput.getButtonString(h == 0, (byte)Integer.toString(i).toCharArray()[0]));
                OsvrClientKitLibrary.osvrRegisterButtonCallback(this.buttons[h][i], this.buttonHandler, this.buttons[h][i].getPointer());
            }
        }
        this.buttons[0][5] = this.getInterface(new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 108, 101, 102, 116, 47, 98, 117, 109, 112, 101, 114, 0});
        OsvrClientKitLibrary.osvrRegisterButtonCallback(this.buttons[0][5], this.buttonHandler, this.buttons[0][5].getPointer());
        this.buttons[1][5] = this.getInterface(new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 114, 105, 103, 104, 116, 47, 98, 117, 109, 112, 101, 114, 0});
        OsvrClientKitLibrary.osvrRegisterButtonCallback(this.buttons[1][5], this.buttonHandler, this.buttons[1][5].getPointer());
        this.buttons[0][6] = this.getInterface(new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 108, 101, 102, 116, 47, 106, 111, 121, 115, 116, 105, 99, 107, 47, 98, 117, 116, 116, 111, 110, 0});
        OsvrClientKitLibrary.osvrRegisterButtonCallback(this.buttons[0][6], this.buttonHandler, this.buttons[0][6].getPointer());
        this.buttons[1][6] = this.getInterface(new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 114, 105, 103, 104, 116, 47, 106, 111, 121, 115, 116, 105, 99, 107, 47, 98, 117, 116, 116, 111, 110, 0});
        OsvrClientKitLibrary.osvrRegisterButtonCallback(this.buttons[1][6], this.buttonHandler, this.buttons[1][6].getPointer());
        this.analogs[0][0][0] = this.getInterface(new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 108, 101, 102, 116, 47, 116, 114, 105, 103, 103, 101, 114, 0});
        this.analogs[1][0][0] = this.getInterface(new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 114, 105, 103, 104, 116, 47, 116, 114, 105, 103, 103, 101, 114, 0});
        OsvrClientKitLibrary.osvrRegisterAnalogCallback(this.analogs[0][0][0], this.analogHandler, this.analogs[0][0][0].getPointer());
        OsvrClientKitLibrary.osvrRegisterAnalogCallback(this.analogs[1][0][0], this.analogHandler, this.analogs[1][0][0].getPointer());
        this.analogs[0][1][0] = this.getInterface(new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 108, 101, 102, 116, 47, 106, 111, 121, 115, 116, 105, 99, 107, 47, 120, 0});
        this.analogs[0][1][1] = this.getInterface(new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 108, 101, 102, 116, 47, 106, 111, 121, 115, 116, 105, 99, 107, 47, 121, 0});
        OsvrClientKitLibrary.osvrRegisterAnalogCallback(this.analogs[0][1][0], this.analogHandler, this.analogs[0][1][0].getPointer());
        OsvrClientKitLibrary.osvrRegisterAnalogCallback(this.analogs[0][1][1], this.analogHandler, this.analogs[0][1][1].getPointer());
        this.analogs[1][1][0] = this.getInterface(new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 114, 105, 103, 104, 116, 47, 106, 111, 121, 115, 116, 105, 99, 107, 47, 120, 0});
        this.analogs[1][1][1] = this.getInterface(new byte[]{47, 99, 111, 110, 116, 114, 111, 108, 108, 101, 114, 47, 114, 105, 103, 104, 116, 47, 106, 111, 121, 115, 116, 105, 99, 107, 47, 121, 0});
        OsvrClientKitLibrary.osvrRegisterAnalogCallback(this.analogs[1][1][0], this.analogHandler, this.analogs[1][1][0].getPointer());
        OsvrClientKitLibrary.osvrRegisterAnalogCallback(this.analogs[1][1][1], this.analogHandler, this.analogs[1][1][1].getPointer());
        return true;
    }

    @Override
    public int getTrackedControllerCount() {
        return (this.isHandTracked[0] ? 1 : 0) + (this.isHandTracked[1] ? 1 : 0);
    }

    @Override
    public void updateConnectedControllers() {
    }

    @Override
    public void updateControllerStates() {
        for (int i = 0; i < this.hands.length; ++i) {
            this.isHandTracked[i] = OsvrInterfaceLibrary.osvrGetPoseState(this.hands[i], this.tv, this.handState[i]) == 0;
        }
    }

    @Override
    public Object getRawControllerState(int index) {
        return this.handState[index];
    }

    @Override
    public boolean isInputFocused() {
        return true;
    }

    @Override
    public boolean isInputDeviceTracking(int index) {
        return this.isHandTracked[index];
    }

    @Override
    public Quaternion getOrientation(int index) {
        this.tempq.set((float)(-this.handState[index].rotation.data[1]), (float)this.handState[index].rotation.data[2], (float)(-this.handState[index].rotation.data[3]), (float)this.handState[index].rotation.data[0]);
        return this.tempq;
    }

    @Override
    public Vector3f getPosition(int index) {
        this.tempv.x = (float)(-this.handState[index].translation.data[0]);
        this.tempv.y = (float)this.handState[index].translation.data[1];
        this.tempv.z = (float)(-this.handState[index].translation.data[2]);
        return this.tempv;
    }

    @Override
    public Quaternion getFinalObserverRotation(int index) {
        OSVRViewManager vrvm = (OSVRViewManager)this.environment.getVRViewManager();
        if (vrvm == null || !this.isInputDeviceTracking(index)) {
            return null;
        }
        Object obs = this.environment.getObserver();
        if (obs instanceof Camera) {
            this.tempq.set(((Camera)obs).getRotation());
        } else {
            this.tempq.set(((Spatial)obs).getWorldRotation());
        }
        return this.tempq.multLocal(this.getOrientation(index));
    }

    @Override
    public Vector3f getFinalObserverPosition(int index) {
        OSVRViewManager vrvm = (OSVRViewManager)this.environment.getVRViewManager();
        if (vrvm == null || !this.isInputDeviceTracking(index)) {
            return null;
        }
        Object obs = this.environment.getObserver();
        Vector3f pos = this.getPosition(index);
        if (obs instanceof Camera) {
            ((Camera)obs).getRotation().mult(pos, pos);
            return pos.addLocal(((Camera)obs).getLocation());
        }
        ((Spatial)obs).getWorldRotation().mult(pos, pos);
        return pos.addLocal(((Spatial)obs).getWorldTranslation());
    }

    @Override
    public void triggerHapticPulse(int controllerIndex, float seconds) {
    }

    @Override
    public void swapHands() {
    }

    @Override
    public float getAxisMultiplier() {
        return axisMultiplier;
    }

    @Override
    public void setAxisMultiplier(float set) {
        axisMultiplier = set;
    }

    @Override
    public VRTrackedController getTrackedController(int index) {
        return null;
    }
}

