/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.PreNormalCaching;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;

public class CartoonSSAO
extends Filter {
    private Filter.Pass normalPass;
    private Vector3f frustumCorner;
    private Vector2f frustumNearFar;
    private boolean useOutline = true;
    private float downsample = 1.0f;
    private float applyDistance = 5.0E-4f;
    private boolean instancedRendering = false;
    RenderManager renderManager;
    ViewPort viewPort;

    public CartoonSSAO(boolean instancedRendering) {
        super("CartoonSSAO");
        this.instancedRendering = instancedRendering;
    }

    public CartoonSSAO(float downsample, boolean instancedRendering) {
        this(instancedRendering);
        this.downsample = downsample;
    }

    public CartoonSSAO(CartoonSSAO cloneFrom) {
        this(cloneFrom.downsample, cloneFrom.instancedRendering);
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected void postQueue(RenderQueue renderQueue) {
        PreNormalCaching.getPreNormals(this.renderManager, this.normalPass, this.viewPort);
    }

    public void setOutlineEnabled(boolean set) {
        this.useOutline = set;
        if (this.material != null) {
            if (this.useOutline) {
                this.material.clearParam("disableOutline");
            } else {
                this.material.setBoolean("disableOutline", true);
            }
        }
    }

    public boolean isOutlineEnabled() {
        return this.useOutline;
    }

    public void setDownsampling(float downsample) {
        this.downsample = downsample;
    }

    public float getDownsampling() {
        return this.downsample;
    }

    protected Material getMaterial() {
        return this.material;
    }

    public void setDistance(float dist) {
        this.applyDistance = dist;
        if (this.material != null) {
            this.material.setFloat("Distance", dist);
        }
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.renderManager = renderManager;
        this.viewPort = vp;
        int screenWidth = Math.round((float)w / this.downsample);
        int screenHeight = Math.round((float)h / this.downsample);
        this.normalPass = new Filter.Pass((Filter)this);
        this.normalPass.init(renderManager.getRenderer(), screenWidth, screenHeight, Image.Format.RGBA8, Image.Format.Depth);
        this.frustumNearFar = new Vector2f();
        float farY = vp.getCamera().getFrustumTop() / vp.getCamera().getFrustumNear() * vp.getCamera().getFrustumFar();
        float farX = farY * ((float)screenWidth / (float)screenHeight);
        this.frustumCorner = new Vector3f(farX, farY, vp.getCamera().getFrustumFar());
        this.frustumNearFar.x = vp.getCamera().getFrustumNear();
        this.frustumNearFar.y = vp.getCamera().getFrustumFar();
        this.material = new Material(manager, "Common/MatDefs/VR/CartoonSSAO.j3md");
        this.material.setTexture("Normals", (Texture)this.normalPass.getRenderedTexture());
        this.material.setVector3("FrustumCorner", this.frustumCorner);
        this.material.setVector2("FrustumNearFar", this.frustumNearFar);
        this.material.setFloat("Distance", this.applyDistance);
        if (!this.useOutline) {
            this.material.setBoolean("disableOutline", true);
        }
        if (this.instancedRendering) {
            this.material.setBoolean("useInstancing", true);
        }
    }
}

