/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.post.Filter;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.texture.FrameBuffer;

public class PreNormalCaching {
    private static FrameBuffer cachedPreNormals;
    private static int lastNormalPassesCount;
    private static int curCount;

    public static void getPreNormals(RenderManager renderManager, Filter.Pass normalPass, ViewPort viewPort) {
        ++curCount;
        Renderer r = renderManager.getRenderer();
        if (cachedPreNormals != null) {
            r.copyFrameBuffer(cachedPreNormals, normalPass.getRenderFrameBuffer(), false);
        } else {
            r.setFrameBuffer(normalPass.getRenderFrameBuffer());
            renderManager.getRenderer().clearBuffers(true, true, true);
            if (renderManager.getRenderer().getCaps().contains(Caps.GLSL150)) {
                renderManager.setForcedTechnique("PreNormalPass15");
            } else {
                renderManager.setForcedTechnique("PreNormalPass");
            }
            renderManager.renderViewPortQueues(viewPort, false);
            renderManager.setForcedTechnique(null);
            if (lastNormalPassesCount > 1) {
                cachedPreNormals = normalPass.getRenderFrameBuffer();
            }
        }
        renderManager.getRenderer().setFrameBuffer(viewPort.getOutputFrameBuffer());
    }

    public static void resetCache(boolean stereo) {
        if (!stereo) {
            lastNormalPassesCount = curCount;
        }
        cachedPreNormals = null;
        curCount = 0;
    }
}

