/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;

public class CenterQuad
extends Mesh {
    public static CenterQuad UnitQuad = new CenterQuad(0.5f, 0.5f);
    public static Mesh CenterSplitQuad;
    private float width;
    private float height;

    public CenterQuad(float width, float height) {
        this.updateGeometry(width, height);
    }

    public CenterQuad(float width, float height, boolean flipCoords) {
        this.updateGeometry(width, height, flipCoords);
        this.setStatic();
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public void updateGeometry(float width, float height) {
        this.updateGeometry(width, height, false);
    }

    public void updateGeometry(float width, float height, boolean flipCoords) {
        this.width = width;
        this.height = height;
        this.setBuffer(VertexBuffer.Type.Position, 3, new float[]{-width / 2.0f, -height / 2.0f, 0.0f, width / 2.0f, -height / 2.0f, 0.0f, width / 2.0f, height / 2.0f, 0.0f, -width / 2.0f, height / 2.0f, 0.0f});
        if (flipCoords) {
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
        } else {
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
        }
        this.setBuffer(VertexBuffer.Type.Normal, 3, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f});
        if (height < 0.0f) {
            this.setBuffer(VertexBuffer.Type.Index, 3, new short[]{0, 2, 1, 0, 3, 2});
        } else {
            this.setBuffer(VertexBuffer.Type.Index, 3, new short[]{0, 1, 2, 0, 2, 3});
        }
        this.updateBound();
    }
}

