/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector4f;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.shadow.AbstractShadowRendererVR;
import com.jme3.shadow.CompareMode;
import com.jme3.shadow.EdgeFilteringMode;
import com.jme3.texture.FrameBuffer;
import java.io.IOException;

public abstract class AbstractShadowFilterVR<T extends AbstractShadowRendererVR>
extends Filter {
    protected T shadowRenderer;
    protected ViewPort viewPort;
    Vector4f tmpv = new Vector4f();

    protected AbstractShadowFilterVR(AssetManager manager, int shadowMapSize, T shadowRenderer) {
        super("Post Shadow");
        this.material = new Material(manager, "Common/MatDefs/Shadow/PostShadowFilter.j3md");
        this.shadowRenderer = shadowRenderer;
        ((AbstractShadowRendererVR)this.shadowRenderer).setPostShadowMaterial(this.material);
        ((AbstractShadowRendererVR)this.shadowRenderer).setRenderBackFacesShadows(true);
    }

    protected AbstractShadowFilterVR(AssetManager manager, int shadowMapSize, T shadowRenderer, String useMatDef) {
        super("Post Shadow");
        this.material = new Material(manager, useMatDef);
        this.shadowRenderer = shadowRenderer;
        ((AbstractShadowRendererVR)this.shadowRenderer).setPostShadowMaterial(this.material);
    }

    protected Material getMaterial() {
        return this.material;
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    public Material getShadowMaterial() {
        return this.material;
    }

    protected void preFrame(float tpf) {
        ((AbstractShadowRendererVR)this.shadowRenderer).preFrame(tpf);
        this.material.setMatrix4("ViewProjectionMatrixInverse", this.viewPort.getCamera().getViewProjectionMatrix().invert());
        Matrix4f m = this.viewPort.getCamera().getViewProjectionMatrix();
        this.material.setVector4("ViewProjectionMatrixRow2", this.tmpv.set(m.m20, m.m21, m.m22, m.m23));
    }

    protected void postQueue(RenderQueue queue) {
        ((AbstractShadowRendererVR)this.shadowRenderer).postQueue(queue);
        if (((AbstractShadowRendererVR)this.shadowRenderer).skipPostPass) {
            this.material.setTexture("ShadowMap0", null);
        }
    }

    protected void postFrame(RenderManager renderManager, ViewPort viewPort, FrameBuffer prevFilterBuffer, FrameBuffer sceneBuffer) {
        if (!((AbstractShadowRendererVR)this.shadowRenderer).skipPostPass) {
            ((AbstractShadowRendererVR)this.shadowRenderer).setPostShadowParams();
        }
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        ((AbstractShadowRendererVR)this.shadowRenderer).needsfallBackMaterial = true;
        ((AbstractShadowRendererVR)this.shadowRenderer).initialize(renderManager, vp);
        this.viewPort = vp;
    }

    public float getShadowZExtend() {
        return ((AbstractShadowRendererVR)this.shadowRenderer).getShadowZExtend();
    }

    public void setShadowZExtend(float zFar) {
        ((AbstractShadowRendererVR)this.shadowRenderer).setShadowZExtend(zFar);
    }

    public void setShadowZFadeLength(float length) {
        ((AbstractShadowRendererVR)this.shadowRenderer).setShadowZFadeLength(length);
    }

    public float getShadowZFadeLength() {
        return ((AbstractShadowRendererVR)this.shadowRenderer).getShadowZFadeLength();
    }

    public float getShadowIntensity() {
        return ((AbstractShadowRendererVR)this.shadowRenderer).getShadowIntensity();
    }

    public final void setShadowIntensity(float shadowIntensity) {
        ((AbstractShadowRendererVR)this.shadowRenderer).setShadowIntensity(shadowIntensity);
    }

    public int getEdgesThickness() {
        return ((AbstractShadowRendererVR)this.shadowRenderer).getEdgesThickness();
    }

    public void setEdgesThickness(int edgesThickness) {
        ((AbstractShadowRendererVR)this.shadowRenderer).setEdgesThickness(edgesThickness);
    }

    @Deprecated
    public boolean isFlushQueues() {
        return ((AbstractShadowRendererVR)this.shadowRenderer).isFlushQueues();
    }

    @Deprecated
    public void setFlushQueues(boolean flushQueues) {
    }

    public final void setShadowCompareMode(CompareMode compareMode) {
        ((AbstractShadowRendererVR)this.shadowRenderer).setShadowCompareMode(compareMode);
    }

    public CompareMode getShadowCompareMode() {
        return ((AbstractShadowRendererVR)this.shadowRenderer).getShadowCompareMode();
    }

    public final void setEdgeFilteringMode(EdgeFilteringMode filterMode) {
        ((AbstractShadowRendererVR)this.shadowRenderer).setEdgeFilteringMode(filterMode);
    }

    public void setRenderBackFacesShadows(Boolean renderBackFacesShadows) {
        ((AbstractShadowRendererVR)this.shadowRenderer).setRenderBackFacesShadows(renderBackFacesShadows);
    }

    public boolean isRenderBackFacesShadows() {
        return ((AbstractShadowRendererVR)this.shadowRenderer).isRenderBackFacesShadows();
    }

    public RenderState getPreShadowForcedRenderState() {
        return ((AbstractShadowRendererVR)this.shadowRenderer).getPreShadowForcedRenderState();
    }

    public EdgeFilteringMode getEdgeFilteringMode() {
        return ((AbstractShadowRendererVR)this.shadowRenderer).getEdgeFilteringMode();
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
    }
}

