/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.DirectionalLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shadow.AbstractShadowRendererVR;
import com.jme3.shadow.PssmShadowUtil;
import com.jme3.shadow.ShadowUtil;
import java.io.IOException;

public class DirectionalLightShadowRendererVR
extends AbstractShadowRendererVR {
    protected float lambda = 0.65f;
    protected Camera shadowCam;
    protected ColorRGBA splits;
    protected float[] splitsArray;
    protected DirectionalLight light;
    protected Vector3f[] points = new Vector3f[8];
    private boolean stabilize = true;

    public DirectionalLightShadowRendererVR() {
    }

    public DirectionalLightShadowRendererVR(AssetManager assetManager, int shadowMapSize, int nbSplits) {
        super(assetManager, shadowMapSize, nbSplits);
        this.init(nbSplits, shadowMapSize);
    }

    private void init(int nbSplits, int shadowMapSize) {
        this.nbShadowMaps = Math.max(Math.min(nbSplits, 4), 1);
        if (this.nbShadowMaps != nbSplits) {
            throw new IllegalArgumentException("Number of splits must be between 1 and 4. Given value : " + nbSplits);
        }
        this.splits = new ColorRGBA();
        this.splitsArray = new float[nbSplits + 1];
        this.shadowCam = new Camera(shadowMapSize, shadowMapSize);
        this.shadowCam.setParallelProjection(true);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector3f();
        }
    }

    @Override
    protected void initFrustumCam() {
    }

    public DirectionalLight getLight() {
        return this.light;
    }

    public void setLight(DirectionalLight light) {
        this.light = light;
    }

    @Override
    protected void updateShadowCams(Camera viewCam) {
        float zFar = this.zFarOverride;
        if (zFar == 0.0f) {
            zFar = viewCam.getFrustumFar();
        }
        float frustumNear = Math.max(viewCam.getFrustumNear(), 0.001f);
        ShadowUtil.updateFrustumPoints((Camera)viewCam, (float)frustumNear, (float)zFar, (float)1.0f, (Vector3f[])this.points);
        this.shadowCam.getRotation().lookAt(this.light.getDirection(), this.shadowCam.getUp());
        this.shadowCam.update();
        this.shadowCam.updateViewProjection();
        PssmShadowUtil.updateFrustumSplits((float[])this.splitsArray, (float)frustumNear, (float)zFar, (float)this.lambda);
        if (viewCam.isParallelProjection()) {
            for (int i = 0; i < this.nbShadowMaps; ++i) {
                this.splitsArray[i] = this.splitsArray[i] / (zFar - frustumNear);
            }
        }
        switch (this.splitsArray.length) {
            case 5: {
                this.splits.a = this.splitsArray[4];
            }
            case 4: {
                this.splits.b = this.splitsArray[3];
            }
            case 3: {
                this.splits.g = this.splitsArray[2];
            }
            case 1: 
            case 2: {
                this.splits.r = this.splitsArray[1];
            }
        }
    }

    @Override
    protected GeometryList getOccludersToRender(int shadowMapIndex, GeometryList shadowMapOccluders) {
        ShadowUtil.updateFrustumPoints((Camera)this.viewPort.getCamera(), (float)this.splitsArray[shadowMapIndex], (float)this.splitsArray[shadowMapIndex + 1], (float)1.0f, (Vector3f[])this.points);
        if (this.lightReceivers.size() == 0) {
            for (Spatial scene : this.viewPort.getScenes()) {
                ShadowUtil.getGeometriesInCamFrustum((Spatial)scene, (Camera)this.viewPort.getCamera(), (RenderQueue.ShadowMode)RenderQueue.ShadowMode.Receive, (GeometryList)this.lightReceivers);
            }
        }
        ShadowUtil.updateShadowCamera((ViewPort)this.viewPort, (GeometryList)this.lightReceivers, (Camera)this.shadowCam, (Vector3f[])this.points, (GeometryList)shadowMapOccluders, (float)(this.stabilize ? this.shadowMapSize : 0.0f));
        return shadowMapOccluders;
    }

    @Override
    protected void getReceivers(GeometryList lightReceivers) {
        if (lightReceivers.size() == 0) {
            for (Spatial scene : this.viewPort.getScenes()) {
                ShadowUtil.getGeometriesInCamFrustum((Spatial)scene, (Camera)this.viewPort.getCamera(), (RenderQueue.ShadowMode)RenderQueue.ShadowMode.Receive, (GeometryList)lightReceivers);
            }
        }
    }

    @Override
    protected Camera getShadowCam(int shadowMapIndex) {
        return this.shadowCam;
    }

    @Override
    protected void doDisplayFrustumDebug(int shadowMapIndex) {
        ((Node)this.viewPort.getScenes().get(0)).attachChild((Spatial)this.createFrustum(this.points, shadowMapIndex));
        ShadowUtil.updateFrustumPoints2((Camera)this.shadowCam, (Vector3f[])this.points);
        ((Node)this.viewPort.getScenes().get(0)).attachChild((Spatial)this.createFrustum(this.points, shadowMapIndex));
    }

    @Override
    protected void setMaterialParameters(Material material) {
        material.setColor("Splits", this.splits);
        material.setVector3("LightDir", this.light.getDirection());
        if (this.fadeInfo != null) {
            material.setVector2("FadeInfo", this.fadeInfo);
        }
    }

    @Override
    protected void clearMaterialParameters(Material material) {
        material.clearParam("Splits");
        material.clearParam("FadeInfo");
        material.clearParam("LightDir");
    }

    public float getLambda() {
        return this.lambda;
    }

    public void setLambda(float lambda) {
        this.lambda = lambda;
    }

    public boolean isEnabledStabilization() {
        return this.stabilize;
    }

    public void setEnabledStabilization(boolean stabilize) {
        this.stabilize = stabilize;
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.lambda = ic.readFloat("lambda", 0.65f);
        this.zFarOverride = ic.readInt("zFarOverride", 0);
        this.light = (DirectionalLight)ic.readSavable("light", null);
        this.fadeInfo = (Vector2f)ic.readSavable("fadeInfo", null);
        this.fadeLength = ic.readFloat("fadeLength", 0.0f);
        this.init(this.nbShadowMaps, (int)this.shadowMapSize);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.lambda, "lambda", 0.65f);
        oc.write(this.zFarOverride, "zFarOverride", 0.0f);
        oc.write((Savable)this.light, "light", null);
        oc.write((Savable)this.fadeInfo, "fadeInfo", null);
        oc.write(this.fadeLength, "fadeLength", 0.0f);
    }

    @Override
    protected boolean checkCulling(Camera viewCam) {
        return true;
    }
}

