/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.app.Application;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Camera;
import com.jme3.shadow.DirectionalLightShadowFilterVR;
import com.jme3.shadow.DirectionalLightShadowRendererVR;

public class InstancedDirectionalShadowFilter
extends DirectionalLightShadowFilterVR {
    private final Vector4f temp4f = new Vector4f();
    private final Vector4f temp4f2 = new Vector4f();
    private boolean instanceRendering = false;
    private Camera rightCamera = null;

    public InstancedDirectionalShadowFilter(Application application, Camera camera, int shadowMapSize, int nbSplits, boolean instancedRendering, Camera rightCamera) {
        super(application.getAssetManager(), shadowMapSize, nbSplits, "Common/MatDefs/VR/PostShadowFilter.j3md");
        this.instanceRendering = instancedRendering;
        this.rightCamera = rightCamera;
    }

    @Override
    protected void preFrame(float tpf) {
        Matrix4f m;
        ((DirectionalLightShadowRendererVR)this.shadowRenderer).preFrame(tpf);
        if (this.instanceRendering) {
            this.material.setMatrix4("ViewProjectionMatrixInverseRight", this.rightCamera.getViewProjectionMatrix().invert());
            m = this.rightCamera.getViewProjectionMatrix();
            this.material.setVector4("ViewProjectionMatrixRow2Right", this.temp4f2.set(m.m20, m.m21, m.m22, m.m23));
        }
        this.material.setMatrix4("ViewProjectionMatrixInverse", this.viewPort.getCamera().getViewProjectionMatrix().invert());
        m = this.viewPort.getCamera().getViewProjectionMatrix();
        this.material.setVector4("ViewProjectionMatrixRow2", this.temp4f.set(m.m20, m.m21, m.m22, m.m23));
    }

    public boolean isInstanceRendering() {
        return this.instanceRendering;
    }

    public void setInstanceRendering(boolean instanceRendering) {
        this.instanceRendering = instanceRendering;
    }
}

