/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.input.lwjgl.GlfwJoystickInput;
import com.jme3.input.lwjgl.GlfwKeyInputVR;
import com.jme3.input.lwjgl.GlfwMouseInputVR;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.lwjgl.LwjglGL;
import com.jme3.renderer.lwjgl.LwjglGLExt;
import com.jme3.renderer.lwjgl.LwjglGLFboEXT;
import com.jme3.renderer.lwjgl.LwjglGLFboGL3;
import com.jme3.renderer.opengl.GL2;
import com.jme3.renderer.opengl.GL3;
import com.jme3.renderer.opengl.GL4;
import com.jme3.renderer.opengl.GLDebugDesktop;
import com.jme3.renderer.opengl.GLExt;
import com.jme3.renderer.opengl.GLFbo;
import com.jme3.renderer.opengl.GLRenderer;
import com.jme3.renderer.opengl.GLTiming;
import com.jme3.renderer.opengl.GLTimingState;
import com.jme3.renderer.opengl.GLTracer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.NativeLibraryLoader;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import com.jme3.system.lwjgl.LwjglGLDebugOutputHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;

public abstract class LwjglContextVR
implements JmeContext {
    private static final Logger logger = Logger.getLogger(LwjglContextVR.class.getName());
    protected static final String THREAD_NAME = "jME3 Main";
    protected AtomicBoolean created = new AtomicBoolean(false);
    protected AtomicBoolean renderable = new AtomicBoolean(false);
    protected final Object createdLock = new Object();
    protected AppSettings settings = new AppSettings(true);
    protected Renderer renderer;
    protected GlfwKeyInputVR keyInput;
    protected GlfwMouseInputVR mouseInput;
    protected GlfwJoystickInput joyInput;
    protected Timer timer;
    protected SystemListener listener;

    public void setSystemListener(SystemListener listener) {
        this.listener = listener;
    }

    protected void printContextInitInfo() {
        logger.log(Level.INFO, "LWJGL {0} context running on thread {1}\n * Graphics Adapter: GLFW {2}", new Object[]{Integer.toString(3), Thread.currentThread().getName(), GLFW.glfwGetVersionString()});
    }

    protected int determineMaxSamples() {
        logger.log(Level.SEVERE, "glfwExtensionSupported(\"GL_ARB_framebuffer_object\"): " + GLFW.glfwExtensionSupported((CharSequence)"GL_ARB_framebuffer_object"));
        logger.log(Level.SEVERE, "glfwExtensionSupported(\"GL_EXT_framebuffer_multisample\"): " + GLFW.glfwExtensionSupported((CharSequence)"GL_ARB_framebuffer_object"));
        if (GLFW.glfwExtensionSupported((CharSequence)"GL_ARB_framebuffer_object")) {
            return GL11.glGetInteger((int)36183);
        }
        if (GLFW.glfwExtensionSupported((CharSequence)"GL_EXT_framebuffer_multisample")) {
            return GL11.glGetInteger((int)36183);
        }
        return Integer.MAX_VALUE;
    }

    protected void loadNatives() {
        if (JmeSystem.isLowPermissions()) {
            return;
        }
        if ("LWJGL".equals(this.settings.getAudioRenderer())) {
            NativeLibraryLoader.loadNativeLibrary((String)"openal-lwjgl3", (boolean)true);
        }
        if (NativeLibraryLoader.isUsingNativeBullet()) {
            NativeLibraryLoader.loadNativeLibrary((String)"bulletjme", (boolean)true);
        }
        NativeLibraryLoader.loadNativeLibrary((String)"glfw-lwjgl3", (boolean)true);
        NativeLibraryLoader.loadNativeLibrary((String)"jemalloc-lwjgl3", (boolean)true);
        NativeLibraryLoader.loadNativeLibrary((String)"lwjgl3", (boolean)true);
    }

    public boolean isRetinaDisplay() {
        return GLFW.glfwGetVersionString().contains("retina");
    }

    protected int getNumSamplesToUse() {
        int samples = 0;
        if (this.settings.getSamples() > 1) {
            samples = this.settings.getSamples();
            int supportedSamples = this.determineMaxSamples();
            if (supportedSamples < samples) {
                logger.log(Level.WARNING, "Couldn't satisfy antialiasing samples requirement: x{0}. Video hardware only supports: x{1}", new Object[]{samples, supportedSamples});
                samples = supportedSamples;
            }
        }
        return samples;
    }

    protected void initContextFirstTime() {
        Object glfbo;
        LwjglGLExt glext;
        LwjglGL gl;
        GLCapabilities capabilities = GL.createCapabilities((boolean)this.settings.getRenderer().equals("LWJGL-OpenGL3"));
        if (!capabilities.OpenGL20) {
            throw new RendererException("OpenGL 2.0 or higher is required for jMonkeyEngine");
        }
        if (this.settings.getRenderer().equals("LWJGL-OpenGL2") || this.settings.getRenderer().equals("LWJGL-OpenGL3")) {
            gl = new LwjglGL();
            glext = new LwjglGLExt();
            glfbo = capabilities.OpenGL30 ? new LwjglGLFboGL3() : new LwjglGLFboEXT();
            if (this.settings.getBoolean("GraphicsDebug")) {
                gl = new GLDebugDesktop((com.jme3.renderer.opengl.GL)gl, (GLExt)glext, (GLFbo)glfbo);
                glext = (GLExt)gl;
                glfbo = (GLFbo)gl;
            }
            if (this.settings.getBoolean("GraphicsTiming")) {
                GLTimingState timingState = new GLTimingState();
                gl = (com.jme3.renderer.opengl.GL)GLTiming.createGLTiming((Object)gl, (GLTimingState)timingState, (Class[])new Class[]{com.jme3.renderer.opengl.GL.class, GL2.class, GL3.class, GL4.class});
                glext = (GLExt)GLTiming.createGLTiming((Object)glext, (GLTimingState)timingState, (Class[])new Class[]{GLExt.class});
                glfbo = (GLFbo)GLTiming.createGLTiming((Object)glfbo, (GLTimingState)timingState, (Class[])new Class[]{GLFbo.class});
            }
            if (this.settings.getBoolean("GraphicsTrace")) {
                gl = (com.jme3.renderer.opengl.GL)GLTracer.createDesktopGlTracer((Object)gl, (Class[])new Class[]{com.jme3.renderer.opengl.GL.class, GL2.class, GL3.class, GL4.class});
                glext = (GLExt)GLTracer.createDesktopGlTracer((Object)glext, (Class[])new Class[]{GLExt.class});
                glfbo = (GLFbo)GLTracer.createDesktopGlTracer((Object)glfbo, (Class[])new Class[]{GLFbo.class});
            }
        } else {
            throw new UnsupportedOperationException("Unsupported renderer: " + this.settings.getRenderer());
        }
        this.renderer = new GLRenderer((com.jme3.renderer.opengl.GL)gl, (GLExt)glext, (GLFbo)glfbo);
        this.renderer.initialize();
        if (capabilities.GL_ARB_debug_output && this.settings.getBoolean("GraphicsDebug")) {
            ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)new LwjglGLDebugOutputHandler(), (long)0L);
        }
        this.renderer.setMainFrameBufferSrgb(this.settings.isGammaCorrection());
        this.renderer.setLinearizeSrgbImages(this.settings.isGammaCorrection());
        if (this.keyInput != null) {
            this.keyInput.initialize();
        }
        if (this.mouseInput != null) {
            this.mouseInput.initialize();
        }
        if (this.joyInput != null) {
            this.joyInput.initialize();
        }
        this.renderable.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalDestroy() {
        this.renderer = null;
        this.timer = null;
        this.renderable.set(false);
        Object object = this.createdLock;
        synchronized (object) {
            this.created.set(false);
            this.createdLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCreate() {
        Object object = this.createdLock;
        synchronized (object) {
            this.created.set(true);
            this.createdLock.notifyAll();
        }
        this.initContextFirstTime();
    }

    public void create() {
        this.create(false);
    }

    public void destroy() {
        this.destroy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitFor(boolean createdVal) {
        Object object = this.createdLock;
        synchronized (object) {
            while (this.created.get() != createdVal) {
                try {
                    this.createdLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isCreated() {
        return this.created.get();
    }

    public boolean isRenderable() {
        return this.renderable.get();
    }

    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public Timer getTimer() {
        return this.timer;
    }
}

