/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.lwjgl.GlfwJoystickInput;
import com.jme3.input.lwjgl.GlfwKeyInputVR;
import com.jme3.input.lwjgl.GlfwMouseInputVR;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.NanoTimer;
import com.jme3.system.lwjgl.LwjglContextVR;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;

public abstract class LwjglWindowVR
extends LwjglContextVR
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(LwjglWindowVR.class.getName());
    protected AtomicBoolean needClose = new AtomicBoolean(false);
    protected final AtomicBoolean needRestart = new AtomicBoolean(false);
    protected boolean wasActive = false;
    protected boolean autoFlush = true;
    protected boolean allowSwapBuffers = false;
    private long window = 0L;
    private final JmeContext.Type type;
    private int frameRateLimit = -1;
    private double frameSleepTime;
    private GLFWErrorCallback errorCallback;
    private GLFWWindowSizeCallback windowSizeCallback;
    private GLFWWindowFocusCallback windowFocusCallback;
    private Thread mainThread;

    public LwjglWindowVR(JmeContext.Type type) {
        if (!(JmeContext.Type.Display.equals((Object)type) || JmeContext.Type.OffscreenSurface.equals((Object)type) || JmeContext.Type.Canvas.equals((Object)type))) {
            throw new IllegalArgumentException("Unsupported type '" + type.name() + "' provided");
        }
        this.type = type;
    }

    public JmeContext.Type getType() {
        return this.type;
    }

    public void setTitle(String title) {
        if (this.created.get() && this.window != 0L) {
            GLFW.glfwSetWindowTitle((long)this.window, (CharSequence)title);
        }
    }

    public void restart() {
        if (this.created.get()) {
            this.needRestart.set(true);
        } else {
            LOGGER.warning("Display is not created, cannot restart window.");
        }
    }

    protected void createContext(final AppSettings settings) {
        this.errorCallback = new GLFWErrorCallback(){

            public void invoke(int error, long description) {
                String message = GLFWErrorCallback.getDescription((long)description);
                LwjglWindowVR.this.listener.handleError(message, (Throwable)new Exception(message));
            }
        };
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.errorCallback);
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        if (settings.getBoolean("RendererDebug")) {
            GLFW.glfwWindowHint((int)139271, (int)1);
        }
        if (settings.isGammaCorrection()) {
            GLFW.glfwWindowHint((int)135182, (int)1);
        }
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)(settings.isResizable() ? 1 : 0));
        GLFW.glfwWindowHint((int)135184, (int)1);
        GLFW.glfwWindowHint((int)135173, (int)settings.getDepthBits());
        GLFW.glfwWindowHint((int)135174, (int)settings.getStencilBits());
        GLFW.glfwWindowHint((int)135181, (int)settings.getSamples());
        GLFW.glfwWindowHint((int)135180, (int)(settings.useStereo3D() ? 1 : 0));
        GLFW.glfwWindowHint((int)135183, (int)settings.getFrequency());
        if (settings.getBitsPerPixel() == 24) {
            GLFW.glfwWindowHint((int)135169, (int)8);
            GLFW.glfwWindowHint((int)135170, (int)8);
            GLFW.glfwWindowHint((int)135171, (int)8);
        } else if (settings.getBitsPerPixel() == 16) {
            GLFW.glfwWindowHint((int)135169, (int)5);
            GLFW.glfwWindowHint((int)135170, (int)6);
            GLFW.glfwWindowHint((int)135171, (int)5);
        }
        GLFW.glfwWindowHint((int)135172, (int)settings.getAlphaBits());
        long monitor = 0L;
        if (settings.isFullscreen()) {
            monitor = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode videoMode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
        if (settings.getWidth() <= 0 || settings.getHeight() <= 0) {
            settings.setResolution(videoMode.width(), videoMode.height());
        }
        this.window = GLFW.glfwCreateWindow((int)settings.getWidth(), (int)settings.getHeight(), (CharSequence)settings.getTitle(), (long)monitor, (long)0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        this.windowFocusCallback = new GLFWWindowFocusCallback(){

            public void invoke(long window, boolean focused) {
                if (LwjglWindowVR.this.wasActive != focused) {
                    if (!LwjglWindowVR.this.wasActive) {
                        LwjglWindowVR.this.listener.gainFocus();
                        LwjglWindowVR.this.timer.reset();
                        LwjglWindowVR.this.wasActive = true;
                    } else {
                        LwjglWindowVR.this.listener.loseFocus();
                        LwjglWindowVR.this.wasActive = false;
                    }
                }
            }
        };
        GLFW.glfwSetWindowFocusCallback((long)this.window, (GLFWWindowFocusCallbackI)this.windowFocusCallback);
        if (JmeContext.Type.Display.equals((Object)this.type) && !settings.isFullscreen()) {
            GLFW.glfwSetWindowPos((long)this.window, (int)((videoMode.width() - settings.getWidth()) / 2), (int)((videoMode.height() - settings.getHeight()) / 2));
        }
        GLFW.glfwMakeContextCurrent((long)this.window);
        if (settings.isVSync()) {
            GLFW.glfwSwapInterval((int)1);
        } else {
            GLFW.glfwSwapInterval((int)0);
        }
        if (JmeContext.Type.Display.equals((Object)this.type)) {
            GLFW.glfwShowWindow((long)this.window);
            GLFW.glfwFocusWindow((long)this.window);
        }
        this.windowSizeCallback = new GLFWWindowSizeCallback(){

            public void invoke(long window, int width, int height) {
                settings.setResolution(width, height);
                LwjglWindowVR.this.listener.reshape(width, height);
            }
        };
        GLFW.glfwSetWindowSizeCallback((long)this.window, (GLFWWindowSizeCallbackI)this.windowSizeCallback);
        this.allowSwapBuffers = settings.isSwapBuffers();
    }

    protected void destroyContext() {
        try {
            if (this.renderer != null) {
                this.renderer.cleanup();
            }
            if (this.errorCallback != null) {
                this.errorCallback.free();
                this.errorCallback = null;
            }
            if (this.windowSizeCallback != null) {
                this.windowSizeCallback.free();
                this.windowSizeCallback = null;
            }
            if (this.windowFocusCallback != null) {
                this.windowFocusCallback.free();
                this.windowFocusCallback = null;
            }
            if (this.window != 0L) {
                GLFW.glfwDestroyWindow((long)this.window);
                this.window = 0L;
            }
        }
        catch (Exception ex) {
            this.listener.handleError("Failed to destroy context", (Throwable)ex);
        }
    }

    public void create(boolean waitFor) {
        if (this.created.get()) {
            LOGGER.warning("create() called when display is already created!");
            return;
        }
        this.mainThread = Thread.currentThread();
        this.run();
    }

    protected boolean initInThread() {
        try {
            if (!JmeSystem.isLowPermissions()) {
                Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable thrown) {
                        LwjglWindowVR.this.listener.handleError("Uncaught exception thrown in " + thread.toString(), thrown);
                        if (LwjglWindowVR.this.needClose.get()) {
                            LwjglWindowVR.this.deinitInThread();
                        }
                    }
                });
            }
            this.loadNatives();
            this.timer = new NanoTimer();
            this.createContext(this.settings);
            this.printContextInitInfo();
            this.created.set(true);
            super.internalCreate();
        }
        catch (Exception ex) {
            try {
                if (this.window != 0L) {
                    GLFW.glfwDestroyWindow((long)this.window);
                    this.window = 0L;
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.WARNING, null, ex2);
            }
            this.listener.handleError("Failed to create display", (Throwable)ex);
            return false;
        }
        this.listener.initialize();
        return true;
    }

    protected void runLoop() {
        if (this.needRestart.getAndSet(false)) {
            try {
                this.destroyContext();
                this.createContext(this.settings);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to set display settings!", ex);
            }
            LOGGER.fine("Display restarted.");
        }
        if (!this.created.get()) {
            throw new IllegalStateException();
        }
        this.listener.update();
        if (this.renderable.get()) {
            try {
                if (this.allowSwapBuffers && this.autoFlush) {
                    GLFW.glfwSwapBuffers((long)this.window);
                }
            }
            catch (Throwable ex) {
                this.listener.handleError("Error while swapping buffers", ex);
            }
        }
        if (this.renderer != null) {
            this.renderer.postFrame();
        }
        if (this.autoFlush) {
            if (this.frameRateLimit != this.getSettings().getFrameRate()) {
                this.setFrameRateLimit(this.getSettings().getFrameRate());
            }
        } else if (this.frameRateLimit != 20) {
            this.setFrameRateLimit(20);
        }
        if (this.frameRateLimit > 0) {
            double sleep = this.frameSleepTime - (double)this.timer.getTimePerFrame() / 1000.0;
            long sleepMillis = (long)sleep;
            int additionalNanos = (int)((sleep - (double)sleepMillis) * 1000000.0);
            if (sleepMillis >= 0L && additionalNanos >= 0) {
                try {
                    Thread.sleep(sleepMillis, additionalNanos);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        GLFW.glfwPollEvents();
    }

    private void setFrameRateLimit(int frameRateLimit) {
        this.frameRateLimit = frameRateLimit;
        this.frameSleepTime = 1000.0 / (double)this.frameRateLimit;
    }

    protected void deinitInThread() {
        this.listener.destroy();
        this.destroyContext();
        super.internalDestroy();
        LOGGER.fine("Display destroyed.");
    }

    @Override
    public void run() {
        if (this.listener == null) {
            throw new IllegalStateException("SystemListener is not set on context!Must set with JmeContext.setSystemListener().");
        }
        LOGGER.log(Level.FINE, "Using LWJGL {0}", Version.getVersion());
        if (!this.initInThread()) {
            LOGGER.log(Level.SEVERE, "Display initialization failed. Cannot continue.");
            return;
        }
        while (true) {
            this.runLoop();
            if (this.needClose.get()) break;
            if (!GLFW.glfwWindowShouldClose((long)this.window)) continue;
            this.listener.requestClose(false);
        }
        this.deinitInThread();
    }

    public JoyInput getJoyInput() {
        if (this.joyInput == null) {
            this.joyInput = new GlfwJoystickInput();
        }
        return this.joyInput;
    }

    public MouseInput getMouseInput() {
        if (this.mouseInput == null) {
            this.mouseInput = new GlfwMouseInputVR(this);
        }
        return this.mouseInput;
    }

    public KeyInput getKeyInput() {
        if (this.keyInput == null) {
            this.keyInput = new GlfwKeyInputVR(this);
        }
        return this.keyInput;
    }

    public TouchInput getTouchInput() {
        return null;
    }

    public void setAutoFlushFrames(boolean enabled) {
        this.autoFlush = enabled;
    }

    public void destroy(boolean waitFor) {
        this.needClose.set(true);
        if (this.mainThread == Thread.currentThread()) {
            return;
        }
        if (waitFor) {
            this.waitFor(false);
        }
    }

    public long getWindowHandle() {
        return this.window;
    }
}

