/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.app.VREnvironment;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.CenterQuad;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.VRGUIPositioningMode;
import com.jme3.util.VRUtil;
import java.awt.GraphicsEnvironment;
import java.util.Iterator;

public class VRGuiManager {
    private Camera camLeft;
    private Camera camRight;
    private float guiDistance = 1.5f;
    private float guiScale = 1.0f;
    private float guiPositioningElastic;
    private VRGUIPositioningMode posMode = VRGUIPositioningMode.AUTO_CAM_ALL;
    private final Matrix3f orient = new Matrix3f();
    private Vector2f screenSize;
    protected boolean wantsReposition;
    private Vector2f ratio;
    private final Vector3f EoldPos = new Vector3f();
    private final Quaternion EoldDir = new Quaternion();
    private final Vector3f look = new Vector3f();
    private final Vector3f left = new Vector3f();
    private final Vector3f temppos = new Vector3f();
    private final Vector3f up = new Vector3f();
    private boolean useCurvedSurface = false;
    private boolean overdraw = false;
    private Geometry guiQuad;
    private Node guiQuadNode;
    private ViewPort offView;
    private Texture2D guiTexture;
    private final Quaternion tempq = new Quaternion();
    private VREnvironment environment = null;

    public VRGuiManager(VREnvironment environment) {
        this.environment = environment;
    }

    public boolean isWantsReposition() {
        return this.wantsReposition;
    }

    public void setWantsReposition(boolean wantsReposition) {
        this.wantsReposition = wantsReposition;
    }

    public void setPositioningElasticity(float elastic) {
        this.guiPositioningElastic = elastic;
    }

    public float getPositioningElasticity() {
        return this.guiPositioningElastic;
    }

    public VRGUIPositioningMode getPositioningMode() {
        return this.posMode;
    }

    public void setPositioningMode(VRGUIPositioningMode mode) {
        this.posMode = mode;
    }

    public Vector2f getCanvasSize() {
        if (this.environment != null) {
            if (this.environment.getApplication() != null) {
                if (this.screenSize == null) {
                    if (this.environment.isInVR() && this.environment.getVRHardware() != null) {
                        this.screenSize = new Vector2f();
                        this.environment.getVRHardware().getRenderSize(this.screenSize);
                        this.screenSize.multLocal(this.environment.getVRViewManager().getResolutionMuliplier());
                    } else {
                        AppSettings as = this.environment.getApplication().getContext().getSettings();
                        this.screenSize = new Vector2f((float)as.getWidth(), (float)as.getHeight());
                    }
                }
                return this.screenSize;
            }
            throw new IllegalStateException("VR GUI manager underlying environment is not attached to any application.");
        }
        throw new IllegalStateException("VR GUI manager is not attached to any environment.");
    }

    public Vector2f getCanvasToWindowRatio() {
        if (this.environment != null) {
            if (this.environment.getApplication() != null) {
                if (this.ratio == null) {
                    this.ratio = new Vector2f();
                    Vector2f canvas = this.getCanvasSize();
                    int width = Integer.min(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getWidth(), this.environment.getApplication().getContext().getSettings().getWidth());
                    int height = Integer.min(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getHeight(), this.environment.getApplication().getContext().getSettings().getHeight());
                    this.ratio.x = Float.max(1.0f, canvas.x / (float)width);
                    this.ratio.y = Float.max(1.0f, canvas.y / (float)height);
                }
                return this.ratio;
            }
            throw new IllegalStateException("VR GUI manager underlying environment is not attached to any application.");
        }
        throw new IllegalStateException("VR GUI manager is not attached to any environment.");
    }

    public void positionGui() {
        this.wantsReposition = true;
    }

    private void positionTo(Vector3f pos, Quaternion dir, float tpf) {
        if (this.environment != null) {
            Vector3f guiPos = this.guiQuadNode.getLocalTranslation();
            guiPos.set(0.0f, 0.0f, this.guiDistance);
            dir.mult(guiPos, guiPos);
            guiPos.x += pos.x;
            guiPos.y += pos.y + this.environment.getVRHeightAdjustment();
            guiPos.z += pos.z;
            if (this.guiPositioningElastic > 0.0f && this.posMode != VRGUIPositioningMode.MANUAL) {
                guiPos.interpolateLocal(this.EoldPos, guiPos, Float.min(1.0f, tpf * this.guiPositioningElastic));
                this.EoldPos.set(guiPos);
            }
        } else {
            throw new IllegalStateException("VR GUI manager is not attached to any environment.");
        }
    }

    public void updateGuiQuadGeometricState() {
        this.guiQuadNode.updateGeometricState();
    }

    public void positionGuiNow(float tpf) {
        if (this.environment != null) {
            this.wantsReposition = false;
            if (!this.environment.isInVR()) {
                return;
            }
            this.guiQuadNode.setLocalScale(this.guiDistance * this.guiScale * 4.0f, 4.0f * this.guiDistance * this.guiScale, 1.0f);
            switch (this.posMode) {
                case MANUAL: 
                case AUTO_CAM_ALL_SKIP_PITCH: 
                case AUTO_CAM_ALL: {
                    if (this.camLeft != null && this.camRight != null) {
                        this.temppos.set(this.camLeft.getLocation()).interpolateLocal(this.camRight.getLocation(), 0.5f);
                        this.positionTo(this.temppos, this.camLeft.getRotation(), tpf);
                    }
                    this.rotateScreenTo(this.camLeft.getRotation(), tpf);
                    break;
                }
                case AUTO_OBSERVER_POS_CAM_ROTATION: {
                    Object obs = this.environment.getObserver();
                    if (obs != null) {
                        if (obs instanceof Camera) {
                            this.positionTo(((Camera)obs).getLocation(), this.camLeft.getRotation(), tpf);
                        } else {
                            this.positionTo(((Spatial)obs).getWorldTranslation(), this.camLeft.getRotation(), tpf);
                        }
                    }
                    this.rotateScreenTo(this.camLeft.getRotation(), tpf);
                    break;
                }
                case AUTO_OBSERVER_ALL: 
                case AUTO_OBSERVER_ALL_CAMHEIGHT: {
                    Quaternion q;
                    Object obs = this.environment.getObserver();
                    if (obs == null) break;
                    if (obs instanceof Camera) {
                        q = ((Camera)obs).getRotation();
                        this.temppos.set(((Camera)obs).getLocation());
                    } else {
                        q = ((Spatial)obs).getWorldRotation();
                        this.temppos.set(((Spatial)obs).getWorldTranslation());
                    }
                    if (this.posMode == VRGUIPositioningMode.AUTO_OBSERVER_ALL_CAMHEIGHT) {
                        this.temppos.y = this.camLeft.getLocation().y;
                    }
                    this.positionTo(this.temppos, q, tpf);
                    this.rotateScreenTo(q, tpf);
                }
            }
        } else {
            throw new IllegalStateException("VR GUI manager is not attached to any environment.");
        }
    }

    private void rotateScreenTo(Quaternion dir, float tpf) {
        dir.getRotationColumn(2, this.look).negateLocal();
        dir.getRotationColumn(0, this.left).negateLocal();
        this.orient.fromAxes(this.left, dir.getRotationColumn(1, this.up), this.look);
        Quaternion rot = this.tempq.fromRotationMatrix(this.orient);
        if (this.posMode == VRGUIPositioningMode.AUTO_CAM_ALL_SKIP_PITCH) {
            VRUtil.stripToYaw(rot);
        }
        if (this.guiPositioningElastic > 0.0f && this.posMode != VRGUIPositioningMode.MANUAL) {
            this.EoldDir.nlerp(rot, tpf * this.guiPositioningElastic);
            this.guiQuadNode.setLocalRotation(this.EoldDir);
        } else {
            this.guiQuadNode.setLocalRotation(rot);
        }
    }

    public float getGuiDistance() {
        return this.guiDistance;
    }

    public void setGuiDistance(float newGuiDistance) {
        this.guiDistance = newGuiDistance;
    }

    public float getGUIScale() {
        return this.guiScale;
    }

    public void setGuiScale(float scale) {
        this.guiScale = scale;
    }

    public void adjustGuiDistance(float adjustAmount) {
        this.guiDistance += adjustAmount;
    }

    public void setupGui(Camera leftcam, Camera rightcam, ViewPort left, ViewPort right) {
        if (this.environment != null) {
            if (this.environment.hasTraditionalGUIOverlay()) {
                this.camLeft = leftcam;
                this.camRight = rightcam;
                Spatial guiScene = this.getGuiQuad(this.camLeft);
                left.attachScene(guiScene);
                if (right != null) {
                    right.attachScene(guiScene);
                }
                this.setPositioningMode(this.posMode);
            }
        } else {
            throw new IllegalStateException("VR GUI manager is not attached to any environment.");
        }
    }

    public boolean isCurverSurface() {
        return this.useCurvedSurface;
    }

    public void setCurvedSurface(boolean set) {
        this.useCurvedSurface = set;
    }

    public boolean isGuiOverdraw() {
        return this.overdraw;
    }

    public void setGuiOverdraw(boolean set) {
        this.overdraw = set;
    }

    private Spatial getGuiQuad(Camera sourceCam) {
        if (this.environment != null) {
            if (this.environment.getApplication() != null) {
                if (this.guiQuadNode == null) {
                    Vector2f guiCanvasSize = this.getCanvasSize();
                    Camera offCamera = sourceCam.clone();
                    offCamera.setParallelProjection(true);
                    offCamera.setLocation(Vector3f.ZERO);
                    offCamera.lookAt(Vector3f.UNIT_Z, Vector3f.UNIT_Y);
                    this.offView = this.environment.getApplication().getRenderManager().createPreView("GUI View", offCamera);
                    this.offView.setClearFlags(true, true, true);
                    this.offView.setBackgroundColor(ColorRGBA.BlackNoAlpha);
                    FrameBuffer offBuffer = new FrameBuffer((int)guiCanvasSize.x, (int)guiCanvasSize.y, 1);
                    this.guiTexture = new Texture2D((int)guiCanvasSize.x, (int)guiCanvasSize.y, Image.Format.RGBA8);
                    this.guiTexture.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                    this.guiTexture.setMagFilter(Texture.MagFilter.Bilinear);
                    offBuffer.setDepthBuffer(Image.Format.Depth);
                    offBuffer.setColorTexture(this.guiTexture);
                    this.offView.setOutputFrameBuffer(offBuffer);
                    Iterator spatialIter = this.environment.getApplication().getGuiViewPort().getScenes().iterator();
                    while (spatialIter.hasNext()) {
                        this.offView.attachScene((Spatial)spatialIter.next());
                    }
                    this.guiQuad = this.useCurvedSurface ? (Geometry)this.environment.getApplication().getAssetManager().loadModel("Common/Util/gui_mesh.j3o") : new Geometry("guiQuad", (Mesh)new CenterQuad(1.0f, 1.0f));
                    Material mat = new Material(this.environment.getApplication().getAssetManager(), "Common/MatDefs/VR/GuiOverlay.j3md");
                    mat.getAdditionalRenderState().setDepthTest(!this.overdraw);
                    mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
                    mat.getAdditionalRenderState().setDepthWrite(false);
                    mat.setTexture("ColorMap", (Texture)this.guiTexture);
                    this.guiQuad.setQueueBucket(RenderQueue.Bucket.Translucent);
                    this.guiQuad.setMaterial(mat);
                    this.guiQuadNode = new Node("gui-quad-node");
                    this.guiQuadNode.setQueueBucket(RenderQueue.Bucket.Translucent);
                    this.guiQuadNode.attachChild((Spatial)this.guiQuad);
                }
                return this.guiQuadNode;
            }
            throw new IllegalStateException("VR GUI manager underlying environment is not attached to any application.");
        }
        throw new IllegalStateException("VR GUI manager is not attached to any environment.");
    }
}

