/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.system.jopenvr.HmdMatrix34_t;
import com.jme3.system.jopenvr.HmdMatrix44_t;
import java.util.concurrent.TimeUnit;

public class VRUtil {
    private static final long SLEEP_PRECISION = TimeUnit.MILLISECONDS.toNanos(4L);
    private static final long SPIN_YIELD_PRECISION = TimeUnit.MILLISECONDS.toNanos(2L);

    public static void sleepNanos(long nanoDuration) {
        long end = System.nanoTime() + nanoDuration;
        long timeLeft = nanoDuration;
        do {
            try {
                if (timeLeft > SLEEP_PRECISION) {
                    Thread.sleep(1L);
                    continue;
                }
                if (timeLeft <= SPIN_YIELD_PRECISION) continue;
                Thread.sleep(0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while ((timeLeft = end - System.nanoTime()) > 0L);
    }

    public static Matrix4f convertSteamVRMatrix3ToMatrix4f(HmdMatrix34_t hmdMatrix, Matrix4f mat) {
        mat.set(hmdMatrix.m[0], hmdMatrix.m[1], hmdMatrix.m[2], hmdMatrix.m[3], hmdMatrix.m[4], hmdMatrix.m[5], hmdMatrix.m[6], hmdMatrix.m[7], hmdMatrix.m[8], hmdMatrix.m[9], hmdMatrix.m[10], hmdMatrix.m[11], 0.0f, 0.0f, 0.0f, 1.0f);
        return mat;
    }

    public static Matrix4f convertSteamVRMatrix4ToMatrix4f(HmdMatrix44_t hmdMatrix, Matrix4f mat) {
        mat.set(hmdMatrix.m[0], hmdMatrix.m[1], hmdMatrix.m[2], hmdMatrix.m[3], hmdMatrix.m[4], hmdMatrix.m[5], hmdMatrix.m[6], hmdMatrix.m[7], hmdMatrix.m[8], hmdMatrix.m[9], hmdMatrix.m[10], hmdMatrix.m[11], hmdMatrix.m[12], hmdMatrix.m[13], hmdMatrix.m[14], hmdMatrix.m[15]);
        return mat;
    }

    public static void convertMatrix4toQuat(Matrix4f in, Quaternion out) {
        out.fromRotationMatrix(in.m00, in.m01, in.m02, in.m10, in.m11, in.m12, in.m20, in.m21, in.m22);
        out.set(-out.getX(), out.getY(), -out.getZ(), out.getW());
    }

    public static Quaternion FastFullAngles(Quaternion use, float yaw, float pitch, float roll) {
        float angle = roll * 0.5f;
        float sinPitch = (float)Math.sin(angle);
        float cosPitch = (float)Math.cos(angle);
        angle = yaw * 0.5f;
        float sinRoll = (float)Math.sin(angle);
        float cosRoll = (float)Math.cos(angle);
        angle = pitch * 0.5f;
        float sinYaw = (float)Math.sin(angle);
        float cosYaw = (float)Math.cos(angle);
        float cosRollXcosPitch = cosRoll * cosPitch;
        float sinRollXsinPitch = sinRoll * sinPitch;
        float cosRollXsinPitch = cosRoll * sinPitch;
        float sinRollXcosPitch = sinRoll * cosPitch;
        use.set(cosRollXcosPitch * sinYaw + sinRollXsinPitch * cosYaw, sinRollXcosPitch * cosYaw + cosRollXsinPitch * sinYaw, cosRollXsinPitch * cosYaw - sinRollXcosPitch * sinYaw, cosRollXcosPitch * cosYaw - sinRollXsinPitch * sinYaw);
        return use;
    }

    public static Quaternion stripToYaw(Quaternion q) {
        float sqw;
        float sqz;
        float sqy;
        float sqx;
        float unit;
        float z;
        float y;
        float w = q.getW();
        float x = q.getX();
        float test = x * (y = q.getY()) + (z = q.getZ()) * w;
        float yaw = (double)test > 0.499 * (double)(unit = (sqx = x * x) + (sqy = y * y) + (sqz = z * z) + (sqw = w * w)) ? 2.0f * FastMath.atan2((float)x, (float)w) : ((double)test < -0.499 * (double)unit ? -2.0f * FastMath.atan2((float)x, (float)w) : FastMath.atan2((float)(2.0f * y * w - 2.0f * x * z), (float)(sqx - sqy - sqz + sqw)));
        VRUtil.FastFullAngles(q, yaw, 0.0f, 0.0f);
        return q;
    }
}

