/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.algorithms.JointTorqueRegressorCalculator;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;

public class JointTorqueRegressorCalculatorTest {
    private static final int STATE_ITERATIONS = 100;
    private static final int SYSTEM_ITERATIONS = 5;
    private static final double EPSILON = 1.0E-12;
    private static final int WARMUP_ITERATIONS = 100;
    private static final int ITERATIONS = 1000;

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsSimple() {
        Random random = new Random(25L);
        int numberOfJoints = 2;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        for (JointStateType stateToRandomize : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)system.getAllJoints());
        }
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
        inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
        inverseDynamicsCalculator.compute();
        DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
        JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
        DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
        regressorCalculator.setGravitationalAcceleration(-9.81);
        regressorCalculator.compute();
        DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
        DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
        Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
        Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
    }

    @Test
    public void testThrowsUnsupportedOperationExceptionWithKinematicLoop() {
        Random random = new Random(25L);
        int numberOfJoints = 10;
        List joints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
        int loopStartIndex = 2;
        int loopEndIndex = 7;
        int kinematicLoopSize = 5;
        RigidBodyBasics loopStart = ((RevoluteJoint)joints.get(loopStartIndex)).getSuccessor();
        RigidBodyBasics loopEnd = ((RevoluteJoint)joints.get(loopEndIndex)).getSuccessor();
        List loop = MultiBodySystemRandomTools.nextKinematicLoopRevoluteJoints((Random)random, (String)"loop", (RigidBodyBasics)loopStart, (RigidBodyBasics)loopEnd, (int)kinematicLoopSize);
        joints.addAll(loop);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        try {
            JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
            Assertions.fail((String)"Should have thrown an exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsOneDoFJointChain() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType stateToRandomize : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setGravitationalAcceleration(-9.81);
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void benchmarkOneDoFJointChain() {
        int i;
        Random random = new Random(25L);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)30);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        JointTorqueRegressorCalculator calculator = new JointTorqueRegressorCalculator(system);
        calculator.setGravitationalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 100; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 1000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        LogTools.info((String)("1-DoF chain: Took on average per iteration: " + (double)totalTime / 1.0E9 / 1000.0 + " seconds"));
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsFloatingOneDoFJointChain() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
            RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
            joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
            RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
            joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (RigidBodyBasics)floatingBody, (int)numberOfJoints));
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType stateToRandomize : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setGravitationalAcceleration(-9.81);
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void benchmarkForFloatingOneDoFJointChain() {
        int i;
        Random random = new Random(25L);
        ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
        RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
        joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (RigidBodyBasics)floatingBody, (int)30));
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
        JointTorqueRegressorCalculator calculator = new JointTorqueRegressorCalculator(system);
        calculator.setGravitationalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 100; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 1000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        LogTools.info((String)("Floating 1-DoF chain: Took on average per iteration: " + (double)totalTime / 1.0E9 / 1000.0 + " seconds"));
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsOneDoFJointTree() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType stateToRandomize : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setGravitationalAcceleration(-9.81);
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void benchmarkForOneDoFJointTree() {
        int i;
        Random random = new Random(25L);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)30);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        JointTorqueRegressorCalculator calculator = new JointTorqueRegressorCalculator(system);
        calculator.setGravitationalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 100; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 1000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        LogTools.info((String)("1-DoF tree: Took on average per iteration: " + (double)totalTime / 1.0E9 / 1000.0 + " seconds"));
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsFloatingOneDoFJointTree() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
            RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
            joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
            RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
            joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (RigidBodyBasics)floatingBody, (int)numberOfJoints));
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType stateToRandomize : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setGravitationalAcceleration(-9.81);
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void benchmarkForFloatingOneDoFJointTree() {
        int i;
        Random random = new Random(25L);
        ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
        RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
        joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (RigidBodyBasics)floatingBody, (int)30));
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
        JointTorqueRegressorCalculator calculator = new JointTorqueRegressorCalculator(system);
        calculator.setGravitationalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 100; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 1000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        LogTools.info((String)("Floating 1-DoF tree: Took on average per iteration: " + (double)totalTime / 1.0E9 / 1000.0 + " seconds"));
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsOneDoFJointChainWithExternalWrenches() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType stateToRandomize : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                LinkedHashMap<RigidBodyBasics, Wrench> rigidBodiesToExternalWrenchMap = new LinkedHashMap<RigidBodyBasics, Wrench>();
                for (RigidBodyBasics body : system.getRootBody().subtreeArray()) {
                    if (body.getInertia() == null || !random.nextBoolean()) continue;
                    Wrench wrenchToApply = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)body.getBodyFixedFrame(), (ReferenceFrame)body.getBodyFixedFrame());
                    inverseDynamicsCalculator.setExternalWrench((RigidBodyReadOnly)body, (WrenchReadOnly)wrenchToApply);
                    rigidBodiesToExternalWrenchMap.put(body, wrenchToApply);
                }
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setGravitationalAcceleration(-9.81);
                LinkedHashMap<RigidBodyReadOnly, DMatrixRMaj> rigidBodyToContactJacobianMap = new LinkedHashMap<RigidBodyReadOnly, DMatrixRMaj>();
                GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
                DMatrixRMaj torques = new DMatrixRMaj(system.getNumberOfDoFs());
                for (RigidBodyReadOnly body : rigidBodiesToExternalWrenchMap.keySet()) {
                    jacobianCalculator.setKinematicChain((RigidBodyReadOnly)system.getRootBody(), body);
                    jacobianCalculator.getJointTorques((WrenchReadOnly)rigidBodiesToExternalWrenchMap.get(body), (DMatrix1Row)torques);
                    rigidBodyToContactJacobianMap.put(body, new DMatrixRMaj(torques));
                    ((DMatrixRMaj)rigidBodyToContactJacobianMap.get(body)).reshape(system.getNumberOfDoFs(), 1, true);
                }
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                for (DMatrixRMaj torque : rigidBodyToContactJacobianMap.values()) {
                    CommonOps_DDRM.add((DMatrixD1)actualJointTau, (double)-1.0, (DMatrixD1)torque, (DMatrixD1)actualJointTau);
                }
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testSpatialInertiaParameterBasis() {
        DMatrixRMaj expectedBasis = new DMatrixRMaj(6, 6);
        DMatrixRMaj actualBasis = new DMatrixRMaj(6, 6);
        int numberOfJoints = 1;
        Random random = new Random(25L);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        RigidBodyBasics body = system.findRigidBody("Body0");
        JointTorqueRegressorCalculator.SpatialInertiaParameterBasis basis = new JointTorqueRegressorCalculator.SpatialInertiaParameterBasis(body);
        block12: for (JointTorqueRegressorCalculator.SpatialInertiaBasisOption basisOption : JointTorqueRegressorCalculator.SpatialInertiaBasisOption.values) {
            switch (basisOption) {
                case M: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case MCOM_X: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, -1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, -1.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case MCOM_Y: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, -1.0, 0.0, 0.0}, {0.0, 0.0, -1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case MCOM_Z: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, -1.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {-1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_XX: {
                    double[][] expectedBasisToPack = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_YY: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_ZZ: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_XY: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_XZ: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_YZ: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                }
            }
        }
    }
}

