/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.algorithms.SpatialAccelerationCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class SpatialAccelerationCalculatorTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 1000;

    @Test
    public void testWithChainComposedOfPrismaticJoints() throws Exception {
        Random random = new Random(234234L);
        int numberOfJoints = 20;
        List prismaticJoints = MultiBodySystemRandomTools.nextPrismaticJointChain((Random)random, (int)numberOfJoints);
        RigidBodyBasics randomBody = ((PrismaticJoint)prismaticJoints.get(random.nextInt(numberOfJoints))).getPredecessor();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)randomBody);
        boolean doAccelerationTerms = true;
        for (int i = 0; i < 1000; ++i) {
            boolean doVelocityTerms = random.nextBoolean();
            FrameVector3D rootLinearAcceleration = new FrameVector3D((ReferenceFrame)rootBody.getBodyFixedFrame(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
            FrameVector3D rootAngularAcceleration = new FrameVector3D((ReferenceFrame)rootBody.getBodyFixedFrame(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
            SpatialAcceleration rootAcceleration = new SpatialAcceleration((ReferenceFrame)rootBody.getBodyFixedFrame(), worldFrame, (ReferenceFrame)rootBody.getBodyFixedFrame());
            rootAcceleration.set((FrameVector3DReadOnly)rootAngularAcceleration, (FrameVector3DReadOnly)rootLinearAcceleration);
            SpatialAccelerationCalculator calculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)randomBody, worldFrame, doVelocityTerms, doAccelerationTerms);
            calculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
            for (JointStateType stateSelection : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateSelection, (double)-10.0, (double)10.0, (Iterable)prismaticJoints);
            }
            rootBody.updateFramesRecursively();
            calculator.reset();
            FrameVector3D cumulatedLinearAcceleration = new FrameVector3D((FrameTuple3DReadOnly)rootLinearAcceleration);
            for (PrismaticJoint joint : prismaticJoints) {
                RigidBodyBasics body = joint.getSuccessor();
                SpatialAcceleration actualAcceleration = new SpatialAcceleration();
                actualAcceleration.setIncludingFrame((SpatialMotionReadOnly)calculator.getAccelerationOfBody((RigidBodyReadOnly)body));
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                SpatialAcceleration expectedAcceleration = new SpatialAcceleration((ReferenceFrame)bodyFrame, worldFrame, (ReferenceFrame)bodyFrame);
                FrameVector3DReadOnly jointAxis = joint.getJointAxis();
                cumulatedLinearAcceleration.changeFrame(jointAxis.getReferenceFrame());
                double qdd = joint.getQdd();
                cumulatedLinearAcceleration.scaleAdd(qdd, (FrameTuple3DReadOnly)jointAxis, (FrameTuple3DReadOnly)cumulatedLinearAcceleration);
                cumulatedLinearAcceleration.changeFrame((ReferenceFrame)bodyFrame);
                expectedAcceleration.getLinearPart().set((FrameTuple3DReadOnly)cumulatedLinearAcceleration);
                FramePoint3D rootPosition = new FramePoint3D((ReferenceFrame)rootBody.getBodyFixedFrame());
                rootPosition.changeFrame((ReferenceFrame)bodyFrame);
                rootAngularAcceleration.changeFrame((ReferenceFrame)bodyFrame);
                Vector3D crossPart = new Vector3D();
                crossPart.cross((Tuple3DReadOnly)new Vector3D((Tuple3DReadOnly)rootPosition), (Tuple3DReadOnly)rootAngularAcceleration);
                expectedAcceleration.getLinearPart().add((Tuple3DReadOnly)crossPart);
                expectedAcceleration.getAngularPart().set((FrameTuple3DReadOnly)rootAngularAcceleration);
                SpatialAccelerationCalculatorTest.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)actualAcceleration, 1.0E-12);
            }
        }
    }

    @Test
    public void testWithChainComposedOfRevoluteJointsAssertAngularAccelerationOnly() throws Exception {
        double qdd;
        FrameVector3DReadOnly jointAxis;
        SpatialAcceleration expectedAcceleration;
        MovingReferenceFrame bodyFrame;
        SpatialAcceleration actualAcceleration;
        RigidBodyBasics body;
        FrameVector3D cumulatedAngularAcceleration;
        SpatialAccelerationCalculator calculator;
        SpatialAcceleration rootAcceleration;
        FrameVector3D rootAngularAcceleration;
        FrameVector3D rootLinearAcceleration;
        boolean doVelocityTerms;
        int i;
        Random random = new Random(234234L);
        int numberOfJoints = 20;
        List revoluteJoints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
        RigidBodyBasics randomBody = ((RevoluteJoint)revoluteJoints.get(random.nextInt(numberOfJoints))).getPredecessor();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)randomBody);
        boolean doAccelerationTerms = true;
        for (i = 0; i < 1000; ++i) {
            doVelocityTerms = random.nextBoolean();
            rootLinearAcceleration = new FrameVector3D((ReferenceFrame)rootBody.getBodyFixedFrame(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
            rootAngularAcceleration = new FrameVector3D((ReferenceFrame)rootBody.getBodyFixedFrame(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
            rootAcceleration = new SpatialAcceleration((ReferenceFrame)rootBody.getBodyFixedFrame(), worldFrame, (ReferenceFrame)rootBody.getBodyFixedFrame());
            rootAcceleration.set((FrameVector3DReadOnly)rootAngularAcceleration, (FrameVector3DReadOnly)rootLinearAcceleration);
            calculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)randomBody, worldFrame, doVelocityTerms, doAccelerationTerms);
            calculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
            for (JointStateType stateSelection : new JointStateType[]{JointStateType.CONFIGURATION, JointStateType.ACCELERATION}) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateSelection, (double)-10.0, (double)10.0, (Iterable)revoluteJoints);
            }
            rootBody.updateFramesRecursively();
            calculator.reset();
            cumulatedAngularAcceleration = new FrameVector3D((FrameTuple3DReadOnly)rootAngularAcceleration);
            for (RevoluteJoint joint : revoluteJoints) {
                body = joint.getSuccessor();
                actualAcceleration = new SpatialAcceleration();
                actualAcceleration.setIncludingFrame((SpatialMotionReadOnly)calculator.getAccelerationOfBody((RigidBodyReadOnly)body));
                bodyFrame = body.getBodyFixedFrame();
                expectedAcceleration = new SpatialAcceleration((ReferenceFrame)bodyFrame, worldFrame, (ReferenceFrame)bodyFrame);
                jointAxis = joint.getJointAxis();
                cumulatedAngularAcceleration.changeFrame(jointAxis.getReferenceFrame());
                qdd = joint.getQdd();
                cumulatedAngularAcceleration.scaleAdd(qdd, (FrameTuple3DReadOnly)jointAxis, (FrameTuple3DReadOnly)cumulatedAngularAcceleration);
                cumulatedAngularAcceleration.changeFrame((ReferenceFrame)bodyFrame);
                expectedAcceleration.getAngularPart().set((FrameTuple3DReadOnly)cumulatedAngularAcceleration);
                expectedAcceleration.checkReferenceFrameMatch((SpatialMotionReadOnly)actualAcceleration);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAcceleration.getAngularPart(), (EuclidGeometry)actualAcceleration.getAngularPart(), (double)5.0E-12);
            }
        }
        for (i = 0; i < 1000; ++i) {
            doVelocityTerms = random.nextBoolean();
            rootLinearAcceleration = new FrameVector3D((ReferenceFrame)rootBody.getBodyFixedFrame(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
            rootAngularAcceleration = new FrameVector3D((ReferenceFrame)rootBody.getBodyFixedFrame(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0));
            rootAcceleration = new SpatialAcceleration((ReferenceFrame)rootBody.getBodyFixedFrame(), worldFrame, (ReferenceFrame)rootBody.getBodyFixedFrame());
            rootAcceleration.set((FrameVector3DReadOnly)rootAngularAcceleration, (FrameVector3DReadOnly)rootLinearAcceleration);
            calculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)randomBody, worldFrame, doVelocityTerms, doAccelerationTerms);
            calculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
            for (JointStateType stateSelection : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateSelection, (double)-10.0, (double)10.0, (Iterable)revoluteJoints);
            }
            rootBody.updateFramesRecursively();
            calculator.reset();
            cumulatedAngularAcceleration = new FrameVector3D((FrameTuple3DReadOnly)rootAngularAcceleration);
            for (int j = 0; j < revoluteJoints.size(); ++j) {
                RevoluteJoint joint = (RevoluteJoint)revoluteJoints.get(j);
                body = joint.getSuccessor();
                actualAcceleration = new SpatialAcceleration();
                actualAcceleration.setIncludingFrame((SpatialMotionReadOnly)calculator.getAccelerationOfBody((RigidBodyReadOnly)body));
                bodyFrame = body.getBodyFixedFrame();
                expectedAcceleration = new SpatialAcceleration((ReferenceFrame)bodyFrame, worldFrame, (ReferenceFrame)bodyFrame);
                jointAxis = new FrameVector3D((FrameTuple3DReadOnly)joint.getJointAxis());
                cumulatedAngularAcceleration.changeFrame(jointAxis.getReferenceFrame());
                qdd = joint.getQdd();
                cumulatedAngularAcceleration.scaleAdd(qdd, (FrameTuple3DReadOnly)jointAxis, (FrameTuple3DReadOnly)cumulatedAngularAcceleration);
                cumulatedAngularAcceleration.changeFrame((ReferenceFrame)bodyFrame);
                if (doVelocityTerms) {
                    Twist bodyTwist = new Twist();
                    body.getBodyFixedFrame().getTwistOfFrame((TwistBasics)bodyTwist);
                    bodyTwist.changeFrame((ReferenceFrame)bodyFrame);
                    FrameVector3D coriolis = new FrameVector3D((ReferenceFrame)bodyFrame);
                    jointAxis.changeFrame((ReferenceFrame)bodyFrame);
                    coriolis.cross((FrameVector3DReadOnly)bodyTwist.getAngularPart(), jointAxis);
                    coriolis.scale(joint.getQd());
                    cumulatedAngularAcceleration.add((FrameTuple3DReadOnly)coriolis);
                }
                expectedAcceleration.getAngularPart().set((FrameTuple3DReadOnly)cumulatedAngularAcceleration);
                expectedAcceleration.checkReferenceFrameMatch((ReferenceFrame)bodyFrame, worldFrame, (ReferenceFrame)bodyFrame);
                actualAcceleration.checkReferenceFrameMatch((ReferenceFrame)bodyFrame, worldFrame, (ReferenceFrame)bodyFrame);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAcceleration.getAngularPart(), (EuclidGeometry)actualAcceleration.getAngularPart(), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testWithChainRobotAgainstFiniteDifference() throws Exception {
        Random random = new Random(234234L);
        int numberOfJoints = 10;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        List<OneDoFJointBasics> jointsInFuture = Arrays.asList(MultiBodySystemFactories.cloneOneDoFJointKinematicChain((OneDoFJointBasics[])((OneDoFJointBasics[])joints.toArray(new OneDoFJoint[numberOfJoints]))));
        RigidBodyBasics randomBody = ((OneDoFJoint)joints.get(random.nextInt(joints.size()))).getPredecessor();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)randomBody);
        double dt = 1.0E-8;
        for (int i = 0; i < 1000; ++i) {
            int jointIndex;
            SpatialAcceleration rootAcceleration = new SpatialAcceleration((ReferenceFrame)rootBody.getBodyFixedFrame(), worldFrame, (ReferenceFrame)rootBody.getBodyFixedFrame());
            rootAcceleration.set((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            SpatialAccelerationCalculator calculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)randomBody, worldFrame, true, true);
            calculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
            for (JointStateType stateSelection : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateSelection, (double)-1.0, (double)1.0, (Iterable)joints);
            }
            for (jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
                double q = ((OneDoFJoint)joints.get(jointIndex)).getQ();
                double qd = ((OneDoFJoint)joints.get(jointIndex)).getQd();
                double qdd = ((OneDoFJoint)joints.get(jointIndex)).getQdd();
                double qdFuture = qd + dt * qdd;
                double qFuture = q + dt * qd + 0.5 * dt * dt * qdd;
                jointsInFuture.get(jointIndex).setQ(qFuture);
                jointsInFuture.get(jointIndex).setQd(qdFuture);
            }
            ((OneDoFJoint)joints.get(0)).updateFramesRecursively();
            jointsInFuture.get(0).updateFramesRecursively();
            calculator.reset();
            for (jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
                OneDoFJoint joint = (OneDoFJoint)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                RigidBodyBasics bodyInFuture = jointsInFuture.get(jointIndex).getSuccessor();
                SpatialAcceleration actualAcceleration = new SpatialAcceleration();
                actualAcceleration.setIncludingFrame((SpatialMotionReadOnly)calculator.getAccelerationOfBody((RigidBodyReadOnly)body));
                SpatialAcceleration expectedAcceleration = SpatialAccelerationCalculatorTest.computeExpectedAccelerationByFiniteDifference(dt, (RigidBodyReadOnly)body, (RigidBodyReadOnly)bodyInFuture, (SpatialAccelerationReadOnly)rootAcceleration);
                SpatialAccelerationCalculatorTest.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)actualAcceleration, 1.0E-5);
            }
        }
    }

    @Test
    public void testWithFloatingJointRobotAgainstFiniteDifference() throws Exception {
        Random random = new Random(435345L);
        int numberOfRevoluteJoints = 30;
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain floatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, numberOfRevoluteJoints);
        SixDoFJoint floatingJoint = floatingChain.getRootJoint();
        List revoluteJoints = floatingChain.getRevoluteJoints();
        List joints = floatingChain.getJoints();
        List<JointBasics> jointsInFuture = Arrays.asList(MultiBodySystemFactories.cloneKinematicChain((JointReadOnly[])((JointReadOnly[])joints.toArray(new Joint[numberOfRevoluteJoints + 1]))));
        SixDoFJoint floatingJointInFuture = (SixDoFJoint)jointsInFuture.get(0);
        RigidBodyBasics randomBody = ((Joint)joints.get(0)).getPredecessor();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)randomBody);
        double dt = 1.0E-7;
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
        for (int i = 0; i < 1000; ++i) {
            SpatialAcceleration rootAcceleration = new SpatialAcceleration((ReferenceFrame)rootBody.getBodyFixedFrame(), worldFrame, (ReferenceFrame)rootBody.getBodyFixedFrame());
            rootAcceleration.set((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            SpatialAccelerationCalculator calculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)randomBody, worldFrame, true, true);
            calculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
            for (JointStateType selection : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)selection, (JointBasics)floatingJoint);
            }
            for (JointStateType selection : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)selection, (double)-1.0, (double)1.0, (Iterable)revoluteJoints);
            }
            MultiBodySystemTools.copyJointsState((List)joints, jointsInFuture, (JointStateType)JointStateType.CONFIGURATION);
            MultiBodySystemTools.copyJointsState((List)joints, jointsInFuture, (JointStateType)JointStateType.VELOCITY);
            MultiBodySystemTools.copyJointsState((List)joints, jointsInFuture, (JointStateType)JointStateType.ACCELERATION);
            integrator.doubleIntegrateFromAccelerationSubtree(floatingJointInFuture.getPredecessor());
            floatingJoint.updateFramesRecursively();
            floatingJointInFuture.updateFramesRecursively();
            calculator.reset();
            for (int jointIndex = 0; jointIndex < numberOfRevoluteJoints + 1; ++jointIndex) {
                Joint joint = (Joint)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                RigidBodyBasics bodyInFuture = jointsInFuture.get(jointIndex).getSuccessor();
                SpatialAcceleration actualAcceleration = new SpatialAcceleration();
                actualAcceleration.setIncludingFrame((SpatialMotionReadOnly)calculator.getAccelerationOfBody((RigidBodyReadOnly)body));
                SpatialAcceleration expectedAcceleration = SpatialAccelerationCalculatorTest.computeExpectedAccelerationByFiniteDifference(dt, (RigidBodyReadOnly)body, (RigidBodyReadOnly)bodyInFuture, (SpatialAccelerationReadOnly)rootAcceleration);
                SpatialAccelerationCalculatorTest.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)actualAcceleration, 1.0E-4);
                Point3D bodyFixedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
                FramePoint3D frameBodyFixedPoint = new FramePoint3D((ReferenceFrame)body.getBodyFixedFrame(), (Tuple3DReadOnly)bodyFixedPoint);
                FrameVector3D actualLinearAcceleration = new FrameVector3D((FrameTuple3DReadOnly)calculator.getLinearAccelerationOfBodyFixedPoint((RigidBodyReadOnly)body, (FramePoint3DReadOnly)frameBodyFixedPoint));
                FrameVector3D expectedLinearAcceleration = SpatialAccelerationCalculatorTest.computeExpectedLinearAccelerationByFiniteDifference(dt, (RigidBodyReadOnly)body, (RigidBodyReadOnly)bodyInFuture, (Point3DReadOnly)bodyFixedPoint, (SpatialAccelerationReadOnly)rootAcceleration);
                expectedLinearAcceleration.checkReferenceFrameMatch((ReferenceFrameHolder)actualLinearAcceleration);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLinearAcceleration, (EuclidGeometry)actualLinearAcceleration, (double)1.1E-4);
            }
        }
    }

    @Test
    public void testRelativeAccelerationWithFloatingJointRobotAgainstFiniteDifference() throws Exception {
        Random random = new Random(435345L);
        int numberOfRevoluteJoints = 50;
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain floatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, numberOfRevoluteJoints);
        SixDoFJoint floatingJoint = floatingChain.getRootJoint();
        List revoluteJoints = floatingChain.getRevoluteJoints();
        List joints = floatingChain.getJoints();
        List<JointBasics> jointsInFuture = Arrays.asList(MultiBodySystemFactories.cloneKinematicChain((JointReadOnly[])((JointReadOnly[])joints.toArray(new Joint[numberOfRevoluteJoints + 1]))));
        SixDoFJoint floatingJointInFuture = (SixDoFJoint)jointsInFuture.get(0);
        RigidBodyBasics randomBody = ((Joint)joints.get(random.nextInt(numberOfRevoluteJoints))).getPredecessor();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)randomBody);
        double dt = 1.0E-8;
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
        for (int i = 0; i < 50; ++i) {
            SpatialAcceleration rootAcceleration = new SpatialAcceleration((ReferenceFrame)rootBody.getBodyFixedFrame(), worldFrame, (ReferenceFrame)rootBody.getBodyFixedFrame());
            rootAcceleration.set((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            SpatialAccelerationCalculator calculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)randomBody, worldFrame, true, true);
            calculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
            for (JointStateType selection : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)selection, (JointBasics)floatingJoint);
            }
            for (JointStateType selection : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)selection, (double)-1.0, (double)1.0, (Iterable)revoluteJoints);
            }
            MultiBodySystemTools.copyJointsState((List)joints, jointsInFuture, (JointStateType)JointStateType.CONFIGURATION);
            MultiBodySystemTools.copyJointsState((List)joints, jointsInFuture, (JointStateType)JointStateType.VELOCITY);
            MultiBodySystemTools.copyJointsState((List)joints, jointsInFuture, (JointStateType)JointStateType.ACCELERATION);
            integrator.doubleIntegrateFromAccelerationSubtree(floatingJointInFuture.getPredecessor());
            floatingJoint.updateFramesRecursively();
            floatingJointInFuture.updateFramesRecursively();
            calculator.reset();
            for (int jointIndex = 0; jointIndex < numberOfRevoluteJoints + 1; ++jointIndex) {
                Joint joint = (Joint)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                RigidBodyBasics bodyInFuture = jointsInFuture.get(jointIndex).getSuccessor();
                SpatialAcceleration actualAcceleration = new SpatialAcceleration();
                actualAcceleration.setIncludingFrame((SpatialMotionReadOnly)calculator.getAccelerationOfBody((RigidBodyReadOnly)body));
                SpatialAcceleration expectedAcceleration = SpatialAccelerationCalculatorTest.computeExpectedAccelerationByFiniteDifference(dt, (RigidBodyReadOnly)body, (RigidBodyReadOnly)bodyInFuture, (SpatialAccelerationReadOnly)rootAcceleration);
                MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration : " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)actualAcceleration, (double)1.0E-4);
                for (int baseJointIndex = 0; baseJointIndex < numberOfRevoluteJoints + 1; ++baseJointIndex) {
                    RigidBodyBasics base = ((Joint)joints.get(baseJointIndex)).getSuccessor();
                    RigidBodyBasics baseInFuture = jointsInFuture.get(baseJointIndex).getSuccessor();
                    SpatialAcceleration actualRelativeAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)calculator.getRelativeAcceleration((RigidBodyReadOnly)base, (RigidBodyReadOnly)body));
                    SpatialAcceleration expectedRelativeAcceleration = this.computeExpectedRelativeAccelerationByFiniteDifference(dt, (RigidBodyReadOnly)body, (RigidBodyReadOnly)bodyInFuture, (RigidBodyReadOnly)base, (RigidBodyReadOnly)baseInFuture, (SpatialAccelerationReadOnly)rootAcceleration);
                    SpatialAccelerationCalculatorTest.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedRelativeAcceleration, (SpatialAccelerationReadOnly)actualRelativeAcceleration, 1.0E-4);
                    Point3D bodyFixedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
                    FramePoint3D frameBodyFixedPoint = new FramePoint3D((ReferenceFrame)body.getBodyFixedFrame(), (Tuple3DReadOnly)bodyFixedPoint);
                    FrameVector3D actualLinearAcceleration = new FrameVector3D((FrameTuple3DReadOnly)calculator.getLinearAccelerationOfBodyFixedPoint((RigidBodyReadOnly)base, (RigidBodyReadOnly)body, (FramePoint3DReadOnly)frameBodyFixedPoint));
                    FrameVector3D expectedLinearAcceleration = SpatialAccelerationCalculatorTest.computeExpectedLinearAccelerationByFiniteDifference(dt, (RigidBodyReadOnly)body, (RigidBodyReadOnly)bodyInFuture, (RigidBodyReadOnly)base, baseInFuture, (Point3DReadOnly)bodyFixedPoint);
                    expectedLinearAcceleration.checkReferenceFrameMatch((ReferenceFrameHolder)actualLinearAcceleration);
                    EuclidCoreTestTools.assertEquals((String)("iteration: " + i + ", joint index: " + baseJointIndex), (EuclidGeometry)expectedLinearAcceleration, (EuclidGeometry)actualLinearAcceleration, (double)1.1E-4);
                }
            }
        }
    }

    @Test
    public void testWithDoVelocityTermsSetToFalse() throws Exception {
        Random random = new Random(435345L);
        int numberOfRevoluteJoints = 50;
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain floatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, numberOfRevoluteJoints);
        SixDoFJoint floatingJoint = floatingChain.getRootJoint();
        List revoluteJoints = floatingChain.getRevoluteJoints();
        List joints = floatingChain.getJoints();
        List<JointBasics> jointsNoVelocity = Arrays.asList(MultiBodySystemFactories.cloneKinematicChain((JointReadOnly[])((JointReadOnly[])joints.toArray(new Joint[numberOfRevoluteJoints + 1])), (String)""));
        SixDoFJoint floatingJointNoVelocity = (SixDoFJoint)jointsNoVelocity.get(0);
        List revoluteJointsNoVelocity = MultiBodySystemTools.filterJoints(jointsNoVelocity, RevoluteJoint.class);
        RigidBodyBasics randomBody = ((Joint)joints.get(random.nextInt(numberOfRevoluteJoints))).getPredecessor();
        RigidBodyBasics randomBodyNoVelocity = jointsNoVelocity.get(random.nextInt(numberOfRevoluteJoints)).getPredecessor();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)randomBody);
        RigidBodyBasics rootBodyNoVelocity = MultiBodySystemTools.getRootBody((RigidBodyBasics)randomBodyNoVelocity);
        for (int i = 0; i < 50; ++i) {
            int jointIndex;
            SpatialAcceleration rootAcceleration = new SpatialAcceleration((ReferenceFrame)rootBody.getBodyFixedFrame(), worldFrame, (ReferenceFrame)rootBody.getBodyFixedFrame());
            rootAcceleration.set((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            SpatialAccelerationCalculator calculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)randomBody, worldFrame, false, true);
            calculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
            SpatialAcceleration rootAccelerationNoVelocity = new SpatialAcceleration((ReferenceFrame)rootBodyNoVelocity.getBodyFixedFrame(), worldFrame, (ReferenceFrame)rootBodyNoVelocity.getBodyFixedFrame());
            rootAccelerationNoVelocity.set((Vector3DReadOnly)rootAcceleration.getAngularPart(), (Vector3DReadOnly)rootAcceleration.getLinearPart());
            SpatialAccelerationCalculator calculatorNoVelocity = new SpatialAccelerationCalculator((RigidBodyReadOnly)randomBodyNoVelocity, worldFrame, true, true);
            calculatorNoVelocity.setRootAcceleration((SpatialAccelerationReadOnly)rootAccelerationNoVelocity);
            Quaternion floatingJointRotation = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Point3D floatingJointPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-10.0, (double)10.0);
            floatingJoint.setJointConfiguration((Orientation3DReadOnly)floatingJointRotation, (Tuple3DReadOnly)floatingJointPosition);
            floatingJointNoVelocity.setJointConfiguration((Orientation3DReadOnly)floatingJointRotation, (Tuple3DReadOnly)floatingJointPosition);
            SpatialAcceleration floatJointAcceleration = new SpatialAcceleration((ReferenceFrame)floatingJoint.getFrameAfterJoint(), (ReferenceFrame)floatingJoint.getFrameBeforeJoint(), (ReferenceFrame)floatingJoint.getFrameAfterJoint());
            floatJointAcceleration.set((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            floatingJoint.setJointAcceleration((SpatialAccelerationReadOnly)floatJointAcceleration);
            SpatialAcceleration floatJointAccelerationNoVelocity = new SpatialAcceleration((ReferenceFrame)floatingJointNoVelocity.getFrameAfterJoint(), (ReferenceFrame)floatingJointNoVelocity.getFrameBeforeJoint(), (ReferenceFrame)floatingJointNoVelocity.getFrameAfterJoint());
            floatJointAccelerationNoVelocity.set((Vector3DReadOnly)floatJointAcceleration.getAngularPart(), (Vector3DReadOnly)floatJointAcceleration.getLinearPart());
            floatingJointNoVelocity.setJointAcceleration((SpatialAccelerationReadOnly)floatJointAccelerationNoVelocity);
            Twist floatingJointTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)floatingJoint.getFrameAfterJoint(), (ReferenceFrame)floatingJoint.getFrameBeforeJoint(), (ReferenceFrame)floatingJoint.getFrameAfterJoint());
            floatingJoint.setJointTwist((TwistReadOnly)floatingJointTwist);
            for (JointStateType selection : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)selection, (double)-1.0, (double)1.0, (Iterable)revoluteJoints);
            }
            for (jointIndex = 0; jointIndex < revoluteJointsNoVelocity.size(); ++jointIndex) {
                RevoluteJoint joint = (RevoluteJoint)revoluteJoints.get(jointIndex);
                RevoluteJoint jointNoVelocity = (RevoluteJoint)revoluteJointsNoVelocity.get(jointIndex);
                jointNoVelocity.setQ(joint.getQ());
                jointNoVelocity.setQd(0.0);
                jointNoVelocity.setQdd(joint.getQdd());
            }
            floatingJoint.updateFramesRecursively();
            floatingJointNoVelocity.updateFramesRecursively();
            calculator.reset();
            calculatorNoVelocity.reset();
            for (jointIndex = 0; jointIndex < numberOfRevoluteJoints + 1; ++jointIndex) {
                Joint joint = (Joint)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                RigidBodyBasics bodyNoVelocity = jointsNoVelocity.get(jointIndex).getSuccessor();
                SpatialAcceleration actualAcceleration = new SpatialAcceleration();
                actualAcceleration.setIncludingFrame((SpatialMotionReadOnly)calculator.getAccelerationOfBody((RigidBodyReadOnly)body));
                SpatialAcceleration expectedAcceleration = new SpatialAcceleration();
                expectedAcceleration.setIncludingFrame((SpatialMotionReadOnly)calculatorNoVelocity.getAccelerationOfBody((RigidBodyReadOnly)bodyNoVelocity));
                SpatialAccelerationCalculatorTest.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)actualAcceleration, 1.0E-12, true);
                Point3D bodyFixedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
                FramePoint3D frameBodyFixedPoint = new FramePoint3D((ReferenceFrame)body.getBodyFixedFrame(), (Tuple3DReadOnly)bodyFixedPoint);
                FrameVector3D actualLinearAcceleration = new FrameVector3D((FrameTuple3DReadOnly)calculator.getLinearAccelerationOfBodyFixedPoint((RigidBodyReadOnly)body, (FramePoint3DReadOnly)frameBodyFixedPoint));
                FrameVector3D expectedLinearAcceleration = new FrameVector3D((FrameTuple3DReadOnly)calculatorNoVelocity.getLinearAccelerationOfBodyFixedPoint((RigidBodyReadOnly)bodyNoVelocity, (FramePoint3DReadOnly)frameBodyFixedPoint));
                Assertions.assertEquals((Object)expectedLinearAcceleration.getReferenceFrame().getName(), (Object)actualLinearAcceleration.getReferenceFrame().getName());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLinearAcceleration, (EuclidGeometry)actualLinearAcceleration, (double)1.0E-12);
                for (int baseJointIndex = 0; baseJointIndex < numberOfRevoluteJoints + 1; ++baseJointIndex) {
                    RigidBodyBasics base = ((Joint)joints.get(baseJointIndex)).getSuccessor();
                    RigidBodyBasics baseNoVelocity = jointsNoVelocity.get(baseJointIndex).getSuccessor();
                    SpatialAcceleration actualRelativeAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)calculator.getRelativeAcceleration((RigidBodyReadOnly)base, (RigidBodyReadOnly)body));
                    SpatialAcceleration expectedRelativeAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)calculatorNoVelocity.getRelativeAcceleration((RigidBodyReadOnly)baseNoVelocity, (RigidBodyReadOnly)bodyNoVelocity));
                    String messagePrefix = "iteration: " + i + ", joint index: " + jointIndex + ", base joint index: " + baseJointIndex;
                    SpatialAccelerationCalculatorTest.assertSpatialAccelerationEquals(messagePrefix, (SpatialAccelerationReadOnly)expectedRelativeAcceleration, (SpatialAccelerationReadOnly)actualRelativeAcceleration, 1.0E-12, true);
                    bodyFixedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
                    frameBodyFixedPoint = new FramePoint3D((ReferenceFrame)body.getBodyFixedFrame(), (Tuple3DReadOnly)bodyFixedPoint);
                    actualLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)calculator.getLinearAccelerationOfBodyFixedPoint((RigidBodyReadOnly)base, (RigidBodyReadOnly)body, (FramePoint3DReadOnly)frameBodyFixedPoint));
                    expectedLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)calculatorNoVelocity.getLinearAccelerationOfBodyFixedPoint((RigidBodyReadOnly)baseNoVelocity, (RigidBodyReadOnly)bodyNoVelocity, (FramePoint3DReadOnly)frameBodyFixedPoint));
                    Assertions.assertEquals((Object)expectedLinearAcceleration.getReferenceFrame().getName(), (Object)actualLinearAcceleration.getReferenceFrame().getName());
                    EuclidCoreTestTools.assertEquals((String)messagePrefix, (EuclidGeometry)expectedLinearAcceleration, (EuclidGeometry)actualLinearAcceleration, (double)1.0E-12);
                }
            }
        }
    }

    public static FrameVector3D computeExpectedLinearAccelerationByFiniteDifference(double dt, RigidBodyReadOnly body, RigidBodyReadOnly bodyInFuture, Point3DReadOnly bodyFixedPoint, SpatialAccelerationReadOnly rootAcceleration) {
        FrameVector3D pointLinearVelocity = new FrameVector3D();
        FrameVector3D pointLinearVelocityInFuture = new FrameVector3D();
        FramePoint3D point = new FramePoint3D((ReferenceFrame)body.getBodyFixedFrame(), (Tuple3DReadOnly)bodyFixedPoint);
        FramePoint3D pointInFuture = new FramePoint3D((ReferenceFrame)bodyInFuture.getBodyFixedFrame(), (Tuple3DReadOnly)bodyFixedPoint);
        body.getBodyFixedFrame().getTwistOfFrame().getLinearVelocityAt((FramePoint3DReadOnly)point, (FrameVector3DBasics)pointLinearVelocity);
        bodyInFuture.getBodyFixedFrame().getTwistOfFrame().getLinearVelocityAt((FramePoint3DReadOnly)pointInFuture, (FrameVector3DBasics)pointLinearVelocityInFuture);
        pointLinearVelocity.changeFrame(worldFrame);
        pointLinearVelocityInFuture.changeFrame(worldFrame);
        FrameVector3D pointLinearAcceleration = new FrameVector3D(worldFrame);
        pointLinearAcceleration.sub((FrameTuple3DReadOnly)pointLinearVelocityInFuture, (FrameTuple3DReadOnly)pointLinearVelocity);
        pointLinearAcceleration.scale(1.0 / dt);
        rootAcceleration.getBodyFrame().checkReferenceFrameMatch(rootAcceleration.getReferenceFrame());
        FrameVector3D rootAngularAcceleration = new FrameVector3D((FrameTuple3DReadOnly)rootAcceleration.getAngularPart());
        FrameVector3D rootLinearAcceleration = new FrameVector3D((FrameTuple3DReadOnly)rootAcceleration.getLinearPart());
        FramePoint3D bodyFixedPointToRoot = new FramePoint3D((ReferenceFrame)body.getBodyFixedFrame(), (Tuple3DReadOnly)bodyFixedPoint);
        bodyFixedPointToRoot.changeFrame(rootAcceleration.getBodyFrame());
        FrameVector3D crossPart = new FrameVector3D(rootAcceleration.getBodyFrame());
        crossPart.cross((FrameTuple3DReadOnly)bodyFixedPointToRoot, (FrameTuple3DReadOnly)rootAngularAcceleration);
        crossPart.changeFrame(worldFrame);
        rootLinearAcceleration.changeFrame(worldFrame);
        pointLinearAcceleration.sub((FrameTuple3DReadOnly)crossPart);
        pointLinearAcceleration.add((FrameTuple3DReadOnly)rootLinearAcceleration);
        return pointLinearAcceleration;
    }

    public static FrameVector3D computeExpectedLinearAccelerationByFiniteDifference(double dt, RigidBodyReadOnly body, RigidBodyReadOnly bodyInFuture, RigidBodyReadOnly base, RigidBodyBasics baseInFuture, Point3DReadOnly bodyFixedPoint) {
        FrameVector3D pointLinearVelocity = new FrameVector3D();
        FrameVector3D pointLinearVelocityInFuture = new FrameVector3D();
        FramePoint3D point = new FramePoint3D((ReferenceFrame)body.getBodyFixedFrame(), (Tuple3DReadOnly)bodyFixedPoint);
        FramePoint3D pointInFuture = new FramePoint3D((ReferenceFrame)bodyInFuture.getBodyFixedFrame(), (Tuple3DReadOnly)bodyFixedPoint);
        Twist twist = new Twist();
        Twist twistInFuture = new Twist();
        body.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)base.getBodyFixedFrame(), (TwistBasics)twist);
        bodyInFuture.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)baseInFuture.getBodyFixedFrame(), (TwistBasics)twistInFuture);
        twist.getLinearVelocityAt((FramePoint3DReadOnly)point, (FrameVector3DBasics)pointLinearVelocity);
        twistInFuture.getLinearVelocityAt((FramePoint3DReadOnly)pointInFuture, (FrameVector3DBasics)pointLinearVelocityInFuture);
        pointLinearVelocity.changeFrame((ReferenceFrame)base.getBodyFixedFrame());
        pointLinearVelocityInFuture.changeFrame((ReferenceFrame)baseInFuture.getBodyFixedFrame());
        FrameVector3D pointLinearAcceleration = new FrameVector3D((ReferenceFrame)base.getBodyFixedFrame());
        pointLinearAcceleration.sub((Tuple3DReadOnly)pointLinearVelocityInFuture, (FrameTuple3DReadOnly)pointLinearVelocity);
        pointLinearAcceleration.scale(1.0 / dt);
        return pointLinearAcceleration;
    }

    private SpatialAcceleration computeExpectedRelativeAccelerationByFiniteDifference(double dt, RigidBodyReadOnly body, RigidBodyReadOnly bodyInFuture, RigidBodyReadOnly base, RigidBodyReadOnly baseInFuture, SpatialAccelerationReadOnly rootAcceleration) {
        Twist relativeTwist = new Twist();
        Twist relativeTwistInFuture = new Twist();
        body.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)base.getBodyFixedFrame(), (TwistBasics)relativeTwist);
        bodyInFuture.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)baseInFuture.getBodyFixedFrame(), (TwistBasics)relativeTwistInFuture);
        Vector3D angularAcceleration = SpatialAccelerationCalculatorTest.firstOrderFiniteDifference(dt, (Vector3DReadOnly)relativeTwist.getAngularPart(), (Vector3DReadOnly)relativeTwistInFuture.getAngularPart());
        Vector3D linearAcceleration = SpatialAccelerationCalculatorTest.firstOrderFiniteDifference(dt, (Vector3DReadOnly)relativeTwist.getLinearPart(), (Vector3DReadOnly)relativeTwistInFuture.getLinearPart());
        return new SpatialAcceleration((ReferenceFrame)body.getBodyFixedFrame(), (ReferenceFrame)base.getBodyFixedFrame(), (ReferenceFrame)body.getBodyFixedFrame(), (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration);
    }

    private static SpatialAcceleration computeExpectedAccelerationByFiniteDifference(double dt, RigidBodyReadOnly body, RigidBodyReadOnly bodyInFuture, SpatialAccelerationReadOnly rootAcceleration) {
        SpatialAcceleration expectedAcceleration = new SpatialAcceleration((ReferenceFrame)body.getBodyFixedFrame(), worldFrame, (ReferenceFrame)body.getBodyFixedFrame());
        Twist bodyTwist = new Twist();
        Twist bodyTwistInFuture = new Twist();
        body.getBodyFixedFrame().getTwistOfFrame((TwistBasics)bodyTwist);
        bodyInFuture.getBodyFixedFrame().getTwistOfFrame((TwistBasics)bodyTwistInFuture);
        Vector3D angularAcceleration = SpatialAccelerationCalculatorTest.firstOrderFiniteDifference(dt, (Vector3DReadOnly)bodyTwist.getAngularPart(), (Vector3DReadOnly)bodyTwistInFuture.getAngularPart());
        Vector3D linearAcceleration = SpatialAccelerationCalculatorTest.firstOrderFiniteDifference(dt, (Vector3DReadOnly)bodyTwist.getLinearPart(), (Vector3DReadOnly)bodyTwistInFuture.getLinearPart());
        expectedAcceleration.set((Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration);
        FrameVector3D rootAngularAcceleration = new FrameVector3D(rootAcceleration.getReferenceFrame(), (Tuple3DReadOnly)rootAcceleration.getAngularPart());
        FrameVector3D rootLinearAcceleration = new FrameVector3D(rootAcceleration.getReferenceFrame(), (Tuple3DReadOnly)rootAcceleration.getLinearPart());
        rootAngularAcceleration.changeFrame(expectedAcceleration.getReferenceFrame());
        rootLinearAcceleration.changeFrame(expectedAcceleration.getReferenceFrame());
        expectedAcceleration.getAngularPart().add((FrameTuple3DReadOnly)rootAngularAcceleration);
        FramePoint3D rootToBody = new FramePoint3D(rootAcceleration.getReferenceFrame());
        rootToBody.changeFrame(expectedAcceleration.getReferenceFrame());
        Vector3D crossPart = new Vector3D();
        crossPart.cross((Tuple3DReadOnly)rootToBody, (Tuple3DReadOnly)rootAngularAcceleration);
        expectedAcceleration.getLinearPart().add((Tuple3DReadOnly)crossPart);
        expectedAcceleration.getLinearPart().add((FrameTuple3DReadOnly)rootLinearAcceleration);
        return expectedAcceleration;
    }

    public static Vector3D firstOrderFiniteDifference(double dt, Vector3DReadOnly now, Vector3DReadOnly next) {
        Vector3D finiteDifference = new Vector3D();
        finiteDifference.sub((Tuple3DReadOnly)next, (Tuple3DReadOnly)now);
        finiteDifference.scale(1.0 / dt);
        return finiteDifference;
    }

    public static void assertSpatialAccelerationEquals(SpatialAccelerationReadOnly expected, SpatialAccelerationReadOnly actual, double epsilon) throws AssertionError {
        SpatialAccelerationCalculatorTest.assertSpatialAccelerationEquals(null, expected, actual, epsilon, false);
    }

    public static void assertSpatialAccelerationEquals(SpatialAccelerationReadOnly expected, SpatialAccelerationReadOnly actual, double epsilon, boolean checkFrameByName) {
        SpatialAccelerationCalculatorTest.assertSpatialAccelerationEquals(null, expected, actual, epsilon, checkFrameByName);
    }

    public static void assertSpatialAccelerationEquals(String messagePrefix, SpatialAccelerationReadOnly expected, SpatialAccelerationReadOnly actual, double epsilon, boolean checkFrameByName) throws AssertionError {
        try {
            if (checkFrameByName) {
                Assertions.assertEquals((Object)expected.getBodyFrame().getName(), (Object)actual.getBodyFrame().getName());
                Assertions.assertEquals((Object)expected.getBaseFrame().getName(), (Object)actual.getBaseFrame().getName());
                Assertions.assertEquals((Object)expected.getReferenceFrame().getName(), (Object)actual.getReferenceFrame().getName());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expected.getAngularPart(), (EuclidGeometry)actual.getAngularPart(), (double)epsilon);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expected.getLinearPart(), (EuclidGeometry)actual.getLinearPart(), (double)epsilon);
            } else {
                Assertions.assertTrue((boolean)expected.epsilonEquals((SpatialMotionReadOnly)actual, epsilon));
            }
        }
        catch (AssertionError e) {
            Vector3D difference = new Vector3D();
            difference.sub((Tuple3DReadOnly)expected.getLinearPart(), (Tuple3DReadOnly)actual.getLinearPart());
            double linearPartDifference = difference.norm();
            difference.sub((Tuple3DReadOnly)expected.getAngularPart(), (Tuple3DReadOnly)actual.getAngularPart());
            double angularPartDifference = difference.norm();
            messagePrefix = messagePrefix != null ? (String)messagePrefix + " " : "";
            throw new AssertionError((Object)((String)messagePrefix + "expected:\n<" + expected + ">\n but was:\n<" + actual + ">\n difference: linear part: " + linearPartDifference + ", angular part: " + angularPartDifference));
        }
    }
}

