/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.iterators;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.IteratorSearchMode;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterable;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class JointIterableTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testChain() {
        int jointIndex;
        Iterator iterator;
        int j;
        JointIterable jointIterable;
        IteratorSearchMode mode;
        List joints;
        int numberOfJoints;
        int i;
        Random random = new Random(43954L);
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            mode = (IteratorSearchMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])IteratorSearchMode.values());
            jointIterable = new JointIterable(JointReadOnly.class, null, mode, (JointReadOnly)joints.get(0));
            for (j = 0; j < 2; ++j) {
                iterator = jointIterable.iterator();
                for (jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertTrue((joints.get(jointIndex) == iterator.next() ? 1 : 0) != 0);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            mode = (IteratorSearchMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])IteratorSearchMode.values());
            jointIterable = new JointIterable(OneDoFJointReadOnly.class, null, mode, (JointReadOnly)joints.get(0));
            for (j = 0; j < 2; ++j) {
                iterator = jointIterable.iterator();
                for (jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
                    if (!(joints.get(jointIndex) instanceof OneDoFJointReadOnly)) continue;
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertTrue((joints.get(jointIndex) == iterator.next() ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testChainWithKinematicLoop() {
        Random random = new Random(43954L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = random.nextInt(50) + 2;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            IteratorSearchMode mode = (IteratorSearchMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])IteratorSearchMode.values());
            int loopStartIndex = random.nextInt(numberOfJoints);
            int loopEndIndex = random.nextInt(numberOfJoints);
            while (loopEndIndex == loopStartIndex) {
                loopEndIndex = random.nextInt(numberOfJoints);
            }
            if (loopStartIndex > loopEndIndex) {
                int temp = loopStartIndex;
                loopStartIndex = loopEndIndex;
                loopEndIndex = temp;
            }
            int kinematicLoopSize = random.nextInt(10) + 2;
            RigidBodyBasics loopStart = ((JointBasics)joints.get(loopStartIndex)).getSuccessor();
            RigidBodyBasics loopEnd = ((JointBasics)joints.get(loopEndIndex)).getSuccessor();
            MultiBodySystemRandomTools.nextKinematicLoopRevoluteJoints((Random)random, (String)"loop", (RigidBodyBasics)loopStart, (RigidBodyBasics)loopEnd, (int)kinematicLoopSize);
            JointIterable jointIterable = new JointIterable(JointBasics.class, null, mode, (JointReadOnly)joints.get(0));
            ArrayList iterableJoints = new ArrayList();
            jointIterable.iterator().forEachRemaining(iterableJoints::add);
            Assertions.assertEquals((int)(numberOfJoints + kinematicLoopSize), (int)iterableJoints.size());
            Assertions.assertEquals((int)new HashSet(iterableJoints).size(), (int)iterableJoints.size());
        }
    }

    @Test
    public void testTreeDepth1() throws Exception {
        Random random = new Random(324534L);
        for (int i = 0; i < 1000; ++i) {
            IteratorSearchMode mode = (IteratorSearchMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])IteratorSearchMode.values());
            RigidBody rootBody = new RigidBody("rootBody", ReferenceFrame.getWorldFrame());
            JointBasics rootJoint = MultiBodySystemRandomTools.nextJoint((Random)random, (String)"root", (RigidBodyBasics)rootBody);
            RigidBody rootJointSuccessor = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"rootJointSuccessor", (JointBasics)rootJoint);
            int numberOfChildren = 10;
            for (int childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
                JointBasics childJoint = MultiBodySystemRandomTools.nextJoint((Random)random, (String)"jointDepth1", (RigidBodyBasics)rootJointSuccessor);
                MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"bodyDepth1", (JointBasics)childJoint);
            }
            JointIterable jointIterable = new JointIterable(JointReadOnly.class, null, mode, (JointReadOnly)rootJoint);
            Iterator iterator = jointIterable.iterator();
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertTrue((rootJoint == iterator.next() ? 1 : 0) != 0);
            for (int childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
                Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertTrue((rootJointSuccessor.getChildrenJoints().get(childIndex) == iterator.next() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testTreeDepth2() throws Exception {
        JointBasics grandChildJoint;
        int childIndex;
        Iterator iterator;
        JointIterable jointIterable;
        JointBasics childJoint;
        int numberOfGrandChildrenPerChild;
        int numberOfChildren;
        RigidBody rootJointSuccessor;
        JointBasics rootJoint;
        RigidBody rootBody;
        int i;
        Random random = new Random(324534L);
        for (i = 0; i < 1000; ++i) {
            rootBody = new RigidBody("rootBody", ReferenceFrame.getWorldFrame());
            rootJoint = MultiBodySystemRandomTools.nextJoint((Random)random, (String)"root", (RigidBodyBasics)rootBody);
            rootJointSuccessor = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"rootJointSuccessor", (JointBasics)rootJoint);
            numberOfChildren = 10;
            numberOfGrandChildrenPerChild = 10;
            for (int childIndex2 = 0; childIndex2 < numberOfChildren; ++childIndex2) {
                childJoint = MultiBodySystemRandomTools.nextJoint((Random)random, (String)"jointDepth1", (RigidBodyBasics)rootJointSuccessor);
                RigidBody childBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"bodyDepth1", (JointBasics)childJoint);
                for (int grandChildIndex = 0; grandChildIndex < numberOfGrandChildrenPerChild; ++grandChildIndex) {
                    JointBasics grandChildJoint2 = MultiBodySystemRandomTools.nextJoint((Random)random, (String)"jointDepth2", (RigidBodyBasics)childBody);
                    MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"bodyDepth2", (JointBasics)grandChildJoint2);
                }
            }
            jointIterable = new JointIterable(JointReadOnly.class, null, IteratorSearchMode.BREADTH_FIRST_SEARCH, (JointReadOnly)rootJoint);
            iterator = jointIterable.iterator();
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertTrue((rootJoint == iterator.next() ? 1 : 0) != 0);
            for (childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
                Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertTrue((rootJointSuccessor.getChildrenJoints().get(childIndex) == iterator.next() ? 1 : 0) != 0);
            }
            for (childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
                JointBasics childJoint2 = (JointBasics)rootJointSuccessor.getChildrenJoints().get(childIndex);
                for (int grandChildIndex = 0; grandChildIndex < numberOfGrandChildrenPerChild; ++grandChildIndex) {
                    grandChildJoint = (JointBasics)childJoint2.getSuccessor().getChildrenJoints().get(grandChildIndex);
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertTrue((grandChildJoint == iterator.next() ? 1 : 0) != 0);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            rootBody = new RigidBody("rootBody", ReferenceFrame.getWorldFrame());
            rootJoint = MultiBodySystemRandomTools.nextSixDoFJoint((Random)random, (String)"root", (RigidBodyBasics)rootBody);
            rootJointSuccessor = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"rootJointSuccessor", (JointBasics)rootJoint);
            numberOfChildren = 10;
            numberOfGrandChildrenPerChild = 10;
            for (int childIndex3 = 0; childIndex3 < numberOfChildren; ++childIndex3) {
                childJoint = MultiBodySystemRandomTools.nextSphericalJoint((Random)random, (String)"jointDepth1", (RigidBodyBasics)rootJointSuccessor);
                RigidBody childBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"bodyDepth1", (JointBasics)childJoint);
                for (int grandChildIndex = 0; grandChildIndex < numberOfGrandChildrenPerChild; ++grandChildIndex) {
                    OneDoFJoint grandChildJoint3 = MultiBodySystemRandomTools.nextOneDoFJoint((Random)random, (String)"jointDepth2", (RigidBodyBasics)childBody);
                    MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"bodyDepth2", (JointBasics)grandChildJoint3);
                }
            }
            jointIterable = new JointIterable(OneDoFJointReadOnly.class, null, IteratorSearchMode.BREADTH_FIRST_SEARCH, (JointReadOnly)rootJoint);
            iterator = jointIterable.iterator();
            for (childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
                JointBasics childJoint3 = (JointBasics)rootJointSuccessor.getChildrenJoints().get(childIndex);
                for (int grandChildIndex = 0; grandChildIndex < numberOfGrandChildrenPerChild; ++grandChildIndex) {
                    grandChildJoint = (JointBasics)childJoint3.getSuccessor().getChildrenJoints().get(grandChildIndex);
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    JointReadOnly actual = (JointReadOnly)iterator.next();
                    Assertions.assertTrue((grandChildJoint == actual ? 1 : 0) != 0, (String)("child: " + childIndex + ", grand-child: " + grandChildIndex + ", expected: " + grandChildJoint.getName() + ", actual: " + actual.getName()));
                }
            }
        }
    }

    @Test
    public void testRandomTree() {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            IteratorSearchMode mode = (IteratorSearchMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])IteratorSearchMode.values());
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)50);
            RigidBodyBasics root = ((JointBasics)joints.get(0)).getPredecessor();
            List<JointReadOnly> expectedList = switch (mode) {
                case IteratorSearchMode.DEPTH_FIRST_SEARCH -> JointIterableTest.collectDFSJoints((RigidBodyReadOnly)root);
                case IteratorSearchMode.BREADTH_FIRST_SEARCH -> JointIterableTest.collectBFSJoints((RigidBodyReadOnly)root);
                default -> throw new IllegalArgumentException("Unexpected value: " + mode);
            };
            JointIterable jointIterable = new JointIterable(JointReadOnly.class, null, mode, (RigidBodyReadOnly)root);
            List actualList = jointIterable.toStream().toList();
            try {
                Assertions.assertEquals(expectedList, actualList);
                if (mode != IteratorSearchMode.BREADTH_FIRST_SEARCH) continue;
                for (int j2 = 1; j2 < actualList.size(); ++j2) {
                    Assertions.assertTrue((MultiBodySystemTools.computeDistanceToRoot((RigidBodyReadOnly)((JointReadOnly)actualList.get(j2 - 1)).getPredecessor()) <= MultiBodySystemTools.computeDistanceToRoot((RigidBodyReadOnly)((JointReadOnly)actualList.get(j2)).getPredecessor()) ? 1 : 0) != 0);
                }
                continue;
            }
            catch (Throwable e) {
                System.out.println("Search mode: " + mode);
                int maxNameLength = expectedList.stream().mapToInt(j -> j.getName().length()).max().getAsInt();
                List expectedNames = expectedList.stream().map(j -> JointIterableTest.padRightToLength(j.getName(), maxNameLength)).collect(Collectors.toList());
                List actualNames = actualList.stream().map(j -> JointIterableTest.padRightToLength(j.getName(), maxNameLength)).collect(Collectors.toList());
                for (int j3 = 0; j3 < Math.max(expectedNames.size(), actualList.size()); ++j3) {
                    if (j3 < expectedNames.size()) {
                        System.out.printf("%s(%d)", expectedNames.get(j3), MultiBodySystemTools.computeDistanceToRoot((RigidBodyReadOnly)expectedList.get(j3).getPredecessor()));
                    } else {
                        System.out.print("\t");
                    }
                    System.out.print("\t");
                    if (j3 < actualList.size()) {
                        System.out.printf("%s(%d)", actualNames.get(j3), MultiBodySystemTools.computeDistanceToRoot((RigidBodyReadOnly)((JointReadOnly)actualList.get(j3)).getPredecessor()));
                    } else {
                        System.out.print("\t");
                    }
                    System.out.println();
                }
                throw e;
            }
        }
    }

    static String padRightToLength(String input, int desiredLength) {
        return String.format("%" + -desiredLength + "s", input).replace(' ', '-');
    }

    static List<JointReadOnly> collectDFSJoints(RigidBodyReadOnly root) {
        return JointIterableTest.collectDFSJoints(root, new ArrayList<JointReadOnly>());
    }

    static List<JointReadOnly> collectDFSJoints(RigidBodyReadOnly root, List<JointReadOnly> resultToPack) {
        for (JointReadOnly joint : root.getChildrenJoints()) {
            resultToPack.add(joint);
            JointIterableTest.collectDFSJoints(joint.getSuccessor(), resultToPack);
        }
        return resultToPack;
    }

    static List<JointReadOnly> collectBFSJoints(RigidBodyReadOnly root) {
        ArrayList<JointReadOnly> result = new ArrayList<JointReadOnly>();
        ArrayDeque<RigidBodyReadOnly> currentBodies = new ArrayDeque<RigidBodyReadOnly>();
        currentBodies.add(root);
        while (!currentBodies.isEmpty()) {
            RigidBodyReadOnly body = (RigidBodyReadOnly)currentBodies.poll();
            result.addAll(body.getChildrenJoints());
            for (JointReadOnly child : body.getChildrenJoints()) {
                currentBodies.add(child.getSuccessor());
            }
        }
        return result;
    }
}

