/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;

public abstract class SpatialVectorReadOnlyTest<T extends SpatialVectorReadOnly> {
    private static final int ITERATIONS = 1000;

    public abstract T newEmptySpatialVector();

    public abstract T newRandomSpatialVector(Random var1);

    public abstract T newSpatialVector(ReferenceFrame var1, Vector3DReadOnly var2, Vector3DReadOnly var3);

    public abstract T newCopySpatialVector(SpatialVectorReadOnly var1);

    public abstract double getEpsilon();

    @Test
    public void testGetElement() {
        Random random = new Random(29843L);
        for (int i = 0; i < 1000; ++i) {
            Object randomSpatialVector = this.newRandomSpatialVector(random);
            Assertions.assertEquals((double)randomSpatialVector.getElement(0), (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomSpatialVector.getElement(1), (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomSpatialVector.getElement(2), (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomSpatialVector.getElement(3), (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomSpatialVector.getElement(4), (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomSpatialVector.getElement(5), (double)randomSpatialVector.getLinearPartZ());
            int randomIndex = random.nextInt();
            if (randomIndex < 0 || randomIndex >= 6) {
                Assertions.assertThrows(IndexOutOfBoundsException.class, () -> randomSpatialVector.getElement(randomIndex));
                continue;
            }
            Assertions.assertDoesNotThrow(() -> randomSpatialVector.getElement(randomIndex));
        }
    }

    @Test
    public void testGets() {
        DMatrixRMaj vectorMatrix;
        int startingArrayIndex;
        Object[] vectorArray;
        T randomSpatialVector;
        int i;
        Random random = new Random(29843L);
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            vectorArray = new double[6];
            randomSpatialVector.get(vectorArray);
            Assertions.assertEquals((double)vectorArray[0], (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)vectorArray[1], (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)vectorArray[2], (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)vectorArray[3], (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)vectorArray[4], (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)vectorArray[5], (double)randomSpatialVector.getLinearPartZ());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            vectorArray = new double[24];
            startingArrayIndex = i % 18;
            randomSpatialVector.get(startingArrayIndex, vectorArray);
            Assertions.assertEquals((double)vectorArray[startingArrayIndex], (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)vectorArray[startingArrayIndex + 1], (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)vectorArray[startingArrayIndex + 2], (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)vectorArray[startingArrayIndex + 3], (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)vectorArray[startingArrayIndex + 4], (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)vectorArray[startingArrayIndex + 5], (double)randomSpatialVector.getLinearPartZ());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            vectorArray = new float[6];
            randomSpatialVector.get((float[])vectorArray);
            Assertions.assertEquals((double)vectorArray[0], (double)randomSpatialVector.getAngularPartX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)vectorArray[1], (double)randomSpatialVector.getAngularPartY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)vectorArray[2], (double)randomSpatialVector.getAngularPartZ(), (double)this.getEpsilon());
            Assertions.assertEquals((double)vectorArray[3], (double)randomSpatialVector.getLinearPartX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)vectorArray[4], (double)randomSpatialVector.getLinearPartY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)vectorArray[5], (double)randomSpatialVector.getLinearPartZ(), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            vectorArray = new float[24];
            startingArrayIndex = i % 18;
            randomSpatialVector.get(startingArrayIndex, (float[])vectorArray);
            Assertions.assertEquals((double)vectorArray[startingArrayIndex], (double)randomSpatialVector.getAngularPartX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)vectorArray[startingArrayIndex + 1], (double)randomSpatialVector.getAngularPartY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)vectorArray[startingArrayIndex + 2], (double)randomSpatialVector.getAngularPartZ(), (double)this.getEpsilon());
            Assertions.assertEquals((double)vectorArray[startingArrayIndex + 3], (double)randomSpatialVector.getLinearPartX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)vectorArray[startingArrayIndex + 4], (double)randomSpatialVector.getLinearPartY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)vectorArray[startingArrayIndex + 5], (double)randomSpatialVector.getLinearPartZ(), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            vectorMatrix = new DMatrixRMaj(6, 1);
            randomSpatialVector.get((DMatrix)vectorMatrix);
            Assertions.assertEquals((double)vectorMatrix.get(0, 0), (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)vectorMatrix.get(1, 0), (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)vectorMatrix.get(2, 0), (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)vectorMatrix.get(3, 0), (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)vectorMatrix.get(4, 0), (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)vectorMatrix.get(5, 0), (double)randomSpatialVector.getLinearPartZ());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            vectorMatrix = new DMatrixRMaj(24, 1);
            startingArrayIndex = i % 18;
            randomSpatialVector.get(startingArrayIndex, (DMatrix)vectorMatrix);
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayIndex, 0), (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayIndex + 1, 0), (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayIndex + 2, 0), (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayIndex + 3, 0), (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayIndex + 4, 0), (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayIndex + 5, 0), (double)randomSpatialVector.getLinearPartZ());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            vectorMatrix = new DMatrixRMaj(24, 24);
            int startingArrayRow = i % 18;
            int startingArrayColumn = Math.abs(random.nextInt()) % 18;
            randomSpatialVector.get(startingArrayRow, startingArrayColumn, (DMatrix)vectorMatrix);
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayRow, startingArrayColumn), (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayRow + 1, startingArrayColumn), (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayRow + 2, startingArrayColumn), (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayRow + 3, startingArrayColumn), (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayRow + 4, startingArrayColumn), (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)vectorMatrix.get(startingArrayRow + 5, startingArrayColumn), (double)randomSpatialVector.getLinearPartZ());
        }
    }

    @Test
    public void testDot() {
        Random random = new Random(65841L);
        for (int i = 0; i < 1000; ++i) {
            T randomSpatialVector = this.newRandomSpatialVector(random);
            T randomSpatialVectorSameReferenceFrame = this.newSpatialVector(randomSpatialVector.getReferenceFrame(), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            double testDot = randomSpatialVector.dot(randomSpatialVectorSameReferenceFrame);
            Assertions.assertEquals((double)testDot, (double)(randomSpatialVector.getAngularPartX() * randomSpatialVectorSameReferenceFrame.getAngularPartX() + randomSpatialVector.getAngularPartY() * randomSpatialVectorSameReferenceFrame.getAngularPartY() + randomSpatialVector.getAngularPartZ() * randomSpatialVectorSameReferenceFrame.getAngularPartZ() + randomSpatialVector.getLinearPartX() * randomSpatialVectorSameReferenceFrame.getLinearPartX() + randomSpatialVector.getLinearPartY() * randomSpatialVectorSameReferenceFrame.getLinearPartY() + randomSpatialVector.getLinearPartZ() * randomSpatialVectorSameReferenceFrame.getLinearPartZ()), (double)this.getEpsilon());
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T randomSpatialVectorDifferentReferenceFrame = this.newRandomSpatialVector(random);
                double testDotDiffFrames = randomSpatialVector.dot(randomSpatialVectorDifferentReferenceFrame);
            });
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(1250L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D originalAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D originalLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D changeAngularPart = originalAngularPart;
            Vector3D changeLinearPart = originalLinearPart;
            T originalSpatialVector = this.newSpatialVector(ReferenceFrameTools.getWorldFrame(), (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)originalLinearPart);
            changeAngularPart.setElement(i % 3, originalAngularPart.getElement(i % 3) - 1.01 * this.getEpsilon());
            T changedAboveSpatialVector = this.newSpatialVector(ReferenceFrameTools.getWorldFrame(), (Vector3DReadOnly)changeAngularPart, (Vector3DReadOnly)originalLinearPart);
            Assertions.assertFalse((boolean)changedAboveSpatialVector.epsilonEquals(originalSpatialVector, this.getEpsilon()));
            changeAngularPart.setElement(i % 3, changeAngularPart.getElement(i % 3) + 0.99 * this.getEpsilon());
            T changedBelowSpatialVector = this.newSpatialVector(ReferenceFrameTools.getWorldFrame(), (Vector3DReadOnly)changeAngularPart, (Vector3DReadOnly)originalLinearPart);
            Assertions.assertTrue((boolean)changedBelowSpatialVector.epsilonEquals(originalSpatialVector, this.getEpsilon()));
            changeLinearPart.setElement(i % 3, originalLinearPart.getElement(i % 3) - 1.01 * this.getEpsilon());
            changedAboveSpatialVector = this.newSpatialVector(ReferenceFrameTools.getWorldFrame(), (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)changeLinearPart);
            Assertions.assertFalse((boolean)changedAboveSpatialVector.epsilonEquals(originalSpatialVector, this.getEpsilon()));
            changeLinearPart.setElement(i % 3, originalLinearPart.getElement(i % 3) + 0.99 * this.getEpsilon());
            changedBelowSpatialVector = this.newSpatialVector(ReferenceFrameTools.getWorldFrame(), (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)changeLinearPart);
            Assertions.assertTrue((boolean)changedBelowSpatialVector.epsilonEquals(originalSpatialVector, this.getEpsilon()));
            T frameDifferentSpatialVector = this.newSpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)originalLinearPart);
            Assertions.assertFalse((boolean)originalSpatialVector.epsilonEquals(frameDifferentSpatialVector, this.getEpsilon()));
        }
    }
}

