/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.Random;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.SymmetricEigenDecomposition3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;

public class MecanoRandomToolsTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testNextSpatialInertia() {
        SpatialInertia spatialInertia;
        Random random = new Random(349857L);
        ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        double inertiaMax = 1.0;
        double massMax = -random.nextDouble();
        double centerOfMassOffsetMinMax = 1.0;
        try {
            spatialInertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrame, (double)inertiaMax, (double)massMax, (double)centerOfMassOffsetMinMax);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        inertiaMax = -random.nextDouble();
        massMax = 1.0;
        centerOfMassOffsetMinMax = 1.0;
        try {
            spatialInertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrame, (double)inertiaMax, (double)massMax, (double)centerOfMassOffsetMinMax);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (int i = 0; i < 1000; ++i) {
            bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            inertiaMax = 1.0;
            massMax = 1.0;
            centerOfMassOffsetMinMax = 1.0;
            SpatialInertia spatialInertia2 = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrame, (double)inertiaMax, (double)massMax, (double)centerOfMassOffsetMinMax);
            Assertions.assertTrue((boolean)MecanoRandomToolsTest.isFullyPhysicallyConsistent((SpatialInertiaReadOnly)spatialInertia2));
        }
    }

    private static boolean isFullyPhysicallyConsistent(SpatialInertiaReadOnly spatialInertia) {
        DMatrixRMaj momentOfInertia = new DMatrixRMaj(3, 3);
        SymmetricEigenDecomposition3D eigenDecomposition = new SymmetricEigenDecomposition3D();
        eigenDecomposition.decompose(spatialInertia.getMomentOfInertia());
        Vector3D eigenvalues = eigenDecomposition.getEigenValues();
        boolean isTriangleInequalitySatisfied = eigenvalues.getX() < eigenvalues.getY() + eigenvalues.getZ() && eigenvalues.getY() < eigenvalues.getX() + eigenvalues.getZ() && eigenvalues.getZ() < eigenvalues.getX() + eigenvalues.getY();
        return MecanoRandomToolsTest.isPhysicallyConsistent(spatialInertia) && isTriangleInequalitySatisfied;
    }

    private static boolean isPhysicallyConsistent(SpatialInertiaReadOnly spatialInertia) {
        Matrix3DReadOnly momentOfInertia = spatialInertia.getMomentOfInertia();
        double firstPrincipalMinor = momentOfInertia.getM00();
        double secondPrincipalMinor = momentOfInertia.getM00() * momentOfInertia.getM11() - momentOfInertia.getM01() * momentOfInertia.getM10();
        double thirdPrincipalMinor = momentOfInertia.determinant();
        return spatialInertia.getMass() > 0.0 && firstPrincipalMinor > 0.0 && secondPrincipalMinor > 0.0 && thirdPrincipalMinor > 0.0;
    }
}

