/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.sdf.items;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import us.ihmc.scs2.definition.robot.sdf.items.SDFGeometry;
import us.ihmc.scs2.definition.robot.sdf.items.SDFItem;
import us.ihmc.scs2.definition.robot.sdf.items.SDFURIHolder;

public class SDFCollision
implements SDFItem {
    private String name;
    private String pose;
    private Surface surface;
    private SDFGeometry geometry;

    public String getPose() {
        return this.pose;
    }

    @XmlElement(name="pose")
    public void setPose(String pose) {
        this.pose = pose;
    }

    public String getName() {
        return this.name;
    }

    @XmlAttribute(name="name")
    public void setName(String name) {
        this.name = name;
    }

    public Surface getSurface() {
        return this.surface;
    }

    @XmlElement(name="surface")
    public void setSurface(Surface surface) {
        this.surface = surface;
    }

    public SDFGeometry getGeometry() {
        return this.geometry;
    }

    @XmlElement(name="geometry")
    public void setGeometry(SDFGeometry geometry) {
        this.geometry = geometry;
    }

    @Override
    public String getContentAsString() {
        return this.format("[name: %s, pose: %s, surface: %s, geometry: %s]", this.name, this.pose, this.surface, this.geometry);
    }

    public List<SDFURIHolder> getURIHolders() {
        return SDFItem.combineItemURIHolders(this.surface, this.geometry);
    }

    public String toString() {
        return this.itemToString();
    }

    public static class Surface
    implements SDFItem {
        private Contact contact;

        public Contact getContact() {
            return this.contact;
        }

        @XmlElement(name="contact")
        public void setContact(Contact contact) {
            this.contact = contact;
        }

        @Override
        public String getContentAsString() {
            return this.format("[contact: %s]", this.contact);
        }

        public List<SDFURIHolder> getURIHolders() {
            return SDFItem.combineItemURIHolders(this.contact);
        }

        public String toString() {
            return this.itemToString();
        }

        public static class Contact
        implements SDFItem {
            private Ode ode;

            public Ode getOde() {
                return this.ode;
            }

            @XmlElement(name="ode")
            public void setOde(Ode ode) {
                this.ode = ode;
            }

            @Override
            public String getContentAsString() {
                return this.format("[ode: %s]", this.ode);
            }

            public List<SDFURIHolder> getURIHolders() {
                return SDFItem.combineItemURIHolders(this.ode);
            }

            public String toString() {
                return this.itemToString();
            }

            public static class Ode
            implements SDFItem {
                private String kp;
                private String kd;
                private String maxVel;

                public String getKp() {
                    return this.kp;
                }

                @XmlElement(name="kp")
                public void setKp(String kp) {
                    this.kp = kp;
                }

                public String getKd() {
                    return this.kd;
                }

                @XmlElement(name="kd")
                public void setKd(String kd) {
                    this.kd = kd;
                }

                public String getMaxVel() {
                    return this.maxVel;
                }

                @XmlElement(name="max_vel")
                public void setMaxVel(String maxVel) {
                    this.maxVel = maxVel;
                }

                @Override
                public String getContentAsString() {
                    return this.format("[kp: %s, kd: %s, maxVel: %s]", this.kp, this.kd, this.maxVel);
                }

                public List<SDFURIHolder> getURIHolders() {
                    return Collections.emptyList();
                }

                public String toString() {
                    return this.itemToString();
                }
            }
        }
    }
}

