/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.scs2.definition.AffineTransformDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.MaterialDefinition;

public class VisualDefinition {
    private String name;
    private AffineTransformDefinition originPose = new AffineTransformDefinition();
    private GeometryDefinition geometryDefinition;
    private MaterialDefinition materialDefinition;

    public VisualDefinition() {
    }

    public VisualDefinition(GeometryDefinition geometryDefinition, ColorDefinition diffuseColor) {
        this(geometryDefinition, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition(GeometryDefinition geometryDefinition, MaterialDefinition materialDefinition) {
        this.geometryDefinition = geometryDefinition;
        this.materialDefinition = materialDefinition;
    }

    public VisualDefinition(Tuple3DReadOnly originPosition, GeometryDefinition geometryDefinition, ColorDefinition diffuseColor) {
        this(originPosition, geometryDefinition, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition(Tuple3DReadOnly originPosition, GeometryDefinition geometryDefinition, MaterialDefinition materialDefinition) {
        this((AffineTransformReadOnly)new AffineTransform((Orientation3DReadOnly)new Quaternion(), originPosition), geometryDefinition, materialDefinition);
    }

    public VisualDefinition(RigidBodyTransformReadOnly originPose, GeometryDefinition geometryDefinition, ColorDefinition diffuseColor) {
        this(originPose, geometryDefinition, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition(RigidBodyTransformReadOnly originPose, GeometryDefinition geometryDefinition, MaterialDefinition materialDefinition) {
        this((AffineTransformReadOnly)new AffineTransform(originPose), geometryDefinition, materialDefinition);
    }

    public VisualDefinition(AffineTransformReadOnly originPose, GeometryDefinition geometryDefinition, ColorDefinition diffuseColor) {
        this(originPose, geometryDefinition, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition(AffineTransformReadOnly originPose, GeometryDefinition geometryDefinition, MaterialDefinition materialDefinition) {
        this(new AffineTransformDefinition(originPose), geometryDefinition, materialDefinition);
    }

    public VisualDefinition(AffineTransformDefinition originPose, GeometryDefinition geometryDefinition, ColorDefinition diffuseColor) {
        this(originPose, geometryDefinition, new MaterialDefinition(diffuseColor));
    }

    public VisualDefinition(AffineTransformDefinition originPose, GeometryDefinition geometryDefinition, MaterialDefinition materialDefinition) {
        this.originPose = originPose;
        this.geometryDefinition = geometryDefinition;
        this.materialDefinition = materialDefinition;
    }

    public VisualDefinition(VisualDefinition other) {
        this.name = other.name;
        this.originPose.set(other.originPose);
        if (other.geometryDefinition != null) {
            this.geometryDefinition = other.geometryDefinition.copy();
        }
        if (other.materialDefinition != null) {
            this.materialDefinition = other.materialDefinition.copy();
        }
    }

    @XmlElement
    public void setName(String name) {
        this.name = name;
    }

    public void setOriginPose(RigidBodyTransformReadOnly originPose) {
        this.originPose = new AffineTransformDefinition(originPose);
    }

    public void setOriginPose(AffineTransformReadOnly originPose) {
        this.originPose = new AffineTransformDefinition(originPose);
    }

    @XmlElement
    public void setOriginPose(AffineTransformDefinition originPose) {
        this.originPose = originPose;
    }

    @XmlElement
    public void setGeometryDefinition(GeometryDefinition geometryDefinition) {
        this.geometryDefinition = geometryDefinition;
    }

    @XmlElement
    public void setMaterialDefinition(MaterialDefinition materialDefinition) {
        this.materialDefinition = materialDefinition;
    }

    public String getName() {
        return this.name;
    }

    public AffineTransformDefinition getOriginPose() {
        return this.originPose;
    }

    public GeometryDefinition getGeometryDefinition() {
        return this.geometryDefinition;
    }

    public MaterialDefinition getMaterialDefinition() {
        return this.materialDefinition;
    }

    public VisualDefinition copy() {
        return new VisualDefinition(this);
    }

    public String toString() {
        return "VisualDefinition [name=" + this.name + ", originPose=" + this.originPose + ", geometryDefinition=" + this.geometryDefinition + ", materialDefinition=" + this.materialDefinition + "]";
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.name);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)((Object)this.originPose));
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.geometryDefinition);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.materialDefinition);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VisualDefinition other = (VisualDefinition)object;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.originPose, (Object)other.originPose)) {
            return false;
        }
        if (!Objects.equals(this.geometryDefinition, other.geometryDefinition)) {
            return false;
        }
        return Objects.equals(this.materialDefinition, other.materialDefinition);
    }
}

