/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoComposite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import us.ihmc.scs2.definition.yoChart.YoChartGroupModelDefinition;

@XmlRootElement(name="YoCompositePattern")
@XmlType(propOrder={"name", "crossRegistry", "ids", "altIds", "preferredConfigurations"})
public class YoCompositePatternDefinition {
    private String name;
    private boolean crossRegistry = false;
    private String[] identifiers;
    private final List<String> altIds = new ArrayList<String>();
    private final List<YoChartGroupModelDefinition> preferredConfigurations = new ArrayList<YoChartGroupModelDefinition>();

    public YoCompositePatternDefinition() {
    }

    public YoCompositePatternDefinition(String name) {
        this.setName(name);
    }

    public YoCompositePatternDefinition(YoCompositePatternDefinition other) {
        if (other == null) {
            return;
        }
        this.setName(other.name);
        this.setCrossRegistry(other.crossRegistry);
        this.identifiers = other.identifiers;
        this.altIds.addAll(other.altIds);
        this.setPreferredConfigurations(other.preferredConfigurations);
    }

    @XmlAttribute
    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public void setCrossRegistry(boolean crossRegistry) {
        this.crossRegistry = crossRegistry;
    }

    public void setIdentifiers(String[] identifiers) {
        this.identifiers = identifiers;
    }

    @XmlAttribute
    public void setIds(String ids) {
        this.identifiers = ids.replaceAll(" ", "").split(",");
    }

    @XmlElement
    public void setAltIds(List<String> altIds) {
        this.altIds.clear();
        this.altIds.addAll(altIds);
    }

    @XmlElement
    public void setPreferredConfigurations(List<YoChartGroupModelDefinition> preferredConfigurations) {
        this.preferredConfigurations.clear();
        for (YoChartGroupModelDefinition model : preferredConfigurations) {
            this.preferredConfigurations.add(model.clone());
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isCrossRegistry() {
        return this.crossRegistry;
    }

    @XmlTransient
    public String[] getIdentifiers() {
        return this.identifiers;
    }

    public String getIds() {
        return String.join((CharSequence)",", this.identifiers);
    }

    public List<String> getAltIds() {
        return this.altIds;
    }

    @XmlTransient
    public List<String[]> getAlternateIdentifiers() {
        if (this.altIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.altIds.stream().map(ids -> ids.split(",")).toList();
    }

    public List<YoChartGroupModelDefinition> getPreferredConfigurations() {
        return this.preferredConfigurations;
    }

    public YoCompositePatternDefinition clone() {
        return new YoCompositePatternDefinition(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof YoCompositePatternDefinition) {
            YoCompositePatternDefinition other = (YoCompositePatternDefinition)object;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            if (this.crossRegistry != other.crossRegistry) {
                return false;
            }
            if (!Arrays.equals(this.identifiers, other.identifiers)) {
                return false;
            }
            if (!Objects.equals(this.altIds, other.altIds)) {
                return false;
            }
            return Objects.equals(this.preferredConfigurations, other.preferredConfigurations);
        }
        return false;
    }

    public String toString() {
        return "name: " + this.name + ", ids: " + Arrays.toString(this.identifiers) + ", chart ids: " + this.preferredConfigurations;
    }
}

