/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoComposite;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;

@XmlRootElement(name="YoTuple2D")
public class YoTuple2DDefinition
extends YoCompositeDefinition {
    public static final String YoTuple2D = "YoTuple2D";
    public static final String[] YoTuple2DIdentifiers = new String[]{"x", "y"};
    private String x;
    private String y;
    private String referenceFrame;

    public YoTuple2DDefinition() {
    }

    public YoTuple2DDefinition(String x, String y) {
        this(x, y, null);
    }

    public YoTuple2DDefinition(String x, String y, String referenceFrame) {
        this.x = x;
        this.y = y;
        this.referenceFrame = referenceFrame;
    }

    public void setX(double x) {
        this.x = Double.toString(x);
    }

    @XmlElement
    public void setX(String x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = Double.toString(y);
    }

    @XmlElement
    public void setY(String y) {
        this.y = y;
    }

    @Override
    @XmlElement
    public void setReferenceFrame(String referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    @Override
    public String getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public String getType() {
        return YoTuple2D;
    }

    @Override
    public String[] getComponentIdentifiers() {
        return YoTuple2DIdentifiers;
    }

    @Override
    public String[] getComponentValues() {
        return new String[]{this.x, this.y};
    }

    public YoTuple2DDefinition copy() {
        return new YoTuple2DDefinition(this.x, this.y, this.referenceFrame);
    }

    public static YoTuple2DDefinition parse(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith(YoTuple2D)) {
            value = value.substring(value.indexOf("=") + 1).trim();
            String x = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String y = value.substring(0, value.indexOf(","));
            value = value.substring(value.indexOf("=") + 1).trim();
            String frame = value.substring(0, value.length() - 1);
            if (x.equalsIgnoreCase("null")) {
                x = null;
            }
            if (y.equalsIgnoreCase("null")) {
                y = null;
            }
            if (frame.equalsIgnoreCase("null")) {
                frame = null;
            }
            return new YoTuple2DDefinition(x, y, frame);
        }
        throw new IllegalArgumentException("Unknown tuple 2D format: " + value);
    }
}

