/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoGraphic;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameYawPitchRollReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.definition.yoComposite.YoColorRGBADoubleDefinition;
import us.ihmc.scs2.definition.yoComposite.YoColorRGBAIntDefinition;
import us.ihmc.scs2.definition.yoComposite.YoColorRGBASingleDefinition;
import us.ihmc.scs2.definition.yoComposite.YoOrientation3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoQuaternionDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple2DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoYawPitchRollDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicArrow3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicCoordinateSystem3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicLine2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPoint2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPoint3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPointcloud2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPointcloud3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPolygon2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPolygonExtruded3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPolynomial3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoListDefinition;
import us.ihmc.yoVariables.euclid.YoPoint2D;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.YoTuple2D;
import us.ihmc.yoVariables.euclid.YoTuple3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLineSegment2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameTuple2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameTuple3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicDefinitionFactory {
    private static final double DEFAULT_STROKE_WIDTH = 1.5;
    public static final ColorDefinition DEFAULT_COLOR = ColorDefinitions.Gray();

    public static YoGraphicLine2DDefinition newYoGraphicLineSegment2DDefinition(String name, YoFrameLineSegment2D lineSegment, PaintDefinition strokeColor) {
        return YoGraphicDefinitionFactory.newYoGraphicLineSegment2DDefinition(name, (YoFrameTuple2D)((YoFramePoint2D)lineSegment.getFirstEndpoint()), (YoFrameTuple2D)((YoFramePoint2D)lineSegment.getSecondEndpoint()), strokeColor);
    }

    public static YoGraphicLine2DDefinition newYoGraphicLineSegment2DDefinition(String name, YoFrameTuple2D firstEndpoint, YoFrameTuple2D secondEndpoint, PaintDefinition strokeColor) {
        YoGraphicLine2DDefinition definition = new YoGraphicLine2DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setOrigin(YoGraphicDefinitionFactory.newYoTuple2DDefinition(firstEndpoint));
        definition.setDestination(YoGraphicDefinitionFactory.newYoTuple2DDefinition(secondEndpoint));
        definition.setStrokeColor(strokeColor);
        definition.setStrokeWidth(1.5);
        return definition;
    }

    public static YoGraphicPoint2DDefinition newYoGraphicPoint2D(String name, YoFrameTuple3D position, double size, PaintDefinition color, DefaultPoint2DGraphic graphicType) {
        return YoGraphicDefinitionFactory.newYoGraphicPoint2D(name, (YoTuple3D)position, position.getReferenceFrame(), size, color, graphicType);
    }

    public static YoGraphicPoint2DDefinition newYoGraphicPoint2D(String name, YoFrameTuple2D position, double size, PaintDefinition color, DefaultPoint2DGraphic graphicType) {
        return YoGraphicDefinitionFactory.newYoGraphicPoint2D(name, (YoTuple2D)position, position.getReferenceFrame(), size, color, graphicType);
    }

    public static YoGraphicPoint2DDefinition newYoGraphicPoint2D(String name, YoTuple3D position, ReferenceFrame positionFrame, double size, PaintDefinition color, DefaultPoint2DGraphic graphicType) {
        return YoGraphicDefinitionFactory.newYoGraphicPoint2D(name, (YoTuple2D)new YoPoint2D(position.getYoX(), position.getYoY()), positionFrame, size, color, graphicType);
    }

    public static YoGraphicPoint2DDefinition newYoGraphicPoint2D(String name, YoTuple2D position, ReferenceFrame positionFrame, double size, PaintDefinition color, DefaultPoint2DGraphic graphicType) {
        YoGraphicPoint2DDefinition definition = new YoGraphicPoint2DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPosition(YoGraphicDefinitionFactory.newYoTuple2DDefinition(position, positionFrame));
        definition.setGraphicName(graphicType.getGraphicName());
        definition.setSize(size);
        if (graphicType.isFilled()) {
            definition.setFillColor(color);
        } else {
            definition.setStrokeColor(color);
        }
        definition.setStrokeWidth(1.5);
        return definition;
    }

    public static YoGraphicPoint2DDefinition newYoGraphicPoint2D(YoGraphicPoint3DDefinition definition3D, DefaultPoint2DGraphic graphicType) {
        YoGraphicPoint2DDefinition definition = new YoGraphicPoint2DDefinition();
        definition.setName(definition3D.getName());
        definition.setVisible(definition3D.isVisible());
        definition.setPosition(new YoTuple2DDefinition(definition3D.getPosition().getX(), definition3D.getPosition().getY(), definition3D.getPosition().getReferenceFrame()));
        definition.setGraphicName(graphicType.getGraphicName());
        definition.setSize(definition3D.getSize());
        if (graphicType.isFilled()) {
            definition.setFillColor(definition3D.getColor());
        } else {
            definition.setStrokeColor(definition3D.getColor());
        }
        definition.setStrokeWidth(1.5);
        return definition;
    }

    public static YoGraphicPointcloud2DDefinition newYoGraphicPointcloud2D(String name, List<? extends YoFrameTuple2D> points, double size, PaintDefinition color, DefaultPoint2DGraphic graphicType) {
        YoGraphicPointcloud2DDefinition definition = new YoGraphicPointcloud2DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPoints(points.stream().map(p -> YoGraphicDefinitionFactory.newYoTuple2DDefinition(p)).collect(Collectors.toList()));
        definition.setGraphicName(graphicType.getGraphicName());
        definition.setSize(size);
        if (graphicType.isFilled()) {
            definition.setFillColor(color);
        } else {
            definition.setStrokeColor(color);
        }
        definition.setStrokeWidth(1.5);
        return definition;
    }

    public static YoGraphicPointcloud2DDefinition newYoGraphicPointcloud2D(String name, List<? extends YoTuple2D> points, ReferenceFrame frame, double size, PaintDefinition color, DefaultPoint2DGraphic graphicType) {
        YoGraphicPointcloud2DDefinition definition = new YoGraphicPointcloud2DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPoints(points.stream().map(p -> YoGraphicDefinitionFactory.newYoTuple2DDefinition(p, frame)).collect(Collectors.toList()));
        definition.setGraphicName(graphicType.getGraphicName());
        definition.setSize(size);
        if (graphicType.isFilled()) {
            definition.setFillColor(color);
        } else {
            definition.setStrokeColor(color);
        }
        definition.setStrokeWidth(1.5);
        return definition;
    }

    public static YoGraphicPointcloud2DDefinition newYoGraphicPointcloud2D(YoGraphicPointcloud3DDefinition definition3D, DefaultPoint2DGraphic graphicType) {
        YoGraphicPointcloud2DDefinition definition = new YoGraphicPointcloud2DDefinition();
        definition.setName(definition3D.getName());
        definition.setVisible(definition3D.isVisible());
        definition.setPoints(definition3D.getPoints().stream().map(tuple3D -> new YoTuple2DDefinition(tuple3D.getX(), tuple3D.getY(), tuple3D.getReferenceFrame())).collect(Collectors.toList()));
        definition.setGraphicName(graphicType.getGraphicName());
        definition.setSize(definition3D.getSize());
        if (graphicType.isFilled()) {
            definition.setFillColor(definition3D.getColor());
        } else {
            definition.setStrokeColor(definition3D.getColor());
        }
        definition.setStrokeWidth(1.5);
        return definition;
    }

    public static YoGraphicPointcloud2DDefinition newYoGraphicPointcloud2DFrom3D(String name, List<? extends YoFrameTuple3D> points, double size, PaintDefinition color, DefaultPoint2DGraphic graphicType) {
        YoGraphicPointcloud2DDefinition definition = new YoGraphicPointcloud2DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPoints(points.stream().map(p -> YoGraphicDefinitionFactory.newYoTuple2DDefinition((YoVariable)p.getYoX(), (YoVariable)p.getYoY())).collect(Collectors.toList()));
        definition.setGraphicName(graphicType.getGraphicName());
        definition.setSize(size);
        if (graphicType.isFilled()) {
            definition.setFillColor(color);
        } else {
            definition.setStrokeColor(color);
        }
        definition.setStrokeWidth(1.5);
        return definition;
    }

    public static YoGraphicPointcloud2DDefinition newYoGraphicPointcloud2DFrom3D(String name, List<? extends YoTuple3D> points, ReferenceFrame frame, double size, PaintDefinition color, DefaultPoint2DGraphic graphicType) {
        YoGraphicPointcloud2DDefinition definition = new YoGraphicPointcloud2DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPoints(points.stream().map(p -> YoGraphicDefinitionFactory.newYoTuple2DDefinition((YoVariable)p.getYoX(), (YoVariable)p.getYoY(), frame)).collect(Collectors.toList()));
        definition.setGraphicName(graphicType.getGraphicName());
        definition.setSize(size);
        if (graphicType.isFilled()) {
            definition.setFillColor(color);
        } else {
            definition.setStrokeColor(color);
        }
        definition.setStrokeWidth(1.5);
        return definition;
    }

    public static YoGraphicPolygon2DDefinition newYoGraphicPolygon2D(String name, YoFrameConvexPolygon2D polygon, PaintDefinition strokeColor) {
        return YoGraphicDefinitionFactory.newYoGraphicPolygon2D(name, polygon, strokeColor, false);
    }

    public static YoGraphicPolygon2DDefinition newYoGraphicPolygon2D(String name, YoFrameConvexPolygon2D polygon, PaintDefinition color, boolean fill) {
        YoGraphicPolygon2DDefinition definition = new YoGraphicPolygon2DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setVertices(polygon.getVertexBuffer().stream().map(v -> YoGraphicDefinitionFactory.newYoTuple2DDefinition((YoFrameTuple2D)v)).toList());
        definition.setNumberOfVertices(YoGraphicDefinitionFactory.toPropertyName((YoVariable)polygon.getYoNumberOfVertices()));
        if (fill) {
            definition.setFillColor(color);
        } else {
            definition.setStrokeColor(color);
        }
        definition.setStrokeWidth(1.5);
        return definition;
    }

    public static YoGraphicArrow3DDefinition newYoGraphicArrow3D(String name, YoFrameTuple3D origin, YoFrameTuple3D direction, double scale, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicArrow3D(name, (YoTuple3D)origin, origin.getReferenceFrame(), (YoTuple3D)direction, direction.getReferenceFrame(), scale, color);
    }

    public static YoGraphicArrow3DDefinition newYoGraphicArrow3D(String name, YoFrameTuple3D origin, YoFrameTuple3D direction, boolean scaleLength, double bodyLength, double headLength, boolean scaleRadius, double bodyRadius, double headRadius, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicArrow3D(name, (YoTuple3D)origin, origin.getReferenceFrame(), (YoTuple3D)direction, direction.getReferenceFrame(), scaleLength, bodyLength, headLength, scaleRadius, bodyRadius, headRadius, color);
    }

    public static YoGraphicArrow3DDefinition newYoGraphicArrow3D(String name, YoTuple3D origin, ReferenceFrame originFrame, YoTuple3D direction, ReferenceFrame directionFrame, double scale, PaintDefinition color) {
        boolean scaleLength = true;
        double bodyLength = scale * 0.9;
        double headLength = scale * 0.1;
        boolean scaleRadius = true;
        double bodyRadius = scale * 0.015;
        double headRadius = bodyRadius * 2.5;
        return YoGraphicDefinitionFactory.newYoGraphicArrow3D(name, origin, originFrame, direction, directionFrame, scaleLength, bodyLength, headLength, scaleRadius, bodyRadius, headRadius, color);
    }

    public static YoGraphicArrow3DDefinition newYoGraphicArrow3D(String name, YoTuple3D origin, ReferenceFrame originFrame, YoTuple3D direction, ReferenceFrame directionFrame, boolean scaleLength, double bodyLength, double headLength, boolean scaleRadius, double bodyRadius, double headRadius, PaintDefinition color) {
        YoGraphicArrow3DDefinition definition = new YoGraphicArrow3DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setOrigin(YoGraphicDefinitionFactory.newYoTuple3DDefinition(origin, originFrame));
        definition.setDirection(YoGraphicDefinitionFactory.newYoTuple3DDefinition(direction, directionFrame));
        definition.setScaleLength(scaleLength);
        definition.setBodyLength(bodyLength);
        definition.setHeadLength(headLength);
        definition.setScaleRadius(scaleRadius);
        definition.setBodyRadius(bodyRadius);
        definition.setHeadRadius(headRadius);
        definition.setColor(color);
        return definition;
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, YoFramePose3D pose, double scale) {
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, pose, scale, (PaintDefinition)DEFAULT_COLOR);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, YoFramePose3D pose, double scale, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, pose.getPosition(), pose.getOrientation(), scale, color);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, YoFramePoint3D position, YoFrameQuaternion orientation, double scale, PaintDefinition color) {
        double bodyLength = scale * 0.9;
        double headLength = scale * 0.1;
        double bodyRadius = scale * 0.02;
        double headRadius = bodyRadius * 2.0;
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, position, orientation, bodyLength, headLength, bodyRadius, headRadius, color);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, YoFramePoint3D position, YoFrameQuaternion orientation, double bodyLength, double headLength, double bodyRadius, double headRadius, PaintDefinition color) {
        YoGraphicCoordinateSystem3DDefinition definition = new YoGraphicCoordinateSystem3DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPosition(YoGraphicDefinitionFactory.newYoTuple3DDefinition((YoFrameTuple3D)position));
        definition.setOrientation(YoGraphicDefinitionFactory.newYoQuaternionDefinition(orientation));
        definition.setBodyLength(bodyLength);
        definition.setHeadLength(headLength);
        definition.setBodyRadius(bodyRadius);
        definition.setHeadRadius(headRadius);
        definition.setColor(color);
        return definition;
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, YoFramePoseUsingYawPitchRoll pose, double scale) {
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, pose, scale, (PaintDefinition)DEFAULT_COLOR);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, YoFramePoseUsingYawPitchRoll pose, double scale, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, pose.getPosition(), pose.getYawPitchRoll(), scale, color);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, YoFramePoint3D position, YoFrameYawPitchRoll orientation, double scale, PaintDefinition color) {
        double bodyLength = scale * 0.9;
        double headLength = scale * 0.1;
        double bodyRadius = scale * 0.02;
        double headRadius = bodyRadius * 2.0;
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, position, orientation, bodyLength, headLength, bodyRadius, headRadius, color);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, YoFramePoint3D position, YoFrameYawPitchRoll orientation, double bodyLength, double headLength, double bodyRadius, double headRadius, PaintDefinition color) {
        YoGraphicCoordinateSystem3DDefinition definition = new YoGraphicCoordinateSystem3DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPosition(YoGraphicDefinitionFactory.newYoTuple3DDefinition((YoFrameTuple3D)position));
        definition.setOrientation(YoGraphicDefinitionFactory.newYoYawPitchRollDefinition(orientation));
        definition.setBodyLength(bodyLength);
        definition.setHeadLength(headLength);
        definition.setBodyRadius(bodyRadius);
        definition.setHeadRadius(headRadius);
        definition.setColor(color);
        return definition;
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, FramePose3DReadOnly constantFramePose, double scale, PaintDefinition color) {
        double bodyLength = scale * 0.9;
        double headLength = scale * 0.1;
        double bodyRadius = scale * 0.02;
        double headRadius = bodyRadius * 2.0;
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, (Point3DReadOnly)constantFramePose.getPosition(), (Orientation3DReadOnly)constantFramePose.getOrientation(), constantFramePose.getReferenceFrame(), bodyLength, headLength, bodyRadius, headRadius, color);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, FramePose3DReadOnly constantFramePose, double bodyLength, double headLength, double bodyRadius, double headRadius, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, (Point3DReadOnly)constantFramePose.getPosition(), (Orientation3DReadOnly)constantFramePose.getOrientation(), constantFramePose.getReferenceFrame(), bodyLength, headLength, bodyRadius, headRadius, color);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, Pose3DReadOnly constantFramePose, double scale, PaintDefinition color) {
        double bodyLength = scale * 0.9;
        double headLength = scale * 0.1;
        double bodyRadius = scale * 0.02;
        double headRadius = bodyRadius * 2.0;
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, constantFramePose.getPosition(), (Orientation3DReadOnly)constantFramePose.getOrientation(), null, bodyLength, headLength, bodyRadius, headRadius, color);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, Pose3DReadOnly constantPose, double bodyLength, double headLength, double bodyRadius, double headRadius, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, constantPose.getPosition(), null, (Orientation3DReadOnly)constantPose.getOrientation(), null, bodyLength, headLength, bodyRadius, headRadius, color);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, Pose3DReadOnly constantPose, ReferenceFrame poseFrame, double bodyLength, double headLength, double bodyRadius, double headRadius, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, constantPose.getPosition(), poseFrame, (Orientation3DReadOnly)constantPose.getOrientation(), poseFrame, bodyLength, headLength, bodyRadius, headRadius, color);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, Point3DReadOnly constantPosition, Orientation3DReadOnly constantOrientation, ReferenceFrame poseFrame, double bodyLength, double headLength, double bodyRadius, double headRadius, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D(name, constantPosition, poseFrame, constantOrientation, poseFrame, bodyLength, headLength, bodyRadius, headRadius, color);
    }

    public static YoGraphicCoordinateSystem3DDefinition newYoGraphicCoordinateSystem3D(String name, Point3DReadOnly constantPosition, ReferenceFrame positionFrame, Orientation3DReadOnly constantOrientation, ReferenceFrame orientationFrame, double bodyLength, double headLength, double bodyRadius, double headRadius, PaintDefinition color) {
        YoGraphicCoordinateSystem3DDefinition definition = new YoGraphicCoordinateSystem3DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPosition(YoGraphicDefinitionFactory.newYoTuple3DDefinition((Tuple3DReadOnly)constantPosition, positionFrame));
        definition.setOrientation(YoGraphicDefinitionFactory.newYoOrientation3DDefinition(constantOrientation, orientationFrame));
        definition.setBodyLength(bodyLength);
        definition.setHeadLength(headLength);
        definition.setBodyRadius(bodyRadius);
        definition.setHeadRadius(headRadius);
        definition.setColor(color);
        return definition;
    }

    public static YoGraphicPoint3DDefinition newYoGraphicPoint3D(String name, YoFrameTuple3D position, double size, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicPoint3D(name, (YoTuple3D)position, position.getReferenceFrame(), size, color);
    }

    public static YoGraphicPoint3DDefinition newYoGraphicPoint3D(String name, YoTuple3D position, ReferenceFrame positionFrame, double size, PaintDefinition color) {
        YoGraphicPoint3DDefinition definition = new YoGraphicPoint3DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPosition(YoGraphicDefinitionFactory.newYoTuple3DDefinition(position, positionFrame));
        definition.setSize(size);
        definition.setColor(color);
        return definition;
    }

    public static YoGraphicPointcloud3DDefinition newYoGraphicPointcloud3D(String name, List<? extends YoFrameTuple3D> points, double size, PaintDefinition color) {
        YoGraphicPointcloud3DDefinition definition = new YoGraphicPointcloud3DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPoints(points.stream().map(p -> YoGraphicDefinitionFactory.newYoTuple3DDefinition(p)).collect(Collectors.toList()));
        definition.setSize(size);
        definition.setColor(color);
        return definition;
    }

    public static YoGraphicPointcloud3DDefinition newYoGraphicPointcloud3D(String name, List<? extends YoTuple3D> points, ReferenceFrame frame, double size, PaintDefinition color) {
        YoGraphicPointcloud3DDefinition definition = new YoGraphicPointcloud3DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPoints(points.stream().map(p -> YoGraphicDefinitionFactory.newYoTuple3DDefinition(p, frame)).collect(Collectors.toList()));
        definition.setSize(size);
        definition.setColor(color);
        return definition;
    }

    public static YoGraphicPolygonExtruded3DDefinition newYoGraphicPolygonExtruded3DDefinition(String name, YoFramePose3D pose, YoFrameConvexPolygon2D polygon, double thickness, PaintDefinition color) {
        YoGraphicPolygonExtruded3DDefinition definition = new YoGraphicPolygonExtruded3DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPosition(YoGraphicDefinitionFactory.newYoTuple3DDefinition((YoFrameTuple3D)pose.getPosition()));
        definition.setOrientation(YoGraphicDefinitionFactory.newYoQuaternionDefinition(pose.getOrientation()));
        definition.setVertices(polygon.getVertexBuffer().stream().map(v -> YoGraphicDefinitionFactory.newYoTuple2DDefinition((YoFrameTuple2D)v)).toList());
        definition.setNumberOfVertices(YoGraphicDefinitionFactory.toPropertyName((YoVariable)polygon.getYoNumberOfVertices()));
        definition.setThickness(thickness);
        definition.setColor(color);
        return definition;
    }

    public static YoGraphicPolygonExtruded3DDefinition newYoGraphicPolygonExtruded3DDefinition(String name, YoFramePose3D pose, List<? extends Point2DReadOnly> vertices, double thickness, PaintDefinition color) {
        YoGraphicPolygonExtruded3DDefinition definition = new YoGraphicPolygonExtruded3DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setPosition(YoGraphicDefinitionFactory.newYoTuple3DDefinition((YoFrameTuple3D)pose.getPosition()));
        definition.setOrientation(YoGraphicDefinitionFactory.newYoQuaternionDefinition(pose.getOrientation()));
        definition.setVertices(vertices.stream().map(v -> YoGraphicDefinitionFactory.newYoTuple2DDefinition((Tuple2DReadOnly)v)).toList());
        definition.setNumberOfVertices(vertices.size());
        definition.setThickness(thickness);
        definition.setColor(color);
        return definition;
    }

    public static YoGraphicPolynomial3DDefinition newYoGraphicPolynomial3D(String name, YoVariable[] coefficientsX, YoInteger numberOfCoefficientsX, YoVariable[] coefficientsY, YoInteger numberOfCoefficientsY, YoVariable[] coefficientsZ, YoInteger numberOfCoefficientsZ, YoDouble startTime, YoDouble endTime, double size, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicPolynomial3D(name, coefficientsX, numberOfCoefficientsX, coefficientsY, numberOfCoefficientsY, coefficientsZ, numberOfCoefficientsZ, startTime, endTime, size, 50, 10, color);
    }

    public static YoGraphicPolynomial3DDefinition newYoGraphicPolynomial3D(String name, YoVariable[] coefficientsX, YoInteger numberOfCoefficientsX, YoVariable[] coefficientsY, YoInteger numberOfCoefficientsY, YoVariable[] coefficientsZ, YoInteger numberOfCoefficientsZ, YoDouble startTime, YoDouble endTime, double size, int timeResolution, int numberOfDivisions, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicPolynomial3D(name, YoGraphicDefinitionFactory.toYoListDefinition(coefficientsX, numberOfCoefficientsX), YoGraphicDefinitionFactory.toYoListDefinition(coefficientsY, numberOfCoefficientsY), YoGraphicDefinitionFactory.toYoListDefinition(coefficientsZ, numberOfCoefficientsZ), startTime, 0.0, endTime, 0.0, size, timeResolution, numberOfDivisions, color);
    }

    public static YoGraphicPolynomial3DDefinition newYoGraphicPolynomial3D(String name, YoListDefinition coefficientsX, YoListDefinition coefficientsY, YoListDefinition coefficientsZ, YoDouble startTime, YoDouble endTime, double size, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicPolynomial3D(name, coefficientsX, coefficientsY, coefficientsZ, startTime, 0.0, endTime, 0.0, size, color);
    }

    public static YoGraphicPolynomial3DDefinition newYoGraphicPolynomial3D(String name, YoListDefinition coefficientsX, YoListDefinition coefficientsY, YoListDefinition coefficientsZ, YoDouble startTime, double defaultStartTime, YoDouble endTime, double defaultEndTime, double size, PaintDefinition color) {
        return YoGraphicDefinitionFactory.newYoGraphicPolynomial3D(name, coefficientsX, coefficientsY, coefficientsZ, startTime, defaultStartTime, endTime, defaultEndTime, size, 50, 10, color);
    }

    public static YoGraphicPolynomial3DDefinition newYoGraphicPolynomial3D(String name, YoListDefinition coefficientsX, YoListDefinition coefficientsY, YoListDefinition coefficientsZ, YoDouble startTime, double defaultStartTime, YoDouble endTime, double defaultEndTime, double size, int timeResolution, int numberOfDivisions, PaintDefinition color) {
        YoGraphicPolynomial3DDefinition definition = new YoGraphicPolynomial3DDefinition();
        definition.setName(name);
        definition.setVisible(true);
        definition.setCoefficientsX(coefficientsX);
        definition.setCoefficientsY(coefficientsY);
        definition.setCoefficientsZ(coefficientsZ);
        definition.setStartTime(YoGraphicDefinitionFactory.toPropertyName((YoVariable)startTime, defaultStartTime));
        definition.setEndTime(YoGraphicDefinitionFactory.toPropertyName((YoVariable)endTime, defaultEndTime));
        definition.setSize(size);
        definition.setTimeResolution(timeResolution);
        definition.setNumberOfDivisions(numberOfDivisions);
        definition.setColor(color);
        return definition;
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(Tuple2DReadOnly tuple2D) {
        return YoGraphicDefinitionFactory.newYoTuple2DDefinition(tuple2D, null);
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(Tuple2DReadOnly tuple2D, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoTuple2DDefinition(tuple2D == null ? 0.0 : tuple2D.getX(), tuple2D == null ? 0.0 : tuple2D.getY(), frame);
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(FrameTuple2DReadOnly frameTuple2D) {
        return YoGraphicDefinitionFactory.newYoTuple2DDefinition((Tuple2DReadOnly)frameTuple2D, frameTuple2D == null ? null : frameTuple2D.getReferenceFrame());
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(YoTuple2D tuple2D) {
        return YoGraphicDefinitionFactory.newYoTuple2DDefinition(tuple2D, null);
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(YoTuple2D tuple2D, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoTuple2DDefinition((YoVariable)(tuple2D == null ? null : tuple2D.getYoX()), (YoVariable)(tuple2D == null ? null : tuple2D.getYoY()), frame);
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(YoFrameTuple2D frameTuple2D) {
        return YoGraphicDefinitionFactory.newYoTuple2DDefinition((YoTuple2D)frameTuple2D, frameTuple2D == null ? null : frameTuple2D.getReferenceFrame());
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(YoVariable[] yoVariables, int startIndex) {
        return YoGraphicDefinitionFactory.newYoTuple2DDefinition(yoVariables[startIndex++], yoVariables[startIndex]);
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(YoVariable yoX, YoVariable yoY) {
        return YoGraphicDefinitionFactory.newYoTuple2DDefinition(yoX, yoY, null);
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(YoVariable yoX, YoVariable yoY, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoTuple2DDefinition(yoX, 0.0, yoY, 0.0, frame);
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(double x, double y, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoTuple2DDefinition(null, x, null, y, frame);
    }

    public static YoTuple2DDefinition newYoTuple2DDefinition(YoVariable yoX, double defaultX, YoVariable yoY, double defaultY, ReferenceFrame frame) {
        YoTuple2DDefinition definition = new YoTuple2DDefinition();
        definition.setX(YoGraphicDefinitionFactory.toPropertyName(yoX, defaultX));
        definition.setY(YoGraphicDefinitionFactory.toPropertyName(yoY, defaultY));
        definition.setReferenceFrame(YoGraphicDefinitionFactory.toPropertyName(frame));
        return definition;
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(Tuple3DReadOnly tuple3D) {
        return YoGraphicDefinitionFactory.newYoTuple3DDefinition(tuple3D, null);
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(Tuple3DReadOnly tuple3D, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoTuple3DDefinition(tuple3D == null ? 0.0 : tuple3D.getX(), tuple3D == null ? 0.0 : tuple3D.getY(), tuple3D == null ? 0.0 : tuple3D.getZ(), frame);
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(FrameTuple3DReadOnly frameTuple3D) {
        return YoGraphicDefinitionFactory.newYoTuple3DDefinition((Tuple3DReadOnly)frameTuple3D, frameTuple3D == null ? null : frameTuple3D.getReferenceFrame());
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(YoTuple3D tuple3D) {
        return YoGraphicDefinitionFactory.newYoTuple3DDefinition(tuple3D, null);
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(YoTuple3D tuple3D, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoTuple3DDefinition((YoVariable)(tuple3D == null ? null : tuple3D.getYoX()), (YoVariable)(tuple3D == null ? null : tuple3D.getYoY()), (YoVariable)(tuple3D == null ? null : tuple3D.getYoZ()), frame);
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(YoFrameTuple3D frameTuple3D) {
        return YoGraphicDefinitionFactory.newYoTuple3DDefinition((YoTuple3D)frameTuple3D, frameTuple3D == null ? null : frameTuple3D.getReferenceFrame());
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(YoVariable[] yoVariables, int startIndex) {
        return YoGraphicDefinitionFactory.newYoTuple3DDefinition(yoVariables[startIndex++], yoVariables[startIndex++], yoVariables[startIndex]);
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(YoVariable yoX, YoVariable yoY, YoVariable yoZ) {
        return YoGraphicDefinitionFactory.newYoTuple3DDefinition(yoX, yoY, yoZ, null);
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(YoVariable yoX, YoVariable yoY, YoVariable yoZ, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoTuple3DDefinition(yoX, 0.0, yoY, 0.0, yoZ, 0.0, frame);
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(double x, double y, double z, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoTuple3DDefinition(null, x, null, y, null, z, frame);
    }

    public static YoTuple3DDefinition newYoTuple3DDefinition(YoVariable yoX, double defaultX, YoVariable yoY, double defaultY, YoVariable yoZ, double defaultZ, ReferenceFrame frame) {
        YoTuple3DDefinition definition = new YoTuple3DDefinition();
        definition.setX(YoGraphicDefinitionFactory.toPropertyName(yoX, defaultX));
        definition.setY(YoGraphicDefinitionFactory.toPropertyName(yoY, defaultY));
        definition.setZ(YoGraphicDefinitionFactory.toPropertyName(yoZ, defaultZ));
        definition.setReferenceFrame(YoGraphicDefinitionFactory.toPropertyName(frame));
        return definition;
    }

    public static YoOrientation3DDefinition newYoOrientation3DDefinition(Orientation3DReadOnly orientation3D) {
        return YoGraphicDefinitionFactory.newYoOrientation3DDefinition(orientation3D, null);
    }

    public static YoOrientation3DDefinition newYoOrientation3DDefinition(Orientation3DReadOnly orientation3D, ReferenceFrame frame) {
        if (orientation3D == null) {
            return YoGraphicDefinitionFactory.newYoYawPitchRollDefinition(null, frame);
        }
        if (orientation3D instanceof QuaternionReadOnly) {
            return YoGraphicDefinitionFactory.newYoQuaternionDefinition((QuaternionReadOnly)orientation3D, frame);
        }
        if (orientation3D instanceof YawPitchRollReadOnly) {
            return YoGraphicDefinitionFactory.newYoYawPitchRollDefinition((YawPitchRollReadOnly)orientation3D, frame);
        }
        throw new UnsupportedOperationException("Orientation type [" + orientation3D.getClass().getSimpleName() + "] is not supported yet.");
    }

    public static YoOrientation3DDefinition newYoOrientation3DDefinition(FrameOrientation3DReadOnly frameOrientation3D) {
        return YoGraphicDefinitionFactory.newYoOrientation3DDefinition((Orientation3DReadOnly)frameOrientation3D, frameOrientation3D == null ? null : frameOrientation3D.getReferenceFrame());
    }

    public static YoYawPitchRollDefinition newYoYawPitchRollDefinition(YawPitchRollReadOnly yawPitchRoll) {
        return YoGraphicDefinitionFactory.newYoYawPitchRollDefinition(yawPitchRoll, null);
    }

    public static YoYawPitchRollDefinition newYoYawPitchRollDefinition(YawPitchRollReadOnly yawPitchRoll, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoYawPitchRollDefinition(yawPitchRoll == null ? 0.0 : yawPitchRoll.getYaw(), yawPitchRoll == null ? 0.0 : yawPitchRoll.getPitch(), yawPitchRoll == null ? 0.0 : yawPitchRoll.getRoll(), frame);
    }

    public static YoYawPitchRollDefinition newYoYawPitchRollDefinition(FrameYawPitchRollReadOnly frameYawPitchRoll) {
        return YoGraphicDefinitionFactory.newYoYawPitchRollDefinition((YawPitchRollReadOnly)frameYawPitchRoll, frameYawPitchRoll == null ? null : frameYawPitchRoll.getReferenceFrame());
    }

    public static YoYawPitchRollDefinition newYoYawPitchRollDefinition(YoFrameYawPitchRoll frameYawPitchRoll) {
        return YoGraphicDefinitionFactory.newYoYawPitchRollDefinition((YoVariable)(frameYawPitchRoll == null ? null : frameYawPitchRoll.getYoYaw()), (YoVariable)(frameYawPitchRoll == null ? null : frameYawPitchRoll.getYoPitch()), (YoVariable)(frameYawPitchRoll == null ? null : frameYawPitchRoll.getYoRoll()), frameYawPitchRoll == null ? null : frameYawPitchRoll.getReferenceFrame());
    }

    public static YoYawPitchRollDefinition newYoYawPitchRollDefinition(YoVariable[] yoVariables, int startIndex) {
        return YoGraphicDefinitionFactory.newYoYawPitchRollDefinition(yoVariables[startIndex++], yoVariables[startIndex++], yoVariables[startIndex]);
    }

    public static YoYawPitchRollDefinition newYoYawPitchRollDefinition(YoVariable yoYaw, YoVariable yoPitch, YoVariable yoRoll) {
        return YoGraphicDefinitionFactory.newYoYawPitchRollDefinition(yoYaw, yoPitch, yoRoll, null);
    }

    public static YoYawPitchRollDefinition newYoYawPitchRollDefinition(YoVariable yoYaw, YoVariable yoPitch, YoVariable yoRoll, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoYawPitchRollDefinition(yoYaw, 0.0, yoPitch, 0.0, yoRoll, 0.0, frame);
    }

    public static YoYawPitchRollDefinition newYoYawPitchRollDefinition(double yaw, double pitch, double roll, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoYawPitchRollDefinition(null, yaw, null, pitch, null, roll, frame);
    }

    public static YoYawPitchRollDefinition newYoYawPitchRollDefinition(YoVariable yoYaw, double defaultYaw, YoVariable yoPitch, double defaultPitch, YoVariable yoRoll, double defaultRoll, ReferenceFrame frame) {
        YoYawPitchRollDefinition definition = new YoYawPitchRollDefinition();
        definition.setYaw(YoGraphicDefinitionFactory.toPropertyName(yoYaw, defaultYaw));
        definition.setPitch(YoGraphicDefinitionFactory.toPropertyName(yoPitch, defaultPitch));
        definition.setRoll(YoGraphicDefinitionFactory.toPropertyName(yoRoll, defaultRoll));
        definition.setReferenceFrame(YoGraphicDefinitionFactory.toPropertyName(frame));
        return definition;
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(QuaternionReadOnly quaternion) {
        return YoGraphicDefinitionFactory.newYoQuaternionDefinition(quaternion, null);
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(QuaternionReadOnly quaternion, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoQuaternionDefinition(quaternion == null ? null : Double.valueOf(quaternion.getX()), quaternion == null ? null : Double.valueOf(quaternion.getY()), quaternion == null ? null : Double.valueOf(quaternion.getZ()), quaternion == null ? null : Double.valueOf(quaternion.getS()), frame);
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(FrameQuaternionReadOnly frameQuaternion) {
        return YoGraphicDefinitionFactory.newYoQuaternionDefinition((QuaternionReadOnly)frameQuaternion, frameQuaternion == null ? null : frameQuaternion.getReferenceFrame());
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(YoQuaternion quaternion) {
        return YoGraphicDefinitionFactory.newYoQuaternionDefinition(quaternion, null);
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(YoQuaternion quaternion, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoQuaternionDefinition((YoVariable)(quaternion == null ? null : quaternion.getYoQx()), (YoVariable)(quaternion == null ? null : quaternion.getYoQy()), (YoVariable)(quaternion == null ? null : quaternion.getYoQz()), (YoVariable)(quaternion == null ? null : quaternion.getYoQs()), frame);
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(YoFrameQuaternion frameQuaternion) {
        return YoGraphicDefinitionFactory.newYoQuaternionDefinition((YoQuaternion)frameQuaternion, frameQuaternion == null ? null : frameQuaternion.getReferenceFrame());
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(YoVariable[] yoVariables, int startIndex) {
        return YoGraphicDefinitionFactory.newYoQuaternionDefinition(yoVariables[startIndex++], yoVariables[startIndex++], yoVariables[startIndex++], yoVariables[startIndex]);
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(YoVariable yoX, YoVariable yoY, YoVariable yoZ, YoVariable yoS) {
        return YoGraphicDefinitionFactory.newYoQuaternionDefinition(yoX, yoY, yoZ, yoS, null);
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(YoVariable yoX, YoVariable yoY, YoVariable yoZ, YoVariable yoS, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoQuaternionDefinition(yoX, 0.0, yoY, 0.0, yoZ, 0.0, yoS, 0.0, frame);
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(double x, double y, double z, double s, ReferenceFrame frame) {
        return YoGraphicDefinitionFactory.newYoQuaternionDefinition(null, x, null, y, null, z, null, s, frame);
    }

    public static YoQuaternionDefinition newYoQuaternionDefinition(YoVariable yoX, double defaultX, YoVariable yoY, double defaultY, YoVariable yoZ, double defaultZ, YoVariable yoS, double defaultS, ReferenceFrame frame) {
        YoQuaternionDefinition definition = new YoQuaternionDefinition();
        definition.setX(YoGraphicDefinitionFactory.toPropertyName(yoX, defaultX));
        definition.setY(YoGraphicDefinitionFactory.toPropertyName(yoY, defaultY));
        definition.setZ(YoGraphicDefinitionFactory.toPropertyName(yoZ, defaultZ));
        definition.setS(YoGraphicDefinitionFactory.toPropertyName(yoS, defaultS));
        definition.setReferenceFrame(YoGraphicDefinitionFactory.toPropertyName(frame));
        return definition;
    }

    public static PaintDefinition toYoColorDefinition(YoDouble red, YoDouble green, YoDouble blue) {
        return YoGraphicDefinitionFactory.toYoColorDefinition(red, green, blue, null);
    }

    public static PaintDefinition toYoColorDefinition(YoDouble red, YoDouble green, YoDouble blue, YoDouble alpha) {
        return new YoColorRGBADoubleDefinition(YoGraphicDefinitionFactory.toPropertyName((YoVariable)red, 0.0), YoGraphicDefinitionFactory.toPropertyName((YoVariable)green, 0.0), YoGraphicDefinitionFactory.toPropertyName((YoVariable)blue, 0.0), YoGraphicDefinitionFactory.toPropertyName((YoVariable)alpha, 1.0));
    }

    public static PaintDefinition toYoColorDefinition(YoInteger red, YoInteger green, YoInteger blue) {
        return YoGraphicDefinitionFactory.toYoColorDefinition(red, green, blue, null);
    }

    public static PaintDefinition toYoColorDefinition(YoInteger red, YoInteger green, YoInteger blue, YoInteger alpha) {
        return new YoColorRGBAIntDefinition(YoGraphicDefinitionFactory.toPropertyName(red, 0), YoGraphicDefinitionFactory.toPropertyName(green, 0), YoGraphicDefinitionFactory.toPropertyName(blue, 0), YoGraphicDefinitionFactory.toPropertyName(alpha, 255));
    }

    public static PaintDefinition toYoColorDefinition(YoInteger rgba) {
        return new YoColorRGBASingleDefinition(YoGraphicDefinitionFactory.toPropertyName(rgba, 0));
    }

    public static YoListDefinition toYoListDefinition(YoVariable[] yoVariables, YoInteger size) {
        return YoGraphicDefinitionFactory.toYoListDefinition(yoVariables, null, size);
    }

    public static YoListDefinition toYoListDefinition(YoVariable[] yoVariables, double[] defaultValues, YoInteger size) {
        return new YoListDefinition(YoGraphicDefinitionFactory.toPropertyNames(yoVariables, defaultValues), YoGraphicDefinitionFactory.toPropertyName((YoVariable)size));
    }

    public static List<String> toPropertyNames(YoVariable[] yoVariables) {
        return YoGraphicDefinitionFactory.toPropertyNames(yoVariables, null);
    }

    public static List<String> toPropertyNames(YoVariable[] yoVariables, double[] defaultValues) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (yoVariables == null) {
            for (int i = 0; i < defaultValues.length; ++i) {
                propertyNames.add(Double.toString(defaultValues[i]));
            }
        } else if (defaultValues == null) {
            for (int i = 0; i < yoVariables.length; ++i) {
                propertyNames.add(YoGraphicDefinitionFactory.toPropertyName(yoVariables[i]));
            }
        } else {
            for (int i = 0; i < yoVariables.length; ++i) {
                propertyNames.add(YoGraphicDefinitionFactory.toPropertyName(yoVariables[i], defaultValues[i]));
            }
        }
        return propertyNames;
    }

    public static String toPropertyName(ReferenceFrame referenceFrame) {
        return referenceFrame == null ? null : referenceFrame.getNameId();
    }

    public static String toPropertyName(YoVariable yoVariable) {
        return yoVariable == null ? null : yoVariable.getFullNameString();
    }

    public static String toPropertyName(YoVariable yoVariable, double defaultValue) {
        return yoVariable == null ? Double.toString(defaultValue) : yoVariable.getFullNameString();
    }

    public static String toPropertyName(YoInteger yoInteger, int defaultValue) {
        return yoInteger == null ? Integer.toString(defaultValue) : yoInteger.getFullNameString();
    }

    public static enum DefaultPoint2DGraphic {
        PLUS(false),
        CROSS(false),
        CIRCLE(false),
        CIRCLE_PLUS(false),
        CIRCLE_CROSS(false),
        DIAMOND(false),
        DIAMOND_PLUS(false),
        SQUARE(false),
        SQUARE_CROSS(false),
        CIRCLE_FILLED(true),
        DIAMOND_FILLED(true),
        SQUARE_FILLED(true);

        private final String graphicName;
        private final boolean filled;

        private DefaultPoint2DGraphic(boolean filled) {
            this.filled = filled;
            this.graphicName = this.name().charAt(0) + this.name().substring(1).replace("_FILLED", "").toLowerCase().replace("_", " ");
        }

        public boolean isFilled() {
            return this.filled;
        }

        public String getGraphicName() {
            return this.graphicName;
        }
    }
}

