package us.jakeabel.mpa.core;

import com.mongodb.client.MongoCollection;
import org.bson.Document;
import org.reflections.Reflections;
import us.jakeabel.mpa.core.api.Collection;

import java.io.IOException;
import java.util.*;

/**
 * Created by jake on 10/14/16.
 *
 * The connection properties
 */
public class DBConnection extends BaseConnection {


    protected static DBConnection instance = null;
    public static DBConnection getInstance() {
        if(DBConnection.instance == null) {
            try {
                DBConnection.instance = new DBConnection();
            } catch (IOException ex1) {
                System.out.println("Unable to load connection.properties file");
                ex1.printStackTrace();
            }
        }
        return DBConnection.instance;
    }

    public DBConnection() throws IOException {
        super();
    }

    public MongoCollection getCollection(Class<?> clazz) {
        return repos.get(clazz).getCollection();
    }


    public static void main(String[] args) {
        Properties properties = DBConnection.getInstance().properties;

        System.out.println(properties.toString());
    }


}
