package us.jakeabel.mpa.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;

/**
 * Created by jakeabel on 5/29/16.
 *
 * This is the base model that all database models need to inherit from in order to use the ID.
 */
public class DBModel {

    private MongoId _id;
    private String id;
    private Date createdOn;
    private Date modifiedOn;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public MongoId get_id() {
        return this._id;
    }

    @JsonProperty
    public void set_id(MongoId _id) {
        this.id = _id.toHexString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DBModel dbModel = (DBModel) o;

        return id != null ? id.equals(dbModel.id) : dbModel.id == null;

    }

    public Date getCreatedOn() {
        return (Date)createdOn.clone();
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getModifiedOn() {
        return (Date)modifiedOn.clone();
    }

    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "DBModel{" +
                "id='" + id + '\'' +
                '}';
    }
}
