package us.jakeabel.mpa.util;


import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.bson.Document;

/**
 * Created by jake on 5/7/16.
 *
 * Operations for Json Serialization
 */
public class MongoUtils<T> {

    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    /**
     * Convert document to a Bson Document
     * @param obj
     * @param <T>
     * @return
     */
    public static <T> Document toDocument(T obj) {
        return Document.parse(gson.toJson(obj));
    }

    public static <T> T fromDocument(Document doc, Class<T> tClass) {
        final ObjectMapper mapper = new ObjectMapper(); // jackson's objectmapper
        return mapper.convertValue(doc, tClass);
    }







}
