package us.jakeabel.mpa.core;


import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

/**
 * Created by jake on 10/14/16.
 *
 *
 * Utility for loading files from the class path.
 */
public class ClassPathResource {
    private final String path;
    private ClassLoader classLoader;
    private Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        System.out.println("Loading class path resource for path: " + path);
        String pathToUse = path;
        if(pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        System.out.println("Path = " + pathToUse);
        this.path = pathToUse;
        this.classLoader = classLoader != null ? classLoader : getDefaultClassLoader();
    }



    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        } catch (Throwable var1) {
            var1.printStackTrace();
        }
        if(cl == null) {
            cl = ClassPathResource.class.getClassLoader();
        }
        return cl;
    }


    public InputStream getInputStream() throws IOException {
        InputStream is;
        if(this.clazz != null) {
            is = this.clazz.getResourceAsStream(this.path);
        } else {
            is = this.classLoader.getResourceAsStream(this.path);
        }
        if(is == null) {
            throw new FileNotFoundException(this.path + " cannot be opened because it does not exist");
        } else {
            return is;
        }
    }


}
