package us.jakeabel.mpa.core;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;

import java.util.List;

/**
 * Created by jake on 10/15/16.
 * 
 * 
 * Basic Connection operations
 * 
 */
interface IConnection {

    <T> List<T> find(Document filter, Class<T> clazz);

    <T> List<T> findAndUpdate(Document filter, Document update, Class<T> clazz);

    <T> List<T> find(Class<T> clazz);

    <T> T find(String id, Class<T> clazz);

    <T> T findFirst(Document filter, Class<T> clazz);

    <T> T findFirstAndUpdate(Document filter, Document update, Class<T> clazz);

    long count(Class<? extends DBModel> clazz);

    <T> long count(Document filter, Class<T> clazz);

    <T> boolean exists(Document filter, Class<T> clazz);

    <T> T insert(T obj);

    <T> T create(T obj);

    DeleteResult delete(DBModel obj);

    DeleteResult delete(String id, Class<? extends DBModel> clazz);

    UpdateResult update(DBModel obj);


}
