package us.jakeabel.mpa.util;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import us.jakeabel.mpa.core.MongoConnection;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Created by Jake on 9/7/2015.
 *
 * Loads the mongo db connection
 *
 *
 *
 *
 */



public class MongoLoader {

    private static final Logger mongoLogger = Logger.getLogger("org.mongodb.driver");
    private static final Logger mongoJULogger = Logger.getLogger("org.mongodb.driver");


    private static Map<String, MongoDatabase> databases = new HashMap<>();


    /**
     * Sets the mongo database, useful when running unit tests.
     * @param host Host of the database.
     * @param port Port database uses.
     * @param dbName Database name
     */
    public static void setMongoDatabase(String host, int port, String dbName) {
        if(!databases.containsKey(dbName)) {
            databases.put(dbName, getMongoDatabase(host, port, dbName));
        }
    }



    /**
     * Loads the Mongo database if it has not been loaded.
     * @return Mongo Database.
     */
    public static MongoDatabase getMongoDatabase() {
        return getMongoDatabase("defaultDb");
    }


    /**
     * Loads the Mongo database if it has not been loaded.
     * @return Mongo Database.
     */
    public static MongoDatabase getMongoDatabase(String database) {
        if(!databases.containsKey(database)) {
            databases.put(database, getMongoDatabase("localhost", 27017, database));
        }
        return databases.get(database);
    }


//    /**
//     * Returns a new Connection to the Mongo Database.
//     * @return Initialized Mongo Database.
//     */
//    public static MongoDatabase newInstance() {
//        return loadMongo();
//    }


//    /**
//     * Loads the standard Mongo Database.
//     * @return the MongoDB
//     */
//    private static MongoDatabase loadMongo() {
//        return getMongoDatabase(PropertyLoader.getMongoHost(), PropertyLoader.getMongoPort(), PropertyLoader.getMongoDatabase());
//    }


    /**
     * Gets the Mongo Database
     * @param host URL of the database
     * @param port port used
     * @param dbName name of the database.
     * @return the initialized Mongo Database.
     */
    public static MongoDatabase getMongoDatabase(String host, int port, String dbName) {
        System.setProperty("DEBUG.MONGO", "false");
        System.setProperty("DB.TRACE", "false");
        Logger.getLogger("com.mongodb").setLevel(Level.OFF);
        Logger.getLogger("org.mongodb.driver.cluster").setLevel(Level.OFF);


        mongoLogger.setLevel(Level.SEVERE);
        mongoJULogger.setLevel(Level.SEVERE);

        MongoClient mongo = new MongoClient(host, port);
        return mongo.getDatabase(dbName);
    }


    /**
     * Gets the Mongo Database
     * @param host URL of the database
     * @param port port used
     * @return the initialized Mongo Database.
     */
    public static MongoDatabase getMongoDatabase(String host, int port) {
        System.setProperty("DEBUG.MONGO", "false");
        System.setProperty("DB.TRACE", "false");
        Logger.getLogger("com.mongodb").setLevel(Level.OFF);
        Logger.getLogger("org.mongodb.driver.cluster").setLevel(Level.OFF);


        mongoLogger.setLevel(Level.SEVERE);
        mongoJULogger.setLevel(Level.SEVERE);

        MongoClient mongo = new MongoClient(host, port);
        return mongo.getDatabase("defaultDb");
    }

    /**
     * Gets the mongo database includes the Username and Password.
     * @param host URL of the database.
     * @param port Port to use.
     * @param dbName Database Name
     * @param username Username for the account
     * @param password Password for the account
     * @return The authenticated Mongo Database.
     */
    public static MongoDatabase getMongoDatabase(String host, int port, String dbName, String username, String password) {
        return getMongoDatabase(host, port, dbName);
    }




    public static MongoConnection getConnection(String host, int port, String dbName) {
        return new MongoConnection();
    }

}
