package us.jakeabel.mpa.util;


import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import org.bson.Document;
import org.bson.types.ObjectId;
import us.jakeabel.mpa.example.TestCase;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.*;
import java.util.function.Predicate;

/**
 * Created by jake on 5/7/16.
 *
 * Operations for Json Serialization
 */
public class MongoUtils<T> {

    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    /**
     * Convert document to a Bson Document
     * @param obj
     * @param <T>
     * @return
     */
    public static <T> Document toDocument(T obj) {
        try {
            List<Field> fields = new ArrayList<>();
            fields = getAllFields(fields, obj.getClass());
            Document doc = new Document();
            for (Field f : fields) {
                if(f.getName().equals("id")) {
                    f.setAccessible(true);
                    String id = (String)f.get(obj);
                    if(id != null) {
                        doc.append("_id", new ObjectId((String)f.get(obj)));
                    }
                }
                else {
                    f.setAccessible(true);
                    doc.append(f.getName(), f.get(obj));
                }
            }
            return doc;
        } catch (IllegalAccessException iae) {
            iae.printStackTrace();
            assert false;
        }
        return null;
//        return Document.parse(gson.toJson(obj));
    }

    public static void main(String[] args) {
        TestCase testCase = new TestCase();
        testCase.setId(new ObjectId().toHexString());

        Document out = toDocument(testCase);
        System.out.println("out.getObjectId(\"_id\") = " + out.getObjectId("_id"));


        int debug = 0;
    }



    public static <T> T fromDocument(Document doc, Class<T> tClass) {

//        Field[] fields = tClass.getClass().getDeclaredFields();
//        try {
//            T obj = tClass.newInstance();
//            for(Field f : fields) {
//                if(doc.containsKey(f.getName())) {
//                    f.set(obj, doc.get(f.getName()));
//                }
//            }
//            return obj;
//        } catch (InstantiationException | IllegalAccessException e) {
//            e.printStackTrace();
//            assert true;
//        }
//        return null;


        JsonElement jsonElement = new Gson().toJsonTree(doc);

        List<Field> fields = new ArrayList<>();
        fields = getAllFields(fields, tClass);
        try {
            T obj = tClass.newInstance();
            for(Field f : fields) {
                if(f.getName().equals("id")) {
                    if(doc.containsKey("_id")) {
                        f.setAccessible(true);
                        f.set(obj, doc.getObjectId("_id").toHexString());
                    }
                }
                else if(doc.containsKey(f.getName())) {
                    if(f.getType() == Date.class) {
                        int debugger = 0;
                        Object dateObj = doc.get(f.getName());
                        if(dateObj instanceof Date) {
                            f.setAccessible(true);
                            f.set(obj, doc.getDate(f.getName()));
                        }
                        else if(dateObj instanceof String) {
                            f.setAccessible(true);
                            f.set(obj, DateUtils.parseDate((String)dateObj));
                        }
//                        f.set(obj, doc.getDate(f.getName()));
                    }
                    else if(f.getType() == ObjectId.class) {
                        int debug = 0;
                    }
                    else {
                        f.setAccessible(true);
                        f.set(obj, doc.get(f.getName()));
                    }
                }
            }
            return obj;
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            assert true;
        }
        return null;

//        return new Gson().fromJson(jsonElement, new TypeToken<T>(){}.getType());

//        final ObjectMapper mapper = new ObjectMapper(); // jackson's objectmapper
//        return mapper.convertValue(doc, tClass);
    }


    /**
     * Gets all fields including super classes fileds.
     * @param fields
     * @param type
     * @return
     */
    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.removeIf(new Predicate<Field>() {
            @Override
            public boolean test(Field field) {
                return field.getName().equals("_id");
            }
        });
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }







}
