package us.jakeabel.mpa.core;

import com.mongodb.client.MongoCollection;
import org.bson.Document;
import org.reflections.Reflections;
import us.jakeabel.mpa.core.api.Collection;

import java.io.IOException;
import java.util.*;

/**
 * Created by jake on 10/14/16.
 *
 * The connection properties
 */
public class DBConnection extends BaseConnection {


    protected static Map<String, DBConnection> instances = new HashMap<>();
    public static final String DEFAULT_CONNECTION = "DEFAULT";

    /**
     * Loads the connection based off the properties file.
     * @return DBConnection to use.
     */
    public static DBConnection getInstance() {
        return getConnectionInstance(DEFAULT_CONNECTION);
    }


    /**
     * Gets the connection instance based upon connection string
     * EXAMPLE: localhost:27017/defaultdbname
     * @param instance DBConnection
     * @return DBConnection
     */
    public static DBConnection getInstance(String instance) {
        return getConnectionInstance(instance);
    }




    private static DBConnection getConnectionInstance(String instanceName) {
        if(!DBConnection.instances.containsKey(instanceName)) {
            try {
                DBConnection instance = null;
                if(instanceName.equals(DEFAULT_CONNECTION)) {
                    instance = new DBConnection();
                }
                else {
                    instance = new DBConnection(instanceName);
                }
                instances.put(instanceName, instance);
            } catch (IOException ex1) {
                System.out.println("Unable to load connection.properties file");
                ex1.printStackTrace();
            }
        }
        return instances.get(instanceName);
    }



    public DBConnection() throws IOException {
        super();
    }

    public DBConnection(String connectionString) throws IOException {
        super(connectionString);
    }


    public MongoCollection getCollection(Class<?> clazz) {
        return repos.get(clazz).getCollection();
    }


    public static void main(String[] args) {
        Properties properties = DBConnection.getInstance().properties;

        System.out.println(properties.toString());
    }


}
