package us.jakeabel.mpa.core;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;

import java.util.List;


/**
 * Basic interface
 * @param <T>
 */
public interface IBaseRepo<T> {

    List<T> find(Document filter);

    T findLimit(Document filter, int limit);

    List<T> find();

    T findAndUpdate(Document filter, Document update, Class<T> clazz);

    T find(String _id);

    List<T> find(int limit, int page);

    long count();

    long count(Document filter);

    boolean exists(Document filter);

    T insert(T obj);

    void insertBulk(List<T> list);

    DeleteResult delete(T obj);

    DeleteResult delete(String id);

    UpdateResult update(T obj);

}
