package us.jakeabel.mpa.core;


import java.util.Date;

public class MongoId {

    private String time;
    private int timeSecond;
    private int timestamp;
    private int machineIdentifier;
    private short processIdentifier;
    private int counter;
    private Date date;

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getTimeSecond() {
        return timeSecond;
    }

    public void setTimeSecond(int timeSecond) {
        this.timeSecond = timeSecond;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public int getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public int getMachineIdentifier() {
        return machineIdentifier;
    }

    public void setMachineIdentifier(int machineIdentifier) {
        this.machineIdentifier = machineIdentifier;
    }

    public short getProcessIdentifier() {
        return processIdentifier;
    }

    public void setProcessIdentifier(short processIdentifier) {
        this.processIdentifier = processIdentifier;
    }

    public int getCounter() {
        return counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }


    public String toHexString() {
        StringBuilder buf = new StringBuilder(24);
        byte[] var2 = this.toByteArray();
        int var3 = var2.length;

        for(int var4 = 0; var4 < var3; ++var4) {
            byte b = var2[var4];
            buf.append(String.format("%02x", new Object[]{Integer.valueOf(b & 255)}));
        }

        return buf.toString();
    }

    /**
     * Convert to a byte array.  Note that the numbers are stored in big-endian order.
     *
     * @return the byte array
     */
    public byte[] toByteArray() {
        byte[] bytes = new byte[12];
        bytes[0] = int3(timestamp);
        bytes[1] = int2(timestamp);
        bytes[2] = int1(timestamp);
        bytes[3] = int0(timestamp);
        bytes[4] = int2(machineIdentifier);
        bytes[5] = int1(machineIdentifier);
        bytes[6] = int0(machineIdentifier);
        bytes[7] = short1(processIdentifier);
        bytes[8] = short0(processIdentifier);
        bytes[9] = int2(counter);
        bytes[10] = int1(counter);
        bytes[11] = int0(counter);
        return bytes;
    }




    private static byte int3(final int x) {
        return (byte) (x >> 24);
    }

    private static byte int2(final int x) {
        return (byte) (x >> 16);
    }

    private static byte int1(final int x) {
        return (byte) (x >> 8);
    }

    private static byte int0(final int x) {
        return (byte) (x);
    }

    private static byte short1(final short x) {
        return (byte) (x >> 8);
    }

    private static byte short0(final short x) {
        return (byte) (x);
    }

    @Override
    public String toString() {
        return "MongoId{" +
                "time='" + time + '\'' +
                ", timeSecond=" + timeSecond +
                ", timestamp=" + timestamp +
                ", machineIdentifier=" + machineIdentifier +
                ", processIdentifier=" + processIdentifier +
                ", counter=" + counter +
                ", date=" + date +
                '}';
    }
}
