package us.jakeabel.mpa.util;


import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.mongodb.BasicDBList;
import org.bson.Document;
import org.bson.types.ObjectId;
import us.jakeabel.mpa.core.MpaNested;
import us.jakeabel.mpa.core.MpaNestedList;
import us.jakeabel.mpa.example.TestCase;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.*;
import java.util.function.Predicate;

/**
 * Created by jake on 5/7/16.
 *
 * Operations for Json Serialization
 */
public class MongoUtils<T> {

    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    /**
     * Convert document to a Bson Document
     * @param obj
     * @param <T>
     * @return
     */
    public static <T> Document toDocument(T obj) {
        try {
            List<Field> fields = new ArrayList<>();
            fields = getAllFields(fields, obj.getClass());
            Document doc = new Document();
            for (Field f : fields) {
                if(f.getName().equals("id")) {
                    f.setAccessible(true);
                    String id = (String)f.get(obj);
                    if(id != null) {
                        doc.append("_id", new ObjectId((String)f.get(obj)));
                    }
                }
                else {
                    Annotation[] annotations = f.getAnnotations();
                    if(annotations == null || annotations.length == 0) {
                        f.setAccessible(true);
                        doc.append(f.getName(), f.get(obj));
                    }
                    else {
                        for(Annotation ann : annotations) {
                            if(ann instanceof MpaNested) {
                                f.setAccessible(true);
                                Document inner = MongoUtils.toDocument(f.get(obj));
                                doc.append(f.getName(), inner);
                            }
                            else if(ann instanceof MpaNestedList) {
                                f.setAccessible(true);
                                List list = (List)f.get(obj);
                                BasicDBList dbList = new BasicDBList();
                                for(Object o : list) {
                                    Document inner = MongoUtils.toDocument(o);
                                    dbList.add(inner);
                                }
                                doc.append(f.getName(), dbList);
                            }
                        }
                    }
                }
            }
            return doc;
        } catch (IllegalAccessException iae) {
            iae.printStackTrace();
            assert false;
        }
        return null;
//        return Document.parse(gson.toJson(obj));
    }

    public static void main(String[] args) {
        TestCase testCase = new TestCase();
        testCase.setId(new ObjectId().toHexString());

        Document out = toDocument(testCase);
        System.out.println("out.getObjectId(\"_id\") = " + out.getObjectId("_id"));


        int debug = 0;
    }
//
//
//
//    public static <T> T fromDocument(Document doc, Class<T> tClass) {
//        JsonElement jsonElement = new Gson().toJsonTree(doc);
//
//        List<Field> fields = new ArrayList<>();
//        fields = getAllFields(fields, tClass);
//        try {
//            T obj = tClass.newInstance();
//            for(Field f : fields) {
//                Annotation[] annotations = f.getAnnotations();
//                if(f.getName().equals("id")) {
//                    if(doc.containsKey("_id")) {
//                        f.setAccessible(true);
//                        f.set(obj, doc.getObjectId("_id").toHexString());
//                    }
//                }
//                else if(doc.containsKey(f.getName())) {
//                    if(f.getType() == Date.class) {
//                        Object dateObj = doc.get(f.getName());
//                        if(dateObj instanceof Date) {
//                            f.setAccessible(true);
//                            f.set(obj, doc.getDate(f.getName()));
//                        }
//                        else if(dateObj instanceof String) {
//                            f.setAccessible(true);
//                            f.set(obj, DateUtils.parseDate((String)dateObj));
//                        }
//                    }
//                    f.setAccessible(true);
//                    f.set(obj, doc.get(f.getName()));
//                }
//            }
//            return obj;
//        } catch (InstantiationException | IllegalAccessException e) {
//            e.printStackTrace();
//            assert true;
//        }
//        return null;
//    }





    public static <T> T fromDocument(Document doc, Class<T> tClass) {
        List<Field> fields = new ArrayList<>();
        fields = getAllFields(fields, tClass);
        try {
            T obj = tClass.newInstance();
            for(Field f : fields) {
                if(f.getName().equals("id")) {
                    if(doc.containsKey("_id")) {
                        f.setAccessible(true);
                        f.set(obj, doc.getObjectId("_id").toHexString());
                        continue;
                    }
                }
                if(doc.containsKey(f.getName())) {
                    if (f.getType() == Date.class) {
                        Object dateObj = doc.get(f.getName());
                        if (dateObj instanceof Date) {
                            f.setAccessible(true);
                            f.set(obj, doc.getDate(f.getName()));
                        } else if (dateObj instanceof String) {
                            f.setAccessible(true);
                            f.set(obj, DateUtils.parseDate((String) dateObj));
                        }
                    }
                    else {
                        Annotation[] annotations = f.getAnnotations();
                        if(annotations == null || annotations.length == 0) {
                            f.setAccessible(true);
                            f.set(obj, doc.get(f.getName()));
                            continue;
                        }

                        for(Annotation ann : annotations) {
                            if(ann instanceof MpaNested) {
                                f.setAccessible(true);
                                f.set(obj, MongoUtils.fromDocument((Document)doc.get(f.getName()), f.getType()));
                            }
                            else if(ann instanceof MpaNestedList) {
                                f.setAccessible(true);

                                if(doc.get(f.getName()) instanceof List) {
                                    List<Document> dbList = (List<Document>)doc.get(f.getName());

                                    ParameterizedType genericType = (ParameterizedType) f.getGenericType();
                                    Class<?> listItemClass = (Class<?>) genericType.getActualTypeArguments()[0];

                                    List list = new ArrayList();
                                    for(Object arrDoc : dbList) {
                                        list.add(MongoUtils.fromDocument((Document)arrDoc, listItemClass));
                                    }
                                    f.set(obj, list);
                                }
                                else if(doc.get(f.getName()) instanceof BasicDBList) {
                                    BasicDBList dbList = (BasicDBList)doc.get(f.getName());

                                    ParameterizedType genericType = (ParameterizedType) f.getGenericType();
                                    Class<?> listItemClass = (Class<?>) genericType.getActualTypeArguments()[0];
                                    System.out.println(listItemClass);

                                    List list = new ArrayList();
                                    for(Object arrDoc : dbList) {
                                        list.add(MongoUtils.fromDocument((Document)arrDoc, listItemClass));
                                    }
                                    f.set(obj, list);
                                }

                            }
                        }
                    }
                }
            }
            return obj;
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
            assert true;
        }
        return null;
    }


    /**
     * Gets all fields including super classes fileds.
     * @param fields
     * @param type
     * @return
     */
    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.removeIf(new Predicate<Field>() {
            @Override
            public boolean test(Field field) {
                return field.getName().equals("_id");
            }
        });
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }







}
