/*
 * Decompiled with CFR 0.152.
 */
package us.jakeabel.mpa.core;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import us.jakeabel.mpa.core.BaseRepo;
import us.jakeabel.mpa.core.ClassPathResource;
import us.jakeabel.mpa.core.DBModel;
import us.jakeabel.mpa.core.IConnection;
import us.jakeabel.mpa.core.api.Collection;

public class BaseConnection
implements IConnection {
    protected Properties properties = null;
    protected Map<Class<?>, BaseRepo> repos = new HashMap();

    BaseConnection(String connectionString) throws IOException {
        String host = null;
        int port = -1;
        String dbName = null;
        if (connectionString.matches(".*:\\d+/.*")) {
            host = connectionString.replaceAll(":.*", "");
            String portStr = connectionString.replaceAll("/.*", "").replaceAll(".*:", "");
            port = Integer.parseInt(portStr);
            dbName = connectionString.replaceAll(".*/", "");
        }
        if (host == null && port == -1 || dbName == null) {
            throw new IOException("Invalid data exception");
        }
        ClassPathResource cpr = new ClassPathResource("connection.properties");
        this.properties = new Properties();
        this.properties.load(cpr.getInputStream());
        String basePackage = this.properties.getProperty("basePackage");
        System.out.println("Scanning package: " + basePackage);
        Reflections reflections = new Reflections(basePackage, new Scanner[0]);
        Set clazzes = reflections.getTypesAnnotatedWith(Collection.class);
        for (Class c : clazzes) {
            System.out.println(c.getSimpleName());
            Class<?> claz = null;
            try {
                claz = c.newInstance().getClass();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            if (claz == null) continue;
            this.repos.put(c, BaseRepo.createBaseRepo(claz, host, port, dbName));
        }
    }

    BaseConnection() throws IOException {
        ClassPathResource cpr = new ClassPathResource("connection.properties");
        this.properties = new Properties();
        this.properties.load(cpr.getInputStream());
        String basePackage = this.properties.getProperty("basePackage");
        System.out.println("Scanning package: " + basePackage);
        String dbName = this.properties.getProperty("defaultdb");
        Reflections reflections = new Reflections(basePackage, new Scanner[0]);
        Set clazzes = reflections.getTypesAnnotatedWith(Collection.class);
        for (Class c : clazzes) {
            System.out.println(c.getSimpleName());
            Class<?> claz = null;
            try {
                claz = c.newInstance().getClass();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            if (claz == null) continue;
            this.repos.put(c, BaseRepo.createBaseRepo(claz, dbName));
        }
    }

    @Override
    public <T> List<T> find(Document filter, Class<T> clazz) {
        return this.repos.get(clazz).find(filter);
    }

    @Override
    public <T> List<T> find(Class<T> clazz) {
        return this.repos.get(clazz).find();
    }

    @Override
    public <T> T find(String id, Class<T> clazz) {
        List list = this.repos.get(clazz).find(new Document("_id", (Object)new ObjectId(id)));
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T> List<T> findAndUpdate(Document filter, Document update, Class<T> clazz) {
        return this.repos.get(clazz).find(filter);
    }

    @Override
    public <T> T findFirstAndUpdate(Document filter, Document update, Class<T> clazz) {
        return this.repos.get(clazz).findAndUpdate(filter, update, clazz);
    }

    @Override
    public <T> T findFirst(Document filter, Class<T> clazz) {
        List list = this.repos.get(clazz).find(filter);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T> boolean exists(Document filter, Class<T> clazz) {
        return this.count(filter, clazz) > 0L;
    }

    @Override
    public long count(Class<? extends DBModel> clazz) {
        return this.repos.get(clazz).count();
    }

    @Override
    public <T> long count(Document filter, Class<T> clazz) {
        return this.repos.get(clazz).count(filter);
    }

    @Override
    public <T> T insert(T obj) {
        return this.repos.get(obj.getClass()).insert(obj);
    }

    @Override
    public <T> void insertBulk(List<T> list) {
        this.repos.get(list.get(0).getClass()).insertBulk(list);
    }

    @Override
    public <T> T create(T obj) {
        return this.repos.get(obj.getClass()).insert(obj);
    }

    @Override
    public DeleteResult delete(DBModel obj) {
        return this.repos.get(obj.getClass()).delete(obj);
    }

    @Override
    public DeleteResult delete(String id, Class<? extends DBModel> clazz) {
        return this.repos.get(clazz).delete(id);
    }

    @Override
    public UpdateResult update(DBModel obj) {
        return this.repos.get(obj.getClass()).update(obj);
    }
}

