/*
 * Decompiled with CFR 0.152.
 */
package us.jakeabel.mpa.core;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import us.jakeabel.mpa.core.DBModel;
import us.jakeabel.mpa.core.IBaseRepo;
import us.jakeabel.mpa.core.api.Collection;
import us.jakeabel.mpa.util.MongoLoader;
import us.jakeabel.mpa.util.MongoUtils;

public class BaseRepo<T>
implements IBaseRepo<T> {
    protected MongoCollection<Document> collection;
    private Class<T> genericType;

    public static <T extends DBModel> BaseRepo createBaseRepo(Class<T> clazz, String dbName) {
        return new BaseRepo<T>(clazz, dbName);
    }

    public static <T extends DBModel> BaseRepo createBaseRepo(Class<T> clazz, String host, int port, String dbName) {
        return new BaseRepo<T>(clazz, dbName);
    }

    public Class<?> getGenericTypeOfthisClass() {
        Class thisClass = null;
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            thisClass = (Class)typeArguments[0];
        }
        return thisClass;
    }

    public BaseRepo(Class<T> tClass, String dbName) {
        this.genericType = tClass;
        Collection colAnnotation = tClass.getAnnotation(Collection.class);
        this.collection = MongoLoader.getMongoDatabase(dbName).getCollection(colAnnotation.name());
    }

    public BaseRepo() {
        this.genericType = this.getGenericTypeOfthisClass();
    }

    public BaseRepo(String collectionName) {
        this.collection = MongoLoader.getMongoDatabase().getCollection(collectionName);
        this.genericType = this.getGenericTypeOfthisClass();
    }

    public BaseRepo(String database, String collectionName) {
        this.collection = MongoLoader.getMongoDatabase(database).getCollection(collectionName);
        this.genericType = this.getGenericTypeOfthisClass();
    }

    public BaseRepo(String host, int port, String database, String collection) {
        this.collection = MongoLoader.getMongoDatabase(host, port, database).getCollection(collection);
        this.genericType = this.getGenericTypeOfthisClass();
    }

    public BaseRepo(String host, int port, String dbName, Class<T> tClass) {
        this.genericType = tClass;
        Collection colAnnotation = tClass.getAnnotation(Collection.class);
        this.collection = MongoLoader.getMongoDatabase(host, port, dbName).getCollection(colAnnotation.name());
    }

    @Override
    public long count() {
        return this.collection.count();
    }

    @Override
    public long count(Document filter) {
        return this.collection.count((Bson)filter);
    }

    @Override
    public List<T> find(Document filter) {
        final ArrayList items = new ArrayList();
        this.collection.find((Bson)filter).forEach((Consumer)new Consumer<Document>(){

            @Override
            public void accept(Document document) {
                items.add(MongoUtils.fromDocument(document, BaseRepo.this.genericType));
            }
        });
        return items;
    }

    @Override
    public T findAndUpdate(Document filter, Document update, Class<T> clazz) {
        Document doc = (Document)this.collection.findOneAndUpdate((Bson)filter, (Bson)update);
        if (doc == null) {
            return null;
        }
        return MongoUtils.fromDocument(doc, clazz);
    }

    @Override
    public List<T> find() {
        final ArrayList items = new ArrayList();
        this.collection.find().forEach((Consumer)new Consumer<Document>(){

            @Override
            public void accept(Document document) {
                items.add(MongoUtils.fromDocument(document, BaseRepo.this.genericType));
            }
        });
        return items;
    }

    @Override
    public List<T> find(int limit, int page) {
        final ArrayList items = new ArrayList();
        this.collection.find().limit(limit).skip((page - 1) * limit).forEach((Consumer)new Consumer<Document>(){

            @Override
            public void accept(Document document) {
                items.add(MongoUtils.fromDocument(document, BaseRepo.this.genericType));
            }
        });
        return items;
    }

    @Override
    public T findLimit(Document filter, int limit) {
        final ArrayList items = new ArrayList();
        this.collection.find().limit(limit).forEach((Consumer)new Consumer<Document>(){

            @Override
            public void accept(Document document) {
                items.add(MongoUtils.fromDocument(document, BaseRepo.this.genericType));
            }
        });
        if (items.size() == 0) {
            return null;
        }
        return (T)items.get(0);
    }

    @Override
    public boolean exists(Document filter) {
        return this.count(filter) > 0L;
    }

    @Override
    public T find(String _id) {
        return this.findFirstItem(new Document("_id", (Object)new ObjectId(_id)));
    }

    public T findFirst(Document doc) {
        return this.findFirstItem(doc);
    }

    private T findFirstItem(Document filter) {
        Document first = (Document)this.collection.find((Bson)filter).first();
        if (first == null) {
            return null;
        }
        return MongoUtils.fromDocument(first, this.genericType);
    }

    @Override
    public T insert(T obj) {
        Document doc = MongoUtils.toDocument(obj);
        this.collection.insertOne((Object)doc);
        return this.findFirstItem(MongoUtils.toDocument(obj));
    }

    @Override
    public void insertBulk(List<T> list) {
        ArrayList<Document> docs = new ArrayList<Document>();
        for (T obj : list) {
            docs.add(MongoUtils.toDocument(obj));
        }
        this.collection.insertMany(docs);
    }

    @Override
    public DeleteResult delete(T obj) {
        return this.collection.deleteOne((Bson)new Document("_id", (Object)new ObjectId(((DBModel)obj).getId())));
    }

    @Override
    public DeleteResult delete(String id) {
        return this.collection.deleteOne((Bson)new Document("_id", (Object)new ObjectId(id)));
    }

    @Override
    public UpdateResult update(T obj) {
        Document doc = MongoUtils.toDocument(obj);
        return this.collection.updateOne((Bson)new Document("_id", (Object)new ObjectId(((DBModel)obj).getId())), (Bson)new Document("$set", (Object)doc));
    }

    public MongoCollection<Document> getCollection() {
        return this.collection;
    }
}

