/*
 * Decompiled with CFR 0.152.
 */
package us.jakeabel.mpa.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ClassPathResource {
    private final String path;
    private ClassLoader classLoader;
    private Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        System.out.println("Loading class path resource for path: " + path);
        String pathToUse = path;
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        System.out.println("Path = " + pathToUse);
        this.path = pathToUse;
        this.classLoader = classLoader != null ? classLoader : ClassPathResource.getDefaultClassLoader();
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable var1) {
            var1.printStackTrace();
        }
        if (cl == null) {
            cl = ClassPathResource.class.getClassLoader();
        }
        return cl;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : this.classLoader.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException(this.path + " cannot be opened because it does not exist");
        }
        return is;
    }
}

