/*
 * Decompiled with CFR 0.152.
 */
package us.jakeabel.mpa.core;

import com.mongodb.client.MongoCollection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import us.jakeabel.mpa.core.BaseConnection;
import us.jakeabel.mpa.core.BaseRepo;

public class DBConnection
extends BaseConnection {
    protected static Map<String, DBConnection> instances = new HashMap<String, DBConnection>();
    public static final String DEFAULT_CONNECTION = "DEFAULT";

    public static DBConnection getInstance() {
        return DBConnection.getConnectionInstance(DEFAULT_CONNECTION);
    }

    public static DBConnection getInstance(String instance) {
        return DBConnection.getConnectionInstance(instance);
    }

    private static DBConnection getConnectionInstance(String instanceName) {
        if (!instances.containsKey(instanceName)) {
            try {
                DBConnection instance = null;
                instance = instanceName.equals(DEFAULT_CONNECTION) ? new DBConnection() : new DBConnection(instanceName);
                instances.put(instanceName, instance);
            }
            catch (IOException ex1) {
                System.out.println("Unable to load connection.properties file");
                ex1.printStackTrace();
            }
        }
        return instances.get(instanceName);
    }

    public DBConnection() throws IOException {
    }

    public DBConnection(String connectionString) throws IOException {
        super(connectionString);
    }

    public MongoCollection getCollection(Class<?> clazz) {
        return ((BaseRepo)this.repos.get(clazz)).getCollection();
    }

    public static void main(String[] args) {
        Properties properties = DBConnection.getInstance().properties;
        System.out.println(properties.toString());
    }
}

