/*
 * Decompiled with CFR 0.152.
 */
package us.jakeabel.mpa.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    public static String toIso8601(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        return df.format(date);
    }

    public static Date fromIso8601(String dateStr) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        Date date = new Date();
        try {
            date = df.parse(dateStr);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        return date;
    }

    public static int getMonthFromString(String monthStr) {
        boolean month = false;
        if (monthStr.matches("(?i).*((january)|(jan)).*")) {
            return 0;
        }
        if (monthStr.matches("(?i).*((february)|(feb)).*")) {
            return 1;
        }
        if (monthStr.matches("(?i).*((march)|(mar)).*")) {
            return 2;
        }
        if (monthStr.matches("(?i).*((april)|(apr)).*")) {
            return 3;
        }
        if (monthStr.matches("(?i).*(may).*")) {
            return 4;
        }
        if (monthStr.matches("(?i).*((june)|(jun)).*")) {
            return 5;
        }
        if (monthStr.matches("(?i).*((july)|(jul)).*")) {
            return 6;
        }
        if (monthStr.matches("(?i).*((august)|(aug)).*")) {
            return 7;
        }
        if (monthStr.matches("(?i).*((september)|(sep)|(sept)).*")) {
            return 8;
        }
        if (monthStr.matches("(?i).*((october)|(oct)).*")) {
            return 9;
        }
        if (monthStr.matches("(?i).*((november)|(nov)).*")) {
            return 10;
        }
        if (monthStr.matches("(?i).*((december)|(dec)).*")) {
            return 11;
        }
        return 0;
    }

    public static Calendar parseCalendar(String dateString) {
        if (dateString.matches(".*/.*") && dateString.matches(".*:.*")) {
            String[] parts = dateString.split("\\s");
            int month = 0;
            int day = 0;
            int year = 0;
            int hour = 0;
            int minute = 0;
            for (String part : parts) {
                String[] dateParts;
                if (part.matches("\\d{1,2}/\\d{1,2}/\\d{2,4}")) {
                    dateParts = part.split("/");
                    if (dateParts.length != 3) continue;
                    month = Integer.parseInt(dateParts[0]);
                    day = Integer.parseInt(dateParts[1]);
                    year = Integer.parseInt(dateParts[2]);
                    continue;
                }
                if (part.matches("\\d{1,2}:\\d{2}")) {
                    dateParts = part.split(":");
                    if (dateParts.length != 2) continue;
                    hour = Integer.parseInt(dateParts[0]);
                    minute = Integer.parseInt(dateParts[1]);
                    continue;
                }
                if (!part.matches("(AM)|(PM)") || !part.matches("(?i)pm")) continue;
                hour += 12;
            }
            return new GregorianCalendar(year, month, day, hour, minute);
        }
        if (!dateString.contains(":")) {
            String[] parts;
            dateString = dateString.replaceAll("((Monday)|(Tuesday)|(Wednesday)|(Thursday)|(Friday)|(Saturday)|(Sunday)|(Mon)|(Tue)|(Wed)|(Thu)|(Fri)|(Sat)|(Sun))", " ").replaceAll("\\s+", " ").trim();
            dateString = dateString.replaceAll("^,", "").trim();
            int month = DateUtils.getMonthFromString(dateString);
            dateString = dateString.replaceAll("((January)|(February)|(March)|(April)|(May)|(June)|(July)|(August)|(September)|(October)|(November)|(December)|(Jan)|(Feb)|(Mar)|(Apr)|(May)|(Jun)|(Jul)|(Aug)|(Sep)|(Oct)|(Nov)|(Dec))", " ").replaceAll("\\s+", " ").trim();
            int dayOfMonth = 0;
            int year = 0;
            for (String p : parts = dateString.split(",")) {
                if ((p = p.trim()).matches("\\d{1,2}")) {
                    dayOfMonth = Integer.parseInt(p);
                    continue;
                }
                if (!p.matches("\\d{4}")) continue;
                year = Integer.parseInt(p);
            }
            return new GregorianCalendar(year, month, dayOfMonth);
        }
        if (dateString.matches(".*((January)|(February)|(March)|(April)|(May)|(June)|(July)|(August)|(September)|(October)|(November)|(December)|(Jan)|(Feb)|(Mar)|(Apr)|(May)|(Jun)|(Jul)|(Aug)|(Sep)|(Oct)|(Nov)|(Dec)).*")) {
            dateString = dateString.replaceAll("((Monday)|(Tuesday)|(Wednesday)|(Thursday)|(Friday)|(Saturday)|(Sunday)|(Mon)|(Tue)|(Wed)|(Thu)|(Fri)|(Sat)|(Sun))", " ");
            dateString = dateString.trim().replaceAll("^,", "").trim();
            int month = DateUtils.getMonthFromString(dateString);
            dateString = dateString.replaceAll("((January)|(February)|(March)|(April)|(May)|(June)|(July)|(August)|(September)|(October)|(November)|(December)|(Jan)|(Feb)|(Mar)|(Apr)|(May)|(Jun)|(Jul)|(Aug)|(Sep)|(Oct)|(Nov)|(Dec))", " ").replaceAll("\\s+", " ");
            String[] parts = dateString.split("((\\s)|(,))");
            int dayOfMonth = 0;
            int year = 0;
            int hour = 0;
            int minute = 0;
            boolean amOrPm = false;
            for (String part : parts) {
                if (part.equals("")) continue;
                if ((part = part.trim()).matches("[\\d]{4}")) {
                    year = Integer.parseInt(part);
                    continue;
                }
                if (part.matches("\\d{1,2}")) {
                    dayOfMonth = Integer.parseInt(part);
                    continue;
                }
                if (part.matches("\\d{1,2}:\\d{2}")) {
                    String[] timeParts = part.split(":");
                    hour = Integer.parseInt(timeParts[0]);
                    minute = Integer.parseInt(timeParts[1]);
                    continue;
                }
                if (part.matches("(?i)am")) {
                    amOrPm = false;
                    continue;
                }
                if (!part.matches("(?i)pm")) continue;
                amOrPm = true;
            }
            if (amOrPm) {
                hour += 12;
            }
            return new GregorianCalendar(year, month, dayOfMonth, hour, minute);
        }
        return GregorianCalendar.getInstance();
    }

    public static Date parseDate(String dateString) {
        return DateUtils.parseCalendar(dateString).getTime();
    }

    public static String parseDateToIso(String dateString) {
        return DateUtils.toIso8601(DateUtils.parseDate(dateString));
    }
}

