/*
 * Decompiled with CFR 0.152.
 */
package us.jakeabel.mpa.util;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.jakeabel.mpa.core.MongoConnection;

public class MongoLoader {
    private static final Logger mongoLogger = Logger.getLogger("org.mongodb.driver");
    private static final Logger mongoJULogger = Logger.getLogger("org.mongodb.driver");
    private static Map<String, MongoDatabase> databases = new HashMap<String, MongoDatabase>();

    public static void setMongoDatabase(String host, int port, String dbName) {
        if (!databases.containsKey(dbName)) {
            databases.put(dbName, MongoLoader.getMongoDatabase(host, port, dbName));
        }
    }

    public static MongoDatabase getMongoDatabase() {
        return MongoLoader.getMongoDatabase("defaultDb");
    }

    public static MongoDatabase getMongoDatabase(String database) {
        if (!databases.containsKey(database)) {
            databases.put(database, MongoLoader.getMongoDatabase("localhost", 27017, database));
        }
        return databases.get(database);
    }

    public static MongoDatabase getMongoDatabase(String host, int port, String dbName) {
        System.setProperty("DEBUG.MONGO", "false");
        System.setProperty("DB.TRACE", "false");
        Logger.getLogger("com.mongodb").setLevel(Level.OFF);
        Logger.getLogger("org.mongodb.driver.cluster").setLevel(Level.OFF);
        mongoLogger.setLevel(Level.SEVERE);
        mongoJULogger.setLevel(Level.SEVERE);
        MongoClient mongo = new MongoClient(host, port);
        return mongo.getDatabase(dbName);
    }

    public static MongoDatabase getMongoDatabase(String host, int port) {
        System.setProperty("DEBUG.MONGO", "false");
        System.setProperty("DB.TRACE", "false");
        Logger.getLogger("com.mongodb").setLevel(Level.OFF);
        Logger.getLogger("org.mongodb.driver.cluster").setLevel(Level.OFF);
        mongoLogger.setLevel(Level.SEVERE);
        mongoJULogger.setLevel(Level.SEVERE);
        MongoClient mongo = new MongoClient(host, port);
        return mongo.getDatabase("defaultDb");
    }

    public static MongoDatabase getMongoDatabase(String host, int port, String dbName, String username, String password) {
        return MongoLoader.getMongoDatabase(host, port, dbName);
    }

    public static MongoConnection getConnection(String host, int port, String dbName) {
        return new MongoConnection();
    }
}

