/*
 * Decompiled with CFR 0.152.
 */
package us.jakeabel.mpa.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.BasicDBList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import org.bson.Document;
import org.bson.types.ObjectId;
import us.jakeabel.mpa.core.MpaNested;
import us.jakeabel.mpa.core.MpaNestedList;
import us.jakeabel.mpa.example.TestCase;
import us.jakeabel.mpa.util.DateUtils;

public class MongoUtils<T> {
    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    public static <T> Document toDocument(T obj) {
        try {
            List<Field> fields = new ArrayList<Field>();
            fields = MongoUtils.getAllFields(fields, obj.getClass());
            Document doc = new Document();
            for (Field f : fields) {
                if (f.getName().equals("id")) {
                    f.setAccessible(true);
                    String id = (String)f.get(obj);
                    if (id == null) continue;
                    doc.append("_id", (Object)new ObjectId((String)f.get(obj)));
                    continue;
                }
                Annotation[] annotations = f.getAnnotations();
                if (annotations == null || annotations.length == 0) {
                    f.setAccessible(true);
                    doc.append(f.getName(), f.get(obj));
                    continue;
                }
                for (Annotation ann : annotations) {
                    if (ann instanceof MpaNested) {
                        f.setAccessible(true);
                        Document inner = MongoUtils.toDocument(f.get(obj));
                        doc.append(f.getName(), (Object)inner);
                        continue;
                    }
                    if (!(ann instanceof MpaNestedList)) continue;
                    f.setAccessible(true);
                    List list = (List)f.get(obj);
                    BasicDBList dbList = new BasicDBList();
                    for (Object o : list) {
                        Document inner = MongoUtils.toDocument(o);
                        dbList.add((Object)inner);
                    }
                    doc.append(f.getName(), (Object)dbList);
                }
            }
            return doc;
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            assert (false);
            return null;
        }
    }

    public static void main(String[] args) {
        TestCase testCase = new TestCase();
        testCase.setId(new ObjectId().toHexString());
        Document out = MongoUtils.toDocument(testCase);
        System.out.println("out.getObjectId(\"_id\") = " + out.getObjectId((Object)"_id"));
        boolean debug = false;
    }

    public static <T> T fromDocument(Document doc, Class<T> tClass) {
        List<Field> fields = new ArrayList<Field>();
        fields = MongoUtils.getAllFields(fields, tClass);
        try {
            T obj = tClass.newInstance();
            for (Field f : fields) {
                if (f.getName().equals("id") && doc.containsKey((Object)"_id")) {
                    f.setAccessible(true);
                    f.set(obj, doc.getObjectId((Object)"_id").toHexString());
                    continue;
                }
                if (!doc.containsKey((Object)f.getName())) continue;
                if (f.getType() == Date.class) {
                    Object dateObj = doc.get((Object)f.getName());
                    if (dateObj instanceof Date) {
                        f.setAccessible(true);
                        f.set(obj, doc.getDate((Object)f.getName()));
                        continue;
                    }
                    if (!(dateObj instanceof String)) continue;
                    f.setAccessible(true);
                    f.set(obj, DateUtils.parseDate((String)dateObj));
                    continue;
                }
                Annotation[] annotations = f.getAnnotations();
                if (annotations == null || annotations.length == 0) {
                    f.setAccessible(true);
                    f.set(obj, doc.get((Object)f.getName()));
                    continue;
                }
                for (Annotation ann : annotations) {
                    ArrayList<T> list;
                    Class listItemClass;
                    ParameterizedType genericType;
                    List dbList;
                    if (ann instanceof MpaNested) {
                        f.setAccessible(true);
                        f.set(obj, MongoUtils.fromDocument((Document)doc.get((Object)f.getName()), f.getType()));
                        continue;
                    }
                    if (!(ann instanceof MpaNestedList)) continue;
                    f.setAccessible(true);
                    if (doc.get((Object)f.getName()) instanceof List) {
                        dbList = (List)doc.get((Object)f.getName());
                        genericType = (ParameterizedType)f.getGenericType();
                        listItemClass = (Class)genericType.getActualTypeArguments()[0];
                        list = new ArrayList<T>();
                        for (Object arrDoc : dbList) {
                            list.add(MongoUtils.fromDocument((Document)arrDoc, listItemClass));
                        }
                        f.set(obj, list);
                        continue;
                    }
                    if (!(doc.get((Object)f.getName()) instanceof BasicDBList)) continue;
                    dbList = (BasicDBList)doc.get((Object)f.getName());
                    genericType = (ParameterizedType)f.getGenericType();
                    listItemClass = (Class)genericType.getActualTypeArguments()[0];
                    System.out.println(listItemClass);
                    list = new ArrayList();
                    for (Object arrDoc : dbList) {
                        list.add(MongoUtils.fromDocument((Document)arrDoc, listItemClass));
                    }
                    f.set(obj, list);
                }
            }
            return obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.removeIf(new Predicate<Field>(){

            @Override
            public boolean test(Field field) {
                return field.getName().equals("_id");
            }
        });
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = MongoUtils.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }
}

