/*
 * Decompiled with CFR 0.152.
 */
package alpine.common.util;

import java.util.List;

public class Pageable<T> {
    private final int pageSize;
    private final List<T> list;
    private final int totalPages;
    private int currentPage;
    private int startingIndex;
    private int endingIndex;

    public Pageable(int pageSize, List<T> list) {
        this.pageSize = pageSize;
        this.list = list;
        this.currentPage = 1;
        this.totalPages = pageSize > 0 ? (list.size() % pageSize == 0 ? list.size() / pageSize : list.size() / pageSize + 1) : 1;
        this.setCurrentPage(1);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<T> getList() {
        return this.list;
    }

    public List<T> getPaginatedList() {
        return this.list.subList(this.startingIndex, this.endingIndex);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public boolean hasMorePages() {
        return this.currentPage < this.totalPages;
    }

    public boolean isPaginationComplete() {
        return this.currentPage == -1;
    }

    public void nextPage() {
        if (this.hasMorePages()) {
            this.setCurrentPage(this.currentPage + 1);
        } else {
            this.currentPage = -1;
        }
    }

    private void setCurrentPage(int page) {
        this.currentPage = page >= this.totalPages ? this.totalPages : (page <= 1 ? 1 : page);
        this.startingIndex = this.pageSize * (this.currentPage - 1);
        if (this.startingIndex < 0) {
            this.startingIndex = 0;
        }
        this.endingIndex = this.startingIndex + this.pageSize;
        if (this.endingIndex > this.list.size()) {
            this.endingIndex = this.list.size();
        }
    }
}

