/*
 * Decompiled with CFR 0.152.
 */
package alpine;

import alpine.common.logging.Logger;
import alpine.common.util.ByteFormat;
import alpine.common.util.PathUtil;
import alpine.common.util.SystemUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class Config {
    private static final Logger LOGGER = Logger.getLogger(Config.class);
    private static final String ALPINE_APP_PROP = "alpine.application.properties";
    private static final String PROP_FILE = "application.properties";
    private static final String ALPINE_VERSION_PROP_FILE = "alpine.version";
    private static final String APPLICATION_VERSION_PROP_FILE = "application.version";
    private static final Config INSTANCE;
    private static Properties properties;
    private static Properties alpineVersionProperties;
    private static Properties applicationVersionProperties;
    private static String systemId;

    public static Config getInstance() {
        return INSTANCE;
    }

    void init() {
        File systemIdFile;
        InputStream in;
        if (properties != null) {
            return;
        }
        LOGGER.info("Initializing Configuration");
        properties = new Properties();
        String alpineAppProp = PathUtil.resolve(System.getProperty(ALPINE_APP_PROP));
        if (StringUtils.isNotBlank((CharSequence)alpineAppProp)) {
            LOGGER.info("Loading application properties from " + alpineAppProp);
            try (InputStream fileInputStream = Files.newInputStream(new File(alpineAppProp).toPath(), new OpenOption[0]);){
                properties.load(fileInputStream);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Could not find property file " + alpineAppProp);
            }
            catch (IOException e) {
                LOGGER.error("Unable to load " + alpineAppProp);
            }
        } else {
            LOGGER.info("System property alpine.application.properties not specified");
            LOGGER.info("Loading application.properties from classpath");
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROP_FILE);
                try {
                    if (in != null) {
                        properties.load(in);
                    } else {
                        LOGGER.error("Unable to load (resourceStream is null) application.properties");
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Unable to load application.properties");
            }
        }
        if (properties.size() == 0) {
            LOGGER.error("A fatal error occurred loading application properties. Please correct the issue and restart the application.");
        }
        alpineVersionProperties = new Properties();
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(ALPINE_VERSION_PROP_FILE);
            try {
                alpineVersionProperties.load(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to load alpine.version");
        }
        if (alpineVersionProperties.size() == 0) {
            LOGGER.error("A fatal error occurred loading Alpine version information. Please correct the issue and restart the application.");
        }
        applicationVersionProperties = new Properties();
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(APPLICATION_VERSION_PROP_FILE);
            try {
                if (in != null) {
                    applicationVersionProperties.load(in);
                } else {
                    LOGGER.error("Unable to load (resourceStream is null) application.version");
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to load application.version");
        }
        if (applicationVersionProperties.size() == 0) {
            LOGGER.error("A fatal error occurred loading application version information. Please correct the issue and restart the application.");
        }
        if (!(systemIdFile = this.getSystemIdFilePath()).exists()) {
            try (OutputStream fos = Files.newOutputStream(systemIdFile.toPath(), new OpenOption[0]);){
                fos.write(UUID.randomUUID().toString().getBytes());
            }
            catch (IOException e) {
                LOGGER.error("An error occurred writing to " + systemIdFile.getAbsolutePath(), e);
            }
        }
        try {
            systemId = new String(Files.readAllBytes(systemIdFile.toPath()));
        }
        catch (IOException e) {
            LOGGER.error("Unable to read the contents of " + systemIdFile.getAbsolutePath(), e);
        }
    }

    private File getSystemIdFilePath() {
        return new File(Config.getInstance().getDataDirectorty() + File.separator + "id.system");
    }

    public String getSystemUuid() {
        return systemId;
    }

    public String getFrameworkName() {
        return alpineVersionProperties.getProperty("name");
    }

    public String getFrameworkVersion() {
        return alpineVersionProperties.getProperty("version");
    }

    public String getFrameworkBuildTimestamp() {
        return alpineVersionProperties.getProperty("timestamp");
    }

    public String getFrameworkBuildUuid() {
        return alpineVersionProperties.getProperty("uuid");
    }

    public String getApplicationName() {
        return applicationVersionProperties.getProperty("name", "Unknown Alpine Application");
    }

    public String getApplicationVersion() {
        return applicationVersionProperties.getProperty("version", "0.0.0");
    }

    public String getApplicationBuildTimestamp() {
        return applicationVersionProperties.getProperty("timestamp", "1970-01-01 00:00:00");
    }

    public String getApplicationBuildUuid() {
        return applicationVersionProperties.getProperty("uuid");
    }

    public File getDataDirectorty() {
        String prop = PathUtil.resolve(this.getProperty(AlpineKey.DATA_DIRECTORY));
        return new File(prop).getAbsoluteFile();
    }

    public String getProperty(Key key) {
        String envVariable = this.getPropertyFromEnvironment(key);
        if (envVariable != null) {
            return envVariable;
        }
        if (key.getDefaultValue() == null) {
            return properties.getProperty(key.getPropertyName());
        }
        return properties.getProperty(key.getPropertyName(), String.valueOf(key.getDefaultValue()));
    }

    public String getPropertyOrFile(AlpineKey key) {
        AlpineKey fileKey = AlpineKey.valueOf(key.toString() + "_FILE");
        String filePath = this.getProperty(fileKey);
        String prop = this.getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            if (prop != null && !prop.equals(String.valueOf(key.getDefaultValue()))) {
                LOGGER.warn(fileKey.getPropertyName() + " overrides value from property " + key.getPropertyName());
            }
            try {
                return new String(Files.readAllBytes(new File(PathUtil.resolve(filePath)).toPath())).replaceAll("\\s+", "");
            }
            catch (IOException e) {
                LOGGER.error(filePath + " file doesn't exist or not readable.");
                return null;
            }
        }
        return prop;
    }

    public int getPropertyAsInt(Key key) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Error parsing number from property: " + key.getPropertyName());
            return -1;
        }
    }

    public long getPropertyAsLong(Key key) {
        try {
            return Long.parseLong(this.getProperty(key));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Error parsing number from property: " + key.getPropertyName());
            return -1L;
        }
    }

    public boolean getPropertyAsBoolean(Key key) {
        return "true".equalsIgnoreCase(this.getProperty(key));
    }

    public Map<String, String> getPassThroughProperties(String prefix) {
        String key;
        HashMap<String, String> passThroughProperties = new HashMap<String, String>();
        try {
            for (Map.Entry<String, String> envVar : System.getenv().entrySet()) {
                if (!envVar.getKey().startsWith("ALPINE_%s_".formatted(prefix.toUpperCase().replace(".", "_")))) continue;
                key = envVar.getKey().replaceFirst("^ALPINE_", "").toLowerCase().replace("_", ".");
                passThroughProperties.put(key, envVar.getValue());
            }
        }
        catch (SecurityException e) {
            LOGGER.warn("Unable to retrieve pass-through properties for prefix \"%s\" from environment variables. Using defaults.".formatted(prefix), e);
        }
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            Object object = property.getKey();
            if (!(object instanceof String) || !(key = (String)object).startsWith("alpine.%s.".formatted(prefix)) || !((object = property.getValue()) instanceof String)) continue;
            String value = (String)object;
            if (passThroughProperties.containsKey(key = key.replaceFirst("^alpine\\.", ""))) continue;
            passThroughProperties.put(key, value);
        }
        return passThroughProperties;
    }

    static void reset() {
        properties = null;
    }

    @Deprecated
    public String getProperty(String key) {
        return properties.getProperty(key);
    }

    @Deprecated
    public String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    private String getPropertyFromEnvironment(Key key) {
        String envVariable = key.getPropertyName().toUpperCase().replace(".", "_");
        try {
            return StringUtils.trimToNull((String)System.getenv(envVariable));
        }
        catch (SecurityException e) {
            LOGGER.warn("A security exception prevented access to the environment variable. Using defaults.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isUnitTestsEnabled() {
        return Boolean.valueOf(System.getProperty("alpine.unittests.enabled", "false"));
    }

    public static void enableUnitTests() {
        System.setProperty("alpine.unittests.enabled", "true");
    }

    static {
        LOGGER.info(StringUtils.repeat((String)"-", (int)80));
        LOGGER.info("OS Name:      " + SystemUtil.getOsName());
        LOGGER.info("OS Version:   " + SystemUtil.getOsVersion());
        LOGGER.info("OS Arch:      " + SystemUtil.getOsArchitecture());
        LOGGER.info("CPU Cores:    " + SystemUtil.getCpuCores());
        LOGGER.info("Max Memory:   " + new ByteFormat().minimumFractionDigits(1).format2(SystemUtil.getMaxMemory()));
        LOGGER.info("Java Vendor:  " + SystemUtil.getJavaVendor());
        LOGGER.info("Java Version: " + SystemUtil.getJavaVersion());
        LOGGER.info("Java Home:    " + SystemUtil.getJavaHome());
        LOGGER.info("Java Temp:    " + SystemUtil.getJavaTempDir());
        LOGGER.info("User:         " + SystemUtil.getUserName());
        LOGGER.info("User Home:    " + SystemUtil.getUserHome());
        LOGGER.info(StringUtils.repeat((String)"-", (int)80));
        INSTANCE = new Config();
        INSTANCE.init();
        LOGGER.info(StringUtils.repeat((String)"-", (int)80));
        LOGGER.info("Application:  " + INSTANCE.getApplicationName());
        LOGGER.info("Version:      " + INSTANCE.getApplicationVersion());
        LOGGER.info("Built-on:     " + INSTANCE.getApplicationBuildTimestamp());
        LOGGER.info(StringUtils.repeat((String)"-", (int)80));
        LOGGER.info("Framework:    " + INSTANCE.getFrameworkName());
        LOGGER.info("Version :     " + INSTANCE.getFrameworkVersion());
        LOGGER.info("Built-on:     " + INSTANCE.getFrameworkBuildTimestamp());
        LOGGER.info(StringUtils.repeat((String)"-", (int)80));
    }

    public static enum AlpineKey implements Key
    {
        WORKER_THREADS("alpine.worker.threads", 0),
        WORKER_THREAD_MULTIPLIER("alpine.worker.thread.multiplier", 4),
        DATA_DIRECTORY("alpine.data.directory", "~/.alpine"),
        SECRET_KEY_PATH("alpine.secret.key.path", null),
        PRIVATE_KEY_PATH("alpine.private.key.path", null),
        PUBLIC_KEY_PATH("alpine.public.key.path", null),
        DATABASE_MODE("alpine.database.mode", "embedded"),
        DATABASE_PORT("alpine.database.port", 9092),
        DATABASE_URL("alpine.database.url", "jdbc:h2:mem:alpine"),
        DATABASE_DRIVER("alpine.database.driver", "org.h2.Driver"),
        DATABASE_USERNAME("alpine.database.username", "sa"),
        DATABASE_PASSWORD("alpine.database.password", ""),
        DATABASE_PASSWORD_FILE("alpine.database.password.file", null),
        DATABASE_POOL_ENABLED("alpine.database.pool.enabled", true),
        DATABASE_POOL_MAX_SIZE("alpine.database.pool.max.size", 20),
        DATABASE_POOL_TX_MAX_SIZE("alpine.database.pool.tx.max.size", null),
        DATABASE_POOL_NONTX_MAX_SIZE("alpine.database.pool.nontx.max.size", null),
        DATABASE_POOL_IDLE_TIMEOUT("alpine.database.pool.idle.timeout", 300000),
        DATABASE_POOL_TX_IDLE_TIMEOUT("alpine.database.pool.tx.idle.timeout", null),
        DATABASE_POOL_NONTX_IDLE_TIMEOUT("alpine.database.pool.nontx.idle.timeout", null),
        DATABASE_POOL_MIN_IDLE("alpine.database.pool.min.idle", 10),
        DATABASE_POOL_TX_MIN_IDLE("alpine.database.pool.tx.min.idle", null),
        DATABASE_POOL_NONTX_MIN_IDLE("alpine.database.pool.nontx.min.idle", null),
        DATABASE_POOL_MAX_LIFETIME("alpine.database.pool.max.lifetime", 600000),
        DATABASE_POOL_TX_MAX_LIFETIME("alpine.database.pool.tx.max.lifetime", null),
        DATABASE_POOL_NONTX_MAX_LIFETIME("alpine.database.pool.nontx.max.lifetime", null),
        DATABASE_POOL_KEEPALIVE_INTERVAL("alpine.database.pool.keepalive.interval", 0),
        DATABASE_POOL_TX_KEEPALIVE_INTERVAL("alpine.database.pool.tx.keepalive.interval", null),
        DATABASE_POOL_NONTX_KEEPALIVE_INTERVAL("alpine.database.pool.nontx.keepalive.interval", null),
        ENFORCE_AUTHENTICATION("alpine.enforce.authentication", true),
        ENFORCE_AUTHORIZATION("alpine.enforce.authorization", true),
        BCRYPT_ROUNDS("alpine.bcrypt.rounds", 14),
        LDAP_ENABLED("alpine.ldap.enabled", false),
        LDAP_SERVER_URL("alpine.ldap.server.url", null),
        LDAP_BASEDN("alpine.ldap.basedn", null),
        LDAP_SECURITY_AUTH("alpine.ldap.security.auth", null),
        LDAP_BIND_USERNAME("alpine.ldap.bind.username", null),
        LDAP_BIND_PASSWORD("alpine.ldap.bind.password", null),
        LDAP_BIND_PASSWORD_FILE("alpine.ldap.bind.password.file", null),
        LDAP_AUTH_USERNAME_FMT("alpine.ldap.auth.username.format", null),
        LDAP_ATTRIBUTE_NAME("alpine.ldap.attribute.name", "userPrincipalName"),
        LDAP_ATTRIBUTE_MAIL("alpine.ldap.attribute.mail", "mail"),
        LDAP_GROUPS_FILTER("alpine.ldap.groups.filter", null),
        LDAP_USER_GROUPS_FILTER("alpine.ldap.user.groups.filter", null),
        LDAP_GROUPS_SEARCH_FILTER("alpine.ldap.groups.search.filter", null),
        LDAP_USERS_SEARCH_FILTER("alpine.ldap.users.search.filter", null),
        LDAP_USER_PROVISIONING("alpine.ldap.user.provisioning", false),
        LDAP_TEAM_SYNCHRONIZATION("alpine.ldap.team.synchronization", false),
        METRICS_ENABLED("alpine.metrics.enabled", false),
        METRICS_AUTH_USERNAME("alpine.metrics.auth.username", null),
        METRICS_AUTH_PASSWORD("alpine.metrics.auth.password", null),
        OIDC_ENABLED("alpine.oidc.enabled", false),
        OIDC_ISSUER("alpine.oidc.issuer", null),
        OIDC_CLIENT_ID("alpine.oidc.client.id", null),
        OIDC_USERNAME_CLAIM("alpine.oidc.username.claim", "sub"),
        OIDC_USER_PROVISIONING("alpine.oidc.user.provisioning", false),
        OIDC_TEAM_SYNCHRONIZATION("alpine.oidc.team.synchronization", false),
        OIDC_TEAMS_CLAIM("alpine.oidc.teams.claim", "groups"),
        HTTP_PROXY_ADDRESS("alpine.http.proxy.address", null),
        HTTP_PROXY_PORT("alpine.http.proxy.port", null),
        HTTP_PROXY_USERNAME("alpine.http.proxy.username", null),
        HTTP_PROXY_PASSWORD("alpine.http.proxy.password", null),
        HTTP_PROXY_PASSWORD_FILE("alpine.http.proxy.password.file", null),
        NO_PROXY("alpine.no.proxy", null),
        HTTP_TIMEOUT_CONNECTION("alpine.http.timeout.connection", 30),
        HTTP_TIMEOUT_POOL("alpine.http.timeout.pool", 60),
        HTTP_TIMEOUT_SOCKET("alpine.http.timeout.socket", 30),
        CORS_ENABLED("alpine.cors.enabled", true),
        CORS_ALLOW_ORIGIN("alpine.cors.allow.origin", "*"),
        CORS_ALLOW_METHODS("alpine.cors.allow.methods", "GET, POST, PUT, DELETE, OPTIONS"),
        CORS_ALLOW_HEADERS("alpine.cors.allow.headers", "Origin, Content-Type, Authorization, X-Requested-With, Content-Length, Accept, Origin, X-Api-Key, X-Total-Count, *"),
        CORS_EXPOSE_HEADERS("alpine.cors.expose.headers", "Origin, Content-Type, Authorization, X-Requested-With, Content-Length, Accept, Origin, X-Api-Key, X-Total-Count"),
        CORS_ALLOW_CREDENTIALS("alpine.cors.allow.credentials", true),
        CORS_MAX_AGE("alpine.cors.max.age", 3600),
        WATCHDOG_LOGGING_INTERVAL("alpine.watchdog.logging.interval", 0),
        API_KEY_PREFIX("alpine.api.key.prefix", "alpine_");

        private String propertyName;
        private Object defaultValue;

        private AlpineKey(String item, Object defaultValue) {
            this.propertyName = item;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static interface Key {
        public String getPropertyName();

        public Object getDefaultValue();
    }
}

