/*
 * Decompiled with CFR 0.152.
 */
package alpine.common.util;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.common.util.ProxyConfig;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class ProxyUtil {
    private static final Logger LOGGER = Logger.getLogger(ProxyUtil.class);

    private ProxyUtil() {
    }

    public static ProxyConfig getProxyConfig() {
        ProxyConfig proxyCfg = ProxyUtil.fromConfig(Config.getInstance());
        if (proxyCfg == null) {
            proxyCfg = ProxyUtil.fromEnvironment(System.getenv());
        }
        return proxyCfg;
    }

    static ProxyConfig fromConfig(Config config) {
        if (config == null) {
            return null;
        }
        String host = config.getProperty(Config.AlpineKey.HTTP_PROXY_ADDRESS);
        if (host == null) {
            return null;
        }
        int port = config.getPropertyAsInt(Config.AlpineKey.HTTP_PROXY_PORT);
        String username = config.getProperty(Config.AlpineKey.HTTP_PROXY_USERNAME);
        String password = config.getPropertyOrFile(Config.AlpineKey.HTTP_PROXY_PASSWORD);
        String noProxy = config.getProperty(Config.AlpineKey.NO_PROXY);
        ProxyConfig proxyCfg = new ProxyConfig();
        proxyCfg.setHost(host);
        if (port != -1) {
            proxyCfg.setPort(port);
        }
        if (username != null) {
            Pair<String, String> domainUsername = ProxyUtil.parseProxyUsername(username);
            Optional.ofNullable((String)domainUsername.getLeft()).ifPresent(proxyCfg::setDomain);
            Optional.ofNullable((String)domainUsername.getRight()).ifPresent(proxyCfg::setUsername);
        }
        if (password != null) {
            proxyCfg.setPassword(StringUtils.trimToNull((String)password));
        }
        if (noProxy != null) {
            proxyCfg.setNoProxy(Set.of(noProxy.split(",")));
        }
        return proxyCfg;
    }

    static ProxyConfig fromEnvironment(Map<String, String> env) {
        ProxyConfig proxyCfg = null;
        try {
            proxyCfg = ProxyUtil.buildFromEnvironment(env, "https_proxy");
            if (proxyCfg == null) {
                proxyCfg = ProxyUtil.buildFromEnvironment(env, "http_proxy");
            }
        }
        catch (UnsupportedEncodingException | SecurityException | MalformedURLException e) {
            LOGGER.warn("Could not parse proxy settings from environment", e);
        }
        if (proxyCfg != null) {
            for (Map.Entry<String, String> entry : env.entrySet()) {
                if (!"no_proxy".equalsIgnoreCase(entry.getKey().toUpperCase())) continue;
                proxyCfg.setNoProxy(Set.of(entry.getValue().split(",")));
                break;
            }
        }
        return proxyCfg;
    }

    private static ProxyConfig buildFromEnvironment(Map<String, String> env, String variable) throws MalformedURLException, UnsupportedEncodingException {
        if (env == null || variable == null) {
            return null;
        }
        String proxy = null;
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!variable.equalsIgnoreCase(entry.getKey().toUpperCase())) continue;
            proxy = entry.getValue();
            break;
        }
        if (proxy == null) {
            return null;
        }
        URL proxyUrl = new URL(proxy);
        ProxyConfig proxyCfg = new ProxyConfig();
        proxyCfg.setHost(proxyUrl.getHost());
        proxyCfg.setPort(proxyUrl.getPort());
        if (proxyUrl.getUserInfo() != null) {
            String[] credentials = proxyUrl.getUserInfo().split(":");
            if (credentials.length > 0) {
                String username = URLDecoder.decode(credentials[0], StandardCharsets.UTF_8);
                Pair<String, String> domainUsername = ProxyUtil.parseProxyUsername(username);
                Optional.ofNullable((String)domainUsername.getLeft()).ifPresent(proxyCfg::setDomain);
                Optional.ofNullable((String)domainUsername.getRight()).ifPresent(proxyCfg::setUsername);
            }
            if (credentials.length == 2) {
                proxyCfg.setPassword(URLDecoder.decode(credentials[1], StandardCharsets.UTF_8));
            }
        }
        return proxyCfg;
    }

    private static Pair<String, String> parseProxyUsername(String username) {
        if (username.contains("\\")) {
            return Pair.of((Object)username.substring(0, username.indexOf("\\")), (Object)username.substring(username.indexOf("\\") + 1));
        }
        return Pair.of(null, (Object)username);
    }
}

