/*
 * Decompiled with CFR 0.152.
 */
package alpine.common.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadPoolExecutor;

public final class ExecutorUtil {
    private ExecutorUtil() {
    }

    public static ExecutorStats getExecutorStats(ExecutorService executor) {
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpExecutor = (ThreadPoolExecutor)executor;
            return new ExecutorStats(tpExecutor.isTerminated(), tpExecutor.getQueue().size(), tpExecutor.getActiveCount());
        }
        if (executor instanceof ForkJoinPool) {
            ForkJoinPool fjpExecutor = (ForkJoinPool)executor;
            return new ExecutorStats(fjpExecutor.isTerminated(), fjpExecutor.getQueuedSubmissionCount(), fjpExecutor.getActiveThreadCount());
        }
        return new ExecutorStats(executor.isTerminated(), null, null);
    }

    public record ExecutorStats(boolean terminated, Integer queueSize, Integer activeThreads) {
    }
}

