/*
 * Decompiled with CFR 0.152.
 */
package alpine.common.util;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Set;

public final class ProxyConfig {
    private String host;
    private int port;
    private String domain;
    private String username;
    private String password;
    private Set<String> noProxy;

    public boolean shouldProxy(URL uri) {
        if (this.host == null || uri == null || !Set.of("http", "https").contains(uri.getProtocol())) {
            return false;
        }
        if (this.noProxy == null) {
            return true;
        }
        if (this.noProxy.contains("*")) {
            return false;
        }
        String hostname = uri.getHost();
        int hostPort = uri.getPort();
        for (String bypassURL : this.noProxy) {
            int bl;
            String[] bypassURLList = bypassURL.split(":");
            String byPassHost = bypassURLList[0];
            int byPassPort = -1;
            if (bypassURLList.length == 2) {
                byPassPort = Integer.parseInt(bypassURLList[1]);
            }
            if (hostPort != byPassPort && byPassPort != -1) continue;
            if (hostname.equalsIgnoreCase(byPassHost)) {
                return false;
            }
            int hl = hostname.length();
            if (hl <= (bl = byPassHost.length()) || !hostname.substring(hl - bl - 1).equalsIgnoreCase("." + byPassHost)) continue;
            return false;
        }
        return true;
    }

    public Proxy getProxy() {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.host, this.port));
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<String> getNoProxy() {
        return this.noProxy;
    }

    public void setNoProxy(Set<String> noProxy) {
        this.noProxy = noProxy;
    }
}

