/*
 * Decompiled with CFR 0.152.
 */
package alpine.embedded;

import alpine.embedded.CliArgs;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class EmbeddedJettyServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedJettyServer.class);

    private EmbeddedJettyServer() {
    }

    public static void main(String[] args) throws Exception {
        try (InputStream fis = Thread.currentThread().getContextClassLoader().getResourceAsStream("alpine-executable-war.version");){
            Properties properties = new Properties();
            properties.load(fis);
            LOGGER.info(properties.getProperty("name") + " v" + properties.getProperty("version") + " (" + properties.getProperty("uuid") + ") built on: " + properties.getProperty("timestamp"));
        }
        CliArgs cliArgs = new CliArgs(args);
        String contextPath = cliArgs.switchValue("-context", "/");
        String host = cliArgs.switchValue("-host", "0.0.0.0");
        int port = cliArgs.switchIntegerValue("-port", 8080);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.addCustomizer(new ForwardedRequestCustomizer());
        HttpConnectionFactory connectionFactory = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(server, connectionFactory);
        connector.setHost(host);
        connector.setPort(port);
        EmbeddedJettyServer.disableServerVersionHeader(connector);
        server.setConnectors(new Connector[]{connector});
        WebAppContext context = new WebAppContext();
        context.setServer(server);
        context.setContextPath(contextPath);
        context.setErrorHandler(new ErrorHandler());
        context.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        context.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", ".*/[^/]*taglibs.*\\.jar$");
        context.getSystemClassMatcher().add("org.apache.log4j.");
        context.getSystemClassMatcher().add("org.slf4j.");
        context.getSystemClassMatcher().add("org.apache.commons.logging.");
        ProtectionDomain protectionDomain = EmbeddedJettyServer.class.getProtectionDomain();
        URL location = protectionDomain.getCodeSource().getLocation();
        context.setWar(location.toExternalForm());
        server.setHandler(context);
        server.addBean(new ErrorHandler());
        try {
            server.start();
            EmbeddedJettyServer.addJettyShutdownHook(server);
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void disableServerVersionHeader(Connector connector) {
        connector.getConnectionFactories().stream().filter(cf -> cf instanceof HttpConnectionFactory).forEach(cf -> ((HttpConnectionFactory)cf).getHttpConfiguration().setSendServerVersion(false));
    }

    private static void addJettyShutdownHook(final Server server) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("Shutting down application");
                    server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private static class ErrorHandler
    extends ErrorPageErrorHandler {
        private ErrorHandler() {
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setStatus(response.getStatus());
        }
    }
}

