/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.providers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Abstract Provider for loading webapps")
public abstract class ScanningAppProvider
extends ContainerLifeCycle
implements AppProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ScanningAppProvider.class);
    private final Map<String, App> _appMap = new HashMap<String, App>();
    private DeploymentManager _deploymentManager;
    private FilenameFilter _filenameFilter;
    private final List<Resource> _monitored = new CopyOnWriteArrayList<Resource>();
    private int _scanInterval = 10;
    private Scanner _scanner;
    private boolean _useRealPaths;
    private boolean _deferInitialScan = false;
    private final Scanner.DiscreteListener _scannerListener = new Scanner.DiscreteListener(){

        @Override
        public void fileAdded(String filename) throws Exception {
            ScanningAppProvider.this.fileAdded(filename);
        }

        @Override
        public void fileChanged(String filename) throws Exception {
            ScanningAppProvider.this.fileChanged(filename);
        }

        @Override
        public void fileRemoved(String filename) throws Exception {
            ScanningAppProvider.this.fileRemoved(filename);
        }
    };

    protected ScanningAppProvider() {
        this(null);
    }

    protected ScanningAppProvider(FilenameFilter filter) {
        this._filenameFilter = filter;
        this.addBean(this._appMap);
    }

    public boolean isUseRealPaths() {
        return this._useRealPaths;
    }

    public void setUseRealPaths(boolean useRealPaths) {
        this._useRealPaths = useRealPaths;
    }

    protected void setFilenameFilter(FilenameFilter filter) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._filenameFilter = filter;
    }

    protected Map<String, App> getDeployedApps() {
        return this._appMap;
    }

    protected App createApp(String filename) {
        return new App(this._deploymentManager, this, filename);
    }

    @Override
    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.doStart()", (Object)this.getClass().getSimpleName());
        }
        if (this._monitored.size() == 0) {
            throw new IllegalStateException("No configuration dir specified");
        }
        LOG.info("Deployment monitor {}", (Object)this._monitored);
        ArrayList<File> files = new ArrayList<File>();
        for (Resource resource : this._monitored) {
            if (resource.exists() && resource.getFile().canRead()) {
                files.add(resource.getFile());
                continue;
            }
            LOG.warn("Does not exist: {}", (Object)resource);
        }
        this._scanner = new Scanner(null, this._useRealPaths);
        this._scanner.setScanDirs(files);
        this._scanner.setScanInterval(this._scanInterval);
        this._scanner.setFilenameFilter(this._filenameFilter);
        this._scanner.setReportDirs(true);
        this._scanner.setScanDepth(1);
        this._scanner.addListener(this._scannerListener);
        this._scanner.setReportExistingFilesOnStartup(true);
        this._scanner.setAutoStartScanning(!this._deferInitialScan);
        this.addBean(this._scanner);
        if (this.isDeferInitialScan()) {
            this.getDeploymentManager().getServer().addEventListener(new LifeCycle.Listener(){

                @Override
                public void lifeCycleStarted(LifeCycle event) {
                    if (event instanceof Server) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Triggering Deferred Scan of {}", (Object)ScanningAppProvider.this._monitored);
                        }
                        ScanningAppProvider.this._scanner.startScanning();
                    }
                }
            });
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this._scanner != null) {
            this.removeBean(this._scanner);
            this._scanner.removeListener(this._scannerListener);
            this._scanner = null;
        }
    }

    protected boolean exists(String path) {
        return this._scanner.exists(path);
    }

    protected void fileAdded(String filename) throws Exception {
        App app;
        if (LOG.isDebugEnabled()) {
            LOG.debug("added {}", (Object)filename);
        }
        if ((app = this.createApp(filename)) != null) {
            this._appMap.put(filename, app);
            this._deploymentManager.addApp(app);
        }
    }

    protected void fileChanged(String filename) throws Exception {
        App app;
        if (LOG.isDebugEnabled()) {
            LOG.debug("changed {}", (Object)filename);
        }
        if ((app = this._appMap.remove(filename)) != null) {
            this._deploymentManager.removeApp(app);
        }
        if ((app = this.createApp(filename)) != null) {
            this._appMap.put(filename, app);
            this._deploymentManager.addApp(app);
        }
    }

    protected void fileRemoved(String filename) throws Exception {
        App app;
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed {}", (Object)filename);
        }
        if ((app = this._appMap.remove(filename)) != null) {
            this._deploymentManager.removeApp(app);
        }
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public Resource getMonitoredDirResource() {
        if (this._monitored.size() == 0) {
            return null;
        }
        if (this._monitored.size() > 1) {
            throw new IllegalStateException();
        }
        return this._monitored.get(0);
    }

    public String getMonitoredDirName() {
        Resource resource = this.getMonitoredDirResource();
        return resource == null ? null : resource.toString();
    }

    @ManagedAttribute(value="scanning interval to detect changes which need reloaded")
    public int getScanInterval() {
        return this._scanInterval;
    }

    @Override
    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public void setMonitoredResources(List<Resource> resources) {
        this._monitored.clear();
        this._monitored.addAll(resources);
    }

    public List<Resource> getMonitoredResources() {
        return Collections.unmodifiableList(this._monitored);
    }

    public void setMonitoredDirResource(Resource resource) {
        this.setMonitoredResources(Collections.singletonList(resource));
    }

    public void addScannerListener(Scanner.Listener listener) {
        this._scanner.addListener(listener);
    }

    public void setMonitoredDirName(String dir) {
        this.setMonitoredDirectories(Collections.singletonList(dir));
    }

    public void setMonitoredDirectories(Collection<String> directories) {
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String dir : directories) {
                resources.add(Resource.newResource(dir));
            }
            this.setMonitoredResources(resources);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isDeferInitialScan() {
        return this._deferInitialScan;
    }

    public void setDeferInitialScan(boolean defer) {
        this._deferInitialScan = defer;
    }

    public void setScanInterval(int scanInterval) {
        this._scanInterval = scanInterval;
    }

    @ManagedOperation(value="Scan the monitored directories", impact="ACTION")
    public void scan() {
        LOG.info("Performing scan of monitored directories: {}", (Object)this.getMonitoredResources().stream().map(r -> r.getURI().toASCIIString()).collect(Collectors.joining(", ", "[", "]")));
        this._scanner.nudge();
    }

    @Override
    public String toString() {
        return String.format("%s@%x%s", this.getClass(), this.hashCode(), this._monitored);
    }
}

