/*
 * Decompiled with CFR 0.152.
 */
package alpine.embedded;

import alpine.embedded.CliArgs;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Properties;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResourceFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class EmbeddedJettyServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedJettyServer.class);

    private EmbeddedJettyServer() {
    }

    public static void main(String[] args) throws Exception {
        try (InputStream fis = Thread.currentThread().getContextClassLoader().getResourceAsStream("alpine-executable-war.version");){
            Properties properties = new Properties();
            properties.load(fis);
            LOGGER.info(properties.getProperty("name") + " v" + properties.getProperty("version") + " (" + properties.getProperty("uuid") + ") built on: " + properties.getProperty("timestamp"));
        }
        CliArgs cliArgs = new CliArgs(args);
        String contextPath = cliArgs.switchValue("-context", "/");
        String host = cliArgs.switchValue("-host", "0.0.0.0");
        int port = cliArgs.switchIntegerValue("-port", 8080);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.addCustomizer(new ForwardedRequestCustomizer());
        httpConfig.setUriCompliance(UriCompliance.LEGACY);
        HttpConnectionFactory connectionFactory = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(server, connectionFactory);
        connector.setHost(host);
        connector.setPort(port);
        EmbeddedJettyServer.disableServerVersionHeader(connector);
        server.setConnectors(new Connector[]{connector});
        WebAppContext context = new WebAppContext();
        context.setServer(server);
        context.setContextPath(contextPath);
        context.setErrorHandler(new ErrorHandler());
        context.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        context.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", ".*/[^/]*taglibs.*\\.jar$");
        context.getProtectedClassMatcher().add("org.apache.log4j.");
        context.getProtectedClassMatcher().add("org.slf4j.");
        context.getProtectedClassMatcher().add("org.apache.commons.logging.");
        ProtectionDomain protectionDomain = EmbeddedJettyServer.class.getProtectionDomain();
        URL location = protectionDomain.getCodeSource().getLocation();
        context.setWar(location.toExternalForm());
        URL jettyContextUrl = Thread.currentThread().getContextClassLoader().getResource("WEB-INF/jetty-context.xml");
        if (jettyContextUrl != null) {
            LOGGER.debug("Applying Jetty customization from {}", (Object)jettyContextUrl);
            Resource jettyContextResource = new URLResourceFactory().newResource(jettyContextUrl);
            XmlConfiguration xmlConfiguration = new XmlConfiguration(jettyContextResource);
            xmlConfiguration.configure(context);
        }
        server.setHandler(context);
        server.addBean(new ErrorHandler());
        try {
            server.start();
            for (ServletHandler handler : server.getContainedBeans(ServletHandler.class)) {
                LOGGER.debug("Enabling decoding of ambiguous URIs for servlet handler: {}", (Object)handler.getClass().getName());
                handler.setDecodeAmbiguousURIs(true);
            }
            EmbeddedJettyServer.addJettyShutdownHook(server);
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void disableServerVersionHeader(Connector connector) {
        connector.getConnectionFactories().stream().filter(cf -> cf instanceof HttpConnectionFactory).forEach(cf -> ((HttpConnectionFactory)cf).getHttpConfiguration().setSendServerVersion(false));
    }

    private static void addJettyShutdownHook(final Server server) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("Shutting down application");
                    server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private static class ErrorHandler
    extends ErrorPageErrorHandler {
        private ErrorHandler() {
        }

        @Override
        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            response.setStatus(response.getStatus());
            callback.succeeded();
            return true;
        }
    }
}

