/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.FileID;

public class App {
    private final DeploymentManager _manager;
    private final AppProvider _provider;
    private final Path _path;
    private final Map<String, String> _properties;
    private ContextHandler _context;

    public App(DeploymentManager manager, AppProvider provider, Path path) {
        block8: {
            this._properties = new HashMap<String, String>();
            this._manager = manager;
            this._provider = provider;
            this._path = path;
            try {
                String basename = FileID.getBasename(path);
                Path properties = path.getParent().resolve(basename + ".properties");
                if (!Files.exists(properties, new LinkOption[0])) break block8;
                try (InputStream stream = Files.newInputStream(properties, new OpenOption[0]);){
                    Properties p = new Properties();
                    p.load(stream);
                    p.stringPropertyNames().forEach(k -> this._properties.put((String)k, p.getProperty((String)k)));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public DeploymentManager getDeploymentManager() {
        return this._manager;
    }

    public AppProvider getAppProvider() {
        return this._provider;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public ContextHandler getContextHandler() throws Exception {
        if (this._context == null) {
            this._context = this.getAppProvider().createContextHandler(this);
        }
        return this._context;
    }

    public String getContextPath() {
        return this._context == null ? null : this._context.getContextPath();
    }

    public String getEnvironmentName() {
        return this.getProperties().get("environment");
    }

    public Path getPath() {
        return this._path;
    }

    public String toString() {
        return "App@%x[%s,%s,%s]".formatted(this.hashCode(), this.getEnvironmentName(), this._context, this._path);
    }
}

