/*
 * Decompiled with CFR 0.152.
 */
package alpine.event.framework;

import alpine.common.logging.Logger;
import alpine.common.metrics.Metrics;
import alpine.event.framework.ChainLink;
import alpine.event.framework.ChainableEvent;
import alpine.event.framework.Event;
import alpine.event.framework.IEventService;
import alpine.event.framework.LoggableUncaughtExceptionHandler;
import alpine.event.framework.SingletonCapableEvent;
import alpine.event.framework.Subscriber;
import alpine.event.framework.UnblockedEvent;
import alpine.model.EventServiceLog;
import alpine.persistence.AlpineQueryManager;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public abstract class BaseEventService
implements IEventService {
    private Logger logger = Logger.getLogger(BaseEventService.class);
    private final Map<Class<? extends Event>, ArrayList<Class<? extends Subscriber>>> subscriptionMap = new ConcurrentHashMap<Class<? extends Event>, ArrayList<Class<? extends Subscriber>>>();
    private final Map<UUID, ArrayList<UUID>> chainTracker = new ConcurrentHashMap<UUID, ArrayList<UUID>>();
    private ExecutorService executor = Executors.newFixedThreadPool(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("Alpine-BaseEventService-%d").uncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggableUncaughtExceptionHandler()).build());
    private final ExecutorService dynamicExecutor = Executors.newWorkStealingPool();

    protected void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    protected void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void publish(Event event) {
        this.logger.debug("Dispatching event: " + event.getClass().toString());
        ArrayList<Class<? extends Subscriber>> subscriberClasses = this.subscriptionMap.get(event.getClass());
        if (subscriberClasses == null) {
            this.logger.debug("No subscribers to inform from event: " + event.getClass().getName());
            return;
        }
        for (Class<? extends Subscriber> clazz : subscriberClasses) {
            this.logger.debug("Alerting subscriber " + clazz.getName());
            if (event instanceof ChainableEvent && !this.addTrackedEvent((ChainableEvent)event)) {
                return;
            }
            ExecutorService executorService = event instanceof UnblockedEvent ? this.dynamicExecutor : this.executor;
            executorService.execute(() -> {
                block14: {
                    try (AlpineQueryManager qm = new AlpineQueryManager();){
                        EventServiceLog eventServiceLog = qm.createEventServiceLog(clazz);
                        Subscriber subscriber = (Subscriber)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        subscriber.inform(event);
                        qm.updateEventServiceLog(eventServiceLog);
                        if (!(event instanceof ChainableEvent)) break block14;
                        ChainableEvent chainableEvent = (ChainableEvent)event;
                        this.logger.debug("Calling onSuccess");
                        for (ChainLink chainLink : chainableEvent.onSuccess()) {
                            if (chainLink.getSuccessEventService() != null) {
                                Method method = chainLink.getSuccessEventService().getMethod("getInstance", new Class[0]);
                                IEventService es = (IEventService)method.invoke(chainLink.getSuccessEventService(), new Object[0]);
                                es.publish(chainLink.getSuccessEvent());
                                continue;
                            }
                            Event.dispatch(chainLink.getSuccessEvent());
                        }
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        this.logger.error("An error occurred while informing subscriber: " + e);
                        if (!(event instanceof ChainableEvent)) break block14;
                        ChainableEvent chainableEvent = (ChainableEvent)event;
                        this.logger.debug("Calling onFailure");
                        for (ChainLink chainLink : chainableEvent.onFailure()) {
                            if (chainLink.getFailureEventService() != null) {
                                try {
                                    Method method = chainLink.getFailureEventService().getMethod("getInstance", new Class[0]);
                                    IEventService es = (IEventService)method.invoke(chainLink.getFailureEventService(), new Object[0]);
                                    es.publish(chainLink.getFailureEvent());
                                }
                                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                                    this.logger.error("Exception while calling onFailure callback", (Throwable)ex);
                                }
                                continue;
                            }
                            Event.dispatch(chainLink.getFailureEvent());
                        }
                    }
                }
                if (event instanceof ChainableEvent) {
                    this.removeTrackedEvent((ChainableEvent)event);
                }
            });
        }
        this.recordPublishedMetric(event);
    }

    @Override
    public synchronized boolean isEventBeingProcessed(ChainableEvent event) {
        return this.isEventBeingProcessed(event.getChainIdentifier());
    }

    @Override
    public synchronized boolean isEventBeingProcessed(UUID chainIdentifier) {
        ArrayList<UUID> eventIdentifiers = this.chainTracker.get(chainIdentifier);
        return eventIdentifiers != null && eventIdentifiers.size() != 0;
    }

    private synchronized boolean addTrackedEvent(ChainableEvent event) {
        SingletonCapableEvent sEvent;
        ArrayList<UUID> eventIdentifiers = this.chainTracker.get(event.getChainIdentifier());
        if (eventIdentifiers == null) {
            eventIdentifiers = new ArrayList();
        }
        if (event instanceof SingletonCapableEvent && (sEvent = (SingletonCapableEvent)event).isSingleton() && !eventIdentifiers.isEmpty()) {
            this.logger.info("An singleton event (" + sEvent.getClass().getSimpleName() + ") was received but another singleton event of the same type is already in progress. Skipping.");
            return false;
        }
        eventIdentifiers.add(event.getEventIdentifier());
        this.chainTracker.put(event.getChainIdentifier(), eventIdentifiers);
        return true;
    }

    private synchronized void removeTrackedEvent(ChainableEvent event) {
        ArrayList<UUID> eventIdentifiers = this.chainTracker.get(event.getChainIdentifier());
        if (eventIdentifiers == null) {
            return;
        }
        eventIdentifiers.remove(event.getEventIdentifier());
        if (eventIdentifiers.isEmpty()) {
            this.chainTracker.remove(event.getChainIdentifier());
        }
    }

    private void recordPublishedMetric(Event event) {
        Counter.builder((String)"alpine_events_published_total").description("Total number of published events").tags(new String[]{"event", event.getClass().getName(), "publisher", this.getClass().getName()}).register((MeterRegistry)Metrics.getRegistry()).increment();
    }

    @Override
    public void subscribe(Class<? extends Event> eventType, Class<? extends Subscriber> subscriberType) {
        ArrayList<Class<? extends Subscriber>> subscribers;
        if (!this.subscriptionMap.containsKey(eventType)) {
            this.subscriptionMap.put(eventType, new ArrayList());
        }
        if (!(subscribers = this.subscriptionMap.get(eventType)).contains(subscriberType)) {
            subscribers.add(subscriberType);
        }
    }

    @Override
    public void unsubscribe(Class<? extends Subscriber> subscriberType) {
        for (ArrayList<Class<? extends Subscriber>> list : this.subscriptionMap.values()) {
            list.remove(subscriberType);
        }
    }

    @Override
    public boolean hasSubscriptions(Event event) {
        ArrayList<Class<? extends Subscriber>> subscriberClasses = this.subscriptionMap.get(event.getClass());
        return subscriberClasses != null;
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down EventService");
        this.executor.shutdown();
        this.dynamicExecutor.shutdown();
    }
}

