/*
 * Decompiled with CFR 0.152.
 */
package alpine.persistence;

import alpine.common.logging.Logger;
import alpine.event.LdapSyncEvent;
import alpine.event.framework.EventService;
import alpine.event.framework.LoggableSubscriber;
import alpine.event.framework.Subscriber;
import alpine.model.ApiKey;
import alpine.model.ConfigProperty;
import alpine.model.EventServiceLog;
import alpine.model.IConfigProperty;
import alpine.model.LdapUser;
import alpine.model.ManagedUser;
import alpine.model.MappedLdapGroup;
import alpine.model.MappedOidcGroup;
import alpine.model.OidcGroup;
import alpine.model.OidcUser;
import alpine.model.Permission;
import alpine.model.Team;
import alpine.model.UserPrincipal;
import alpine.persistence.AbstractAlpineQueryManager;
import alpine.resources.AlpineRequest;
import alpine.security.ApiKeyGenerator;
import io.jsonwebtoken.lang.Collections;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class AlpineQueryManager
extends AbstractAlpineQueryManager {
    private static final Logger LOGGER = Logger.getLogger(AlpineQueryManager.class);

    public AlpineQueryManager() {
    }

    public AlpineQueryManager(PersistenceManager pm) {
        super(pm);
    }

    public AlpineQueryManager(AlpineRequest request) {
        super(request);
    }

    public AlpineQueryManager(PersistenceManager pm, AlpineRequest request) {
        super(pm, request);
    }

    public ApiKey getApiKey(String key) {
        Query query = this.pm.newQuery(ApiKey.class, "key == :key");
        List result = (List)query.execute((Object)key);
        return Collections.isEmpty((Collection)result) ? null : (ApiKey)result.get(0);
    }

    public ApiKey regenerateApiKey(ApiKey apiKey) {
        this.pm.currentTransaction().begin();
        apiKey.setKey(ApiKeyGenerator.generate());
        this.pm.currentTransaction().commit();
        return (ApiKey)this.pm.getObjectById(ApiKey.class, (Object)apiKey.getId());
    }

    public ApiKey createApiKey(Team team) {
        ArrayList<Team> teams = new ArrayList<Team>();
        teams.add(team);
        this.pm.currentTransaction().begin();
        ApiKey apiKey = new ApiKey();
        apiKey.setKey(ApiKeyGenerator.generate());
        apiKey.setTeams(teams);
        this.pm.makePersistent((Object)apiKey);
        this.pm.currentTransaction().commit();
        return (ApiKey)this.pm.getObjectById(ApiKey.class, (Object)apiKey.getId());
    }

    public OidcUser createOidcUser(String username) {
        this.pm.currentTransaction().begin();
        OidcUser user = new OidcUser();
        user.setUsername(username);
        this.pm.makePersistent((Object)user);
        this.pm.currentTransaction().commit();
        return this.getObjectById(OidcUser.class, user.getId());
    }

    public OidcUser updateOidcUser(OidcUser transientUser) {
        OidcUser user = this.getObjectById(OidcUser.class, transientUser.getId());
        this.pm.currentTransaction().begin();
        user.setSubjectIdentifier(transientUser.getSubjectIdentifier());
        user.setEmail(transientUser.getEmail());
        this.pm.currentTransaction().commit();
        return (OidcUser)this.pm.getObjectById(OidcUser.class, (Object)user.getId());
    }

    public OidcUser getOidcUser(String username) {
        Query query = this.pm.newQuery(OidcUser.class, "username == :username");
        List result = (List)query.execute((Object)username);
        return Collections.isEmpty((Collection)result) ? null : (OidcUser)result.get(0);
    }

    public List<OidcUser> getOidcUsers() {
        Query query = this.pm.newQuery(OidcUser.class);
        query.setOrdering("username asc");
        return (List)query.execute();
    }

    public OidcGroup createOidcGroup(String name) {
        this.pm.currentTransaction().begin();
        OidcGroup group = new OidcGroup();
        group.setName(name);
        this.pm.makePersistent((Object)group);
        this.pm.currentTransaction().commit();
        return this.getObjectByUuid(OidcGroup.class, group.getUuid());
    }

    public OidcGroup updateOidcGroup(OidcGroup oidcGroup) {
        OidcGroup oidcGroupToUpdate = this.getObjectByUuid(OidcGroup.class, oidcGroup.getUuid());
        this.pm.currentTransaction().begin();
        oidcGroupToUpdate.setName(oidcGroup.getName());
        this.pm.currentTransaction().commit();
        return (OidcGroup)this.pm.getObjectById(OidcGroup.class, (Object)oidcGroupToUpdate.getId());
    }

    public List<OidcGroup> getOidcGroups() {
        Query query = this.pm.newQuery(OidcGroup.class);
        query.setOrdering("name asc");
        return (List)query.execute();
    }

    public OidcGroup getOidcGroup(String name) {
        Query query = this.pm.newQuery(OidcGroup.class, "name == :name");
        List result = (List)query.execute((Object)name);
        return Collections.isEmpty((Collection)result) ? null : (OidcGroup)result.get(0);
    }

    public OidcUser synchronizeTeamMembership(OidcUser user, List<String> groupNames) {
        LOGGER.debug("Synchronizing team membership for OpenID Connect user " + user.getUsername());
        ArrayList<Team> removeThese = new ArrayList<Team>();
        if (user.getTeams() != null) {
            for (Team team : user.getTeams()) {
                LOGGER.debug(user.getUsername() + " is a member of team: " + team.getName());
                if (team.getMappedOidcGroups() != null && !team.getMappedOidcGroups().isEmpty()) {
                    for (MappedOidcGroup mappedOidcGroup : team.getMappedOidcGroups()) {
                        LOGGER.debug(mappedOidcGroup.getGroup().getName() + " is mapped to team: " + team.getName());
                        if (groupNames.contains(mappedOidcGroup.getGroup().getName())) continue;
                        LOGGER.debug(mappedOidcGroup.getGroup().getName() + " is not identified in the List of groups specified. Queuing removal of membership for user " + user.getUsername());
                        removeThese.add(team);
                    }
                    continue;
                }
                LOGGER.debug(team.getName() + " does not have any mapped OpenID Connect groups. Queuing removal of " + user.getUsername() + " from team: " + team.getName());
                removeThese.add(team);
            }
        }
        for (Team team : removeThese) {
            LOGGER.debug("Removing user: " + user.getUsername() + " from team: " + team.getName());
            this.removeUserFromTeam((UserPrincipal)user, team);
        }
        for (String groupName : groupNames) {
            OidcGroup group = this.getOidcGroup(groupName);
            if (group == null) {
                LOGGER.debug("Unknown OpenID Connect group " + groupName);
                continue;
            }
            for (MappedOidcGroup mappedOidcGroup : this.getMappedOidcGroups(group)) {
                LOGGER.debug("Adding user: " + user.getUsername() + " to team: " + mappedOidcGroup.getTeam().getName());
                this.addUserToTeam((UserPrincipal)user, mappedOidcGroup.getTeam());
            }
        }
        return this.getObjectById(OidcUser.class, user.getId());
    }

    public LdapUser getLdapUser(String username) {
        Query query = this.pm.newQuery(LdapUser.class, "username == :username");
        List result = (List)query.execute((Object)username);
        return Collections.isEmpty((Collection)result) ? null : (LdapUser)result.get(0);
    }

    public List<LdapUser> getLdapUsers() {
        Query query = this.pm.newQuery(LdapUser.class);
        query.setOrdering("username asc");
        return (List)query.execute();
    }

    public LdapUser createLdapUser(String username) {
        this.pm.currentTransaction().begin();
        LdapUser user = new LdapUser();
        user.setUsername(username);
        user.setDN("Syncing...");
        this.pm.makePersistent((Object)user);
        this.pm.currentTransaction().commit();
        EventService.getInstance().publish(new LdapSyncEvent(user.getUsername()));
        return this.getObjectById(LdapUser.class, user.getId());
    }

    public LdapUser updateLdapUser(LdapUser transientUser) {
        LdapUser user = this.getObjectById(LdapUser.class, transientUser.getId());
        this.pm.currentTransaction().begin();
        user.setDN(transientUser.getDN());
        this.pm.currentTransaction().commit();
        return (LdapUser)this.pm.getObjectById(LdapUser.class, (Object)user.getId());
    }

    public LdapUser synchronizeTeamMembership(LdapUser user, List<String> groupDNs) {
        LOGGER.debug("Synchronizing team membership for " + user.getUsername());
        ArrayList<Team> removeThese = new ArrayList<Team>();
        if (user.getTeams() != null) {
            for (Team team : user.getTeams()) {
                LOGGER.debug(user.getUsername() + " is a member of team: " + team.getName());
                if (team.getMappedLdapGroups() != null) {
                    for (MappedLdapGroup mappedLdapGroup : team.getMappedLdapGroups()) {
                        LOGGER.debug(mappedLdapGroup.getDn() + " is mapped to team: " + team.getName());
                        if (groupDNs.contains(mappedLdapGroup.getDn())) continue;
                        LOGGER.debug(mappedLdapGroup.getDn() + " is not identified in the List of group DNs specified. Queuing removal of membership for user " + user.getUsername());
                        removeThese.add(team);
                    }
                    continue;
                }
                LOGGER.debug(team.getName() + " does not have any mapped LDAP groups. Queuing removal of " + user.getUsername() + " from team: " + team.getName());
                removeThese.add(team);
            }
        }
        for (Team team : removeThese) {
            LOGGER.debug("Removing user: " + user.getUsername() + " from team: " + team.getName());
            this.removeUserFromTeam((UserPrincipal)user, team);
        }
        for (String groupDN : groupDNs) {
            for (MappedLdapGroup mappedLdapGroup : this.getMappedLdapGroups(groupDN)) {
                LOGGER.debug("Adding user: " + user.getUsername() + " to team: " + mappedLdapGroup.getTeam());
                this.addUserToTeam((UserPrincipal)user, mappedLdapGroup.getTeam());
            }
        }
        return this.getObjectById(LdapUser.class, user.getId());
    }

    public ManagedUser createManagedUser(String username, String passwordHash) {
        return this.createManagedUser(username, null, null, passwordHash, false, false, false);
    }

    public ManagedUser createManagedUser(String username, String fullname, String email, String passwordHash, boolean forcePasswordChange, boolean nonExpiryPassword, boolean suspended) {
        this.pm.currentTransaction().begin();
        ManagedUser user = new ManagedUser();
        user.setUsername(username);
        user.setFullname(fullname);
        user.setEmail(email);
        user.setPassword(passwordHash);
        user.setForcePasswordChange(forcePasswordChange);
        user.setNonExpiryPassword(nonExpiryPassword);
        user.setSuspended(suspended);
        user.setLastPasswordChange(new Date());
        this.pm.makePersistent((Object)user);
        this.pm.currentTransaction().commit();
        return this.getObjectById(ManagedUser.class, user.getId());
    }

    public ManagedUser updateManagedUser(ManagedUser transientUser) {
        ManagedUser user = this.getObjectById(ManagedUser.class, transientUser.getId());
        this.pm.currentTransaction().begin();
        user.setFullname(transientUser.getFullname());
        user.setEmail(transientUser.getEmail());
        user.setForcePasswordChange(transientUser.isForcePasswordChange());
        user.setNonExpiryPassword(transientUser.isNonExpiryPassword());
        user.setSuspended(transientUser.isSuspended());
        if (transientUser.getPassword() != null) {
            if (!user.getPassword().equals(transientUser.getPassword())) {
                user.setLastPasswordChange(new Date());
            }
            user.setPassword(transientUser.getPassword());
        }
        this.pm.currentTransaction().commit();
        return (ManagedUser)this.pm.getObjectById(ManagedUser.class, (Object)user.getId());
    }

    public ManagedUser getManagedUser(String username) {
        Query query = this.pm.newQuery(ManagedUser.class, "username == :username");
        List result = (List)query.execute((Object)username);
        return Collections.isEmpty((Collection)result) ? null : (ManagedUser)result.get(0);
    }

    public List<ManagedUser> getManagedUsers() {
        Query query = this.pm.newQuery(ManagedUser.class);
        query.setOrdering("username asc");
        return (List)query.execute();
    }

    public UserPrincipal getUserPrincipal(String username) {
        ManagedUser principal = this.getManagedUser(username);
        if (principal != null) {
            return principal;
        }
        principal = this.getLdapUser(username);
        if (principal != null) {
            return principal;
        }
        return this.getOidcUser(username);
    }

    public Team createTeam(String name, boolean createApiKey) {
        this.pm.currentTransaction().begin();
        Team team = new Team();
        team.setName(name);
        this.pm.makePersistent((Object)team);
        this.pm.currentTransaction().commit();
        if (createApiKey) {
            this.createApiKey(team);
        }
        return this.getObjectByUuid(Team.class, team.getUuid(), Team.FetchGroup.ALL.name());
    }

    public List<Team> getTeams() {
        this.pm.getFetchPlan().addGroup(Team.FetchGroup.ALL.name());
        Query query = this.pm.newQuery(Team.class);
        query.setOrdering("name asc");
        return (List)query.execute();
    }

    public Team updateTeam(Team transientTeam) {
        Team team = this.getObjectByUuid(Team.class, transientTeam.getUuid());
        this.pm.currentTransaction().begin();
        team.setName(transientTeam.getName());
        this.pm.currentTransaction().commit();
        return (Team)this.pm.getObjectById(Team.class, (Object)team.getId());
    }

    public boolean addUserToTeam(UserPrincipal user, Team team) {
        ArrayList<Team> teams = user.getTeams();
        boolean found = false;
        if (teams == null) {
            teams = new ArrayList<Team>();
        }
        for (Team t : teams) {
            if (!team.getUuid().equals(t.getUuid())) continue;
            found = true;
        }
        if (!found) {
            this.pm.currentTransaction().begin();
            teams.add(team);
            user.setTeams(teams);
            this.pm.currentTransaction().commit();
            return true;
        }
        return false;
    }

    public boolean removeUserFromTeam(UserPrincipal user, Team team) {
        List teams = user.getTeams();
        if (teams == null) {
            return false;
        }
        boolean found = false;
        for (Team t : teams) {
            if (!team.getUuid().equals(t.getUuid())) continue;
            found = true;
        }
        if (found) {
            this.pm.currentTransaction().begin();
            teams.remove(team);
            user.setTeams(teams);
            this.pm.currentTransaction().commit();
            return true;
        }
        return false;
    }

    public Permission createPermission(String name, String description) {
        this.pm.currentTransaction().begin();
        Permission permission = new Permission();
        permission.setName(name);
        permission.setDescription(description);
        this.pm.makePersistent((Object)permission);
        this.pm.currentTransaction().commit();
        return this.getObjectById(Permission.class, permission.getId());
    }

    public Permission getPermission(String name) {
        Query query = this.pm.newQuery(Permission.class, "name == :name");
        List result = (List)query.execute((Object)name);
        return Collections.isEmpty((Collection)result) ? null : (Permission)result.get(0);
    }

    public List<Permission> getPermissions() {
        Query query = this.pm.newQuery(Permission.class);
        query.setOrdering("name asc");
        return (List)query.execute();
    }

    public List<Permission> getEffectivePermissions(UserPrincipal user) {
        LinkedHashSet permissions = new LinkedHashSet();
        if (user.getPermissions() != null) {
            permissions.addAll(user.getPermissions());
        }
        if (user.getTeams() != null) {
            for (Team team : user.getTeams()) {
                List teamPermissions = this.getObjectById(Team.class, team.getId()).getPermissions();
                if (teamPermissions == null) continue;
                permissions.addAll(teamPermissions);
            }
        }
        return new ArrayList<Permission>(permissions);
    }

    public boolean hasPermission(UserPrincipal user, String permissionName) {
        return this.hasPermission(user, permissionName, false);
    }

    public boolean hasPermission(UserPrincipal user, String permissionName, boolean includeTeams) {
        Query query = user instanceof ManagedUser ? this.pm.newQuery(Permission.class, "name == :permissionName && managedUsers.contains(:user)") : (user instanceof LdapUser ? this.pm.newQuery(Permission.class, "name == :permissionName && ldapUsers.contains(:user)") : this.pm.newQuery(Permission.class, "name == :permissionName && oidcUsers.contains(:user)"));
        query.setResult("count(id)");
        long count = (Long)query.execute((Object)permissionName, (Object)user);
        if (count > 0L) {
            return true;
        }
        if (includeTeams) {
            for (Team team : user.getTeams()) {
                if (!this.hasPermission(team, permissionName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPermission(Team team, String permissionName) {
        Query query = this.pm.newQuery(Permission.class, "name == :permissionName && teams.contains(:team)");
        query.setResult("count(id)");
        return (Long)query.execute((Object)permissionName, (Object)team) > 0L;
    }

    public boolean hasPermission(ApiKey apiKey, String permissionName) {
        if (apiKey.getTeams() == null) {
            return false;
        }
        for (Team team : apiKey.getTeams()) {
            List teamPermissions = this.getObjectById(Team.class, team.getId()).getPermissions();
            for (Permission permission : teamPermissions) {
                if (!permission.getName().equals(permissionName)) continue;
                return true;
            }
        }
        return false;
    }

    public MappedLdapGroup getMappedLdapGroup(Team team, String dn) {
        Query query = this.pm.newQuery(MappedLdapGroup.class, "team == :team && dn == :dn");
        List result = (List)query.execute((Object)team, (Object)dn);
        return Collections.isEmpty((Collection)result) ? null : (MappedLdapGroup)result.get(0);
    }

    public List<MappedLdapGroup> getMappedLdapGroups(Team team) {
        Query query = this.pm.newQuery(MappedLdapGroup.class, "team == :team");
        return (List)query.execute((Object)team);
    }

    public List<MappedLdapGroup> getMappedLdapGroups(String dn) {
        Query query = this.pm.newQuery(MappedLdapGroup.class, "dn == :dn");
        return (List)query.execute((Object)dn);
    }

    public boolean isMapped(Team team, String dn) {
        return this.getMappedLdapGroup(team, dn) != null;
    }

    public MappedLdapGroup createMappedLdapGroup(Team team, String dn) {
        this.pm.currentTransaction().begin();
        MappedLdapGroup mapping = new MappedLdapGroup();
        mapping.setTeam(team);
        mapping.setDn(dn);
        this.pm.makePersistent((Object)mapping);
        this.pm.currentTransaction().commit();
        return this.getObjectById(MappedLdapGroup.class, mapping.getId());
    }

    public MappedOidcGroup createMappedOidcGroup(Team team, OidcGroup group) {
        this.pm.currentTransaction().begin();
        MappedOidcGroup mapping = new MappedOidcGroup();
        mapping.setTeam(team);
        mapping.setGroup(group);
        this.pm.makePersistent((Object)mapping);
        this.pm.currentTransaction().commit();
        return this.getObjectById(MappedOidcGroup.class, mapping.getId());
    }

    public MappedOidcGroup getMappedOidcGroup(Team team, OidcGroup group) {
        Query query = this.pm.newQuery(MappedOidcGroup.class, "team == :team && group == :group");
        List result = (List)query.execute((Object)team, (Object)group);
        return Collections.isEmpty((Collection)result) ? null : (MappedOidcGroup)result.get(0);
    }

    public List<MappedOidcGroup> getMappedOidcGroups(Team team) {
        Query query = this.pm.newQuery(MappedOidcGroup.class, "team == :team");
        return (List)query.execute((Object)team);
    }

    public List<MappedOidcGroup> getMappedOidcGroups(OidcGroup group) {
        Query query = this.pm.newQuery(MappedOidcGroup.class, "group == :group");
        return (List)query.execute((Object)group);
    }

    public boolean isOidcGroupMapped(Team team, OidcGroup group) {
        return this.getMappedOidcGroup(team, group) != null;
    }

    public EventServiceLog createEventServiceLog(Class<? extends Subscriber> clazz) {
        if (LoggableSubscriber.class.isAssignableFrom(clazz)) {
            this.pm.currentTransaction().begin();
            EventServiceLog log = new EventServiceLog();
            log.setSubscriberClass(clazz.getCanonicalName());
            log.setStarted(new Timestamp(new Date().getTime()));
            this.pm.makePersistent((Object)log);
            this.pm.currentTransaction().commit();
            return this.getObjectById(EventServiceLog.class, log.getId());
        }
        return null;
    }

    public EventServiceLog updateEventServiceLog(EventServiceLog eventServiceLog) {
        EventServiceLog log;
        if (eventServiceLog != null && (log = this.getObjectById(EventServiceLog.class, eventServiceLog.getId())) != null) {
            this.pm.currentTransaction().begin();
            log.setCompleted(new Timestamp(new Date().getTime()));
            this.pm.currentTransaction().commit();
            return (EventServiceLog)this.pm.getObjectById(EventServiceLog.class, (Object)log.getId());
        }
        return null;
    }

    public EventServiceLog getLatestEventServiceLog(Class<LoggableSubscriber> clazz) {
        Query query = this.pm.newQuery(EventServiceLog.class, "eventClass == :clazz");
        query.setOrdering("completed desc");
        List result = (List)query.execute(clazz);
        return Collections.isEmpty((Collection)result) ? null : (EventServiceLog)result.get(0);
    }

    public ConfigProperty getConfigProperty(String groupName, String propertyName) {
        Query query = this.pm.newQuery(ConfigProperty.class, "groupName == :groupName && propertyName == :propertyName");
        List result = (List)query.execute((Object)groupName, (Object)propertyName);
        return Collections.isEmpty((Collection)result) ? null : (ConfigProperty)result.get(0);
    }

    public List<ConfigProperty> getConfigProperties(String groupName) {
        Query query = this.pm.newQuery(ConfigProperty.class, "groupName == :groupName");
        query.setOrdering("propertyName asc");
        return (List)query.execute((Object)groupName);
    }

    public List<ConfigProperty> getConfigProperties() {
        Query query = this.pm.newQuery(ConfigProperty.class);
        query.setOrdering("groupName asc, propertyName asc");
        return (List)query.execute();
    }

    public ConfigProperty createConfigProperty(String groupName, String propertyName, String propertyValue, IConfigProperty.PropertyType propertyType, String description) {
        this.pm.currentTransaction().begin();
        ConfigProperty configProperty = new ConfigProperty();
        configProperty.setGroupName(groupName);
        configProperty.setPropertyName(propertyName);
        configProperty.setPropertyValue(propertyValue);
        configProperty.setPropertyType(propertyType);
        configProperty.setDescription(description);
        this.pm.makePersistent((Object)configProperty);
        this.pm.currentTransaction().commit();
        return this.getObjectById(ConfigProperty.class, configProperty.getId());
    }
}

